/*
 * Decompiled with CFR 0.152.
 */
package playn.scene;

import java.util.HashMap;
import java.util.Map;
import playn.core.Touch;
import playn.scene.Layer;
import playn.scene.LayerUtil;
import pythagoras.f.Point;
import react.Slot;

public class Touch
extends playn.core.Touch {

    public static class Dispatcher
    extends Slot<Touch.Event[]> {
        private final Layer root;
        private final boolean bubble;
        private final Point scratch = new Point();
        private final Map<Integer, Interaction> activeIacts = new HashMap<Integer, Interaction>();

        public Dispatcher(Layer root, boolean bubble) {
            this.root = root;
            this.bubble = bubble;
        }

        public void onEmit(Touch.Event[] events) {
            Touch.Event[] eventArray = events;
            int n = events.length;
            int n2 = 0;
            while (n2 < n) {
                Layer hitLayer;
                Touch.Event event = eventArray[n2];
                Interaction iact = this.activeIacts.get(event.id);
                if (iact == null && event.kind.isStart && (hitLayer = LayerUtil.getHitLayer(this.root, this.scratch.set(event.x, event.y))) != null) {
                    iact = new Interaction(hitLayer, this.bubble);
                    this.activeIacts.put(event.id, iact);
                }
                if (iact != null) {
                    iact.dispatch(event);
                }
                if (event.kind.isEnd) {
                    this.activeIacts.remove(event.id);
                }
                ++n2;
            }
        }
    }

    public static class Interaction
    extends playn.scene.Interaction<Touch.Event> {
        Interaction(Layer hitLayer, boolean bubble) {
            super(hitLayer, bubble);
        }

        @Override
        protected Touch.Event newCancelEvent(Touch.Event source) {
            return source == null ? new Touch.Event(0, 0.0, 0.0f, 0.0f, Touch.Event.Kind.CANCEL, 0) : new Touch.Event(0, source.time, source.x, source.y, Touch.Event.Kind.CANCEL, source.id, source.pressure, source.size);
        }
    }

    public static abstract class Listener
    extends Slot<Object> {
        public void onStart(Interaction iact) {
        }

        public void onMove(Interaction iact) {
        }

        public void onEnd(Interaction iact) {
        }

        public void onCancel(Interaction iact) {
        }

        public final void onEmit(Object event) {
            if (event instanceof Interaction) {
                Interaction iact = (Interaction)event;
                switch (((Touch.Event)iact.event).kind) {
                    case START: {
                        this.onStart(iact);
                        break;
                    }
                    case MOVE: {
                        this.onMove(iact);
                        break;
                    }
                    case END: {
                        this.onEnd(iact);
                        break;
                    }
                    case CANCEL: {
                        this.onCancel(iact);
                        break;
                    }
                }
            }
        }
    }
}

