/*
 * Decompiled with CFR 0.152.
 */
package playn.scene;

import playn.core.Mouse;
import playn.scene.Layer;
import playn.scene.LayerUtil;
import pythagoras.f.Point;
import react.Slot;

public class Mouse
extends playn.core.Mouse {
    protected static final CancelEvent cancelEvent = new CancelEvent();

    protected static class CancelEvent
    extends Mouse.Event {
        public CancelEvent() {
            super(0, 0.0, 0.0f, 0.0f);
        }
    }

    public static class Dispatcher
    extends Slot<Mouse.Event> {
        private final Layer root;
        private final boolean bubble;
        private final Point scratch = new Point();
        private Interaction currentIact;
        private Layer hoverLayer;

        public Dispatcher(Layer root, boolean bubble) {
            this.root = root;
            this.bubble = bubble;
        }

        public void onEmit(Mouse.Event event) {
            if (event instanceof Mouse.ButtonEvent) {
                Mouse.ButtonEvent bevent = (Mouse.ButtonEvent)event;
                if (bevent.down) {
                    Layer hitLayer;
                    if (this.currentIact == null && (hitLayer = LayerUtil.getHitLayer(this.root, this.scratch.set(event.x, event.y))) != null) {
                        this.currentIact = new Interaction(hitLayer, this.bubble, false);
                    }
                    if (this.currentIact != null) {
                        this.currentIact.add(bevent.button);
                        this.currentIact.dispatch(event);
                    }
                } else if (this.currentIact == null) {
                    this.dispatchSolo(event);
                } else {
                    boolean done = this.currentIact.remove(bevent.button);
                    this.currentIact.dispatch(event);
                    if (done) {
                        this.currentIact = null;
                    }
                }
            } else if (event instanceof Mouse.MotionEvent) {
                Layer hitLayer = LayerUtil.getHitLayer(this.root, this.scratch.set(event.x, event.y));
                if (this.currentIact != null) {
                    this.currentIact.dispatch(event);
                } else if (hitLayer != null) {
                    new Interaction(hitLayer, this.bubble, true).dispatch(event);
                }
                if (hitLayer != this.hoverLayer) {
                    HoverEvent hevent;
                    if (this.hoverLayer != null) {
                        hevent = new HoverEvent(0, event.time, event.x, event.y, false);
                        new Interaction(this.hoverLayer, this.bubble, true).dispatch(hevent);
                    }
                    this.hoverLayer = hitLayer;
                    if (hitLayer != null) {
                        hevent = new HoverEvent(0, event.time, event.x, event.y, true);
                        new Interaction(hitLayer, this.bubble, true).dispatch(hevent);
                    }
                }
            } else if (event instanceof Mouse.WheelEvent) {
                if (this.currentIact != null) {
                    this.currentIact.dispatch(event);
                } else {
                    this.dispatchSolo(event);
                }
            }
        }

        private void dispatchSolo(Mouse.Event event) {
            Layer hitLayer = LayerUtil.getHitLayer(this.root, this.scratch.set(event.x, event.y));
            if (hitLayer != null) {
                new Interaction(hitLayer, this.bubble, true).dispatch(event);
            }
        }
    }

    public static class HoverEvent
    extends Mouse.Event {
        public final boolean inside;

        public HoverEvent(int flags, double time, float x, float y, boolean inside) {
            super(flags, time, x, y);
            this.inside = inside;
        }

        protected String name() {
            return "Hover";
        }

        protected void addFields(StringBuilder builder) {
            super.addFields(builder);
            builder.append(", inside=").append(this.inside);
        }
    }

    public static class Interaction
    extends playn.scene.Interaction<Mouse.Event> {
        private final boolean solo;
        private int buttons;

        Interaction(Layer hitLayer, boolean bubble, boolean solo) {
            super(hitLayer, bubble);
            this.solo = solo;
        }

        void add(Mouse.ButtonEvent.Id button) {
            this.buttons |= 1 << button.ordinal();
        }

        boolean remove(Mouse.ButtonEvent.Id button) {
            this.buttons &= ~(1 << button.ordinal());
            return this.buttons == 0;
        }

        void emit(Listener lner) {
            Mouse.Event mevent = (Mouse.Event)this.event;
            if (mevent instanceof Mouse.ButtonEvent) {
                lner.onButton((Mouse.ButtonEvent)mevent, this);
            } else if (mevent instanceof Mouse.MotionEvent) {
                if (this.solo) {
                    lner.onMotion((Mouse.MotionEvent)mevent, this);
                } else {
                    lner.onDrag((Mouse.MotionEvent)mevent, this);
                }
            } else if (mevent instanceof HoverEvent) {
                lner.onHover((HoverEvent)mevent, this);
            } else if (mevent instanceof Mouse.WheelEvent) {
                lner.onWheel((Mouse.WheelEvent)mevent, this);
            }
        }

        @Override
        protected Mouse.Event newCancelEvent(Mouse.Event source) {
            return cancelEvent;
        }
    }

    public static abstract class Listener
    extends Slot<Object> {
        public void onMotion(Mouse.MotionEvent event, Interaction iact) {
        }

        public void onHover(HoverEvent event, Interaction iact) {
        }

        public void onButton(Mouse.ButtonEvent event, Interaction iact) {
        }

        public void onDrag(Mouse.MotionEvent event, Interaction iact) {
        }

        public void onWheel(Mouse.WheelEvent event, Interaction iact) {
        }

        public void onCancel() {
        }

        public final void onEmit(Object event) {
            if (event instanceof Interaction) {
                ((Interaction)event).emit(this);
            } else if (event == cancelEvent) {
                this.onCancel();
            }
        }
    }
}

