/*
 * Decompiled with CFR 0.152.
 */
package playn.scene;

import playn.core.Surface;
import playn.scene.Layer;
import pythagoras.f.AffineTransform;
import pythagoras.f.IDimension;
import pythagoras.f.IPoint;
import pythagoras.f.IVector;
import pythagoras.f.Point;
import pythagoras.f.Vector;

public abstract class ClippedLayer
extends Layer {
    private final Point pos = new Point();
    private final Vector size = new Vector();
    private float width;
    private float height;

    public ClippedLayer(float width, float height) {
        this.width = width;
        this.height = height;
    }

    @Override
    public float width() {
        return this.width;
    }

    @Override
    public float height() {
        return this.height;
    }

    public ClippedLayer setSize(float width, float height) {
        this.width = width;
        this.height = height;
        this.checkOrigin();
        return this;
    }

    public ClippedLayer setSize(IDimension size) {
        return this.setSize(size.width(), size.height());
    }

    public ClippedLayer setWidth(float width) {
        this.width = width;
        this.checkOrigin();
        return this;
    }

    public ClippedLayer setHeight(float height) {
        this.height = height;
        this.checkOrigin();
        return this;
    }

    protected boolean disableClip() {
        return false;
    }

    @Override
    protected final void paintImpl(Surface surf) {
        if (this.disableClip()) {
            this.paintClipped(surf);
        } else {
            AffineTransform tx = surf.tx();
            float originX = this.originX();
            float originY = this.originY();
            tx.translate(originX, originY);
            tx.transform((IPoint)this.pos.set(-originX, -originY), this.pos);
            tx.transform((IVector)this.size.set(this.width, this.height), this.size);
            tx.translate(-originX, -originY);
            boolean nonEmpty = surf.startClipped((int)this.pos.x, (int)this.pos.y, Math.round(Math.abs(this.size.x)), Math.round(Math.abs(this.size.y)));
            try {
                if (nonEmpty) {
                    this.paintClipped(surf);
                }
            }
            finally {
                surf.endClipped();
            }
        }
    }

    protected abstract void paintClipped(Surface var1);
}

