/*
 * Decompiled with CFR 0.152.
 */
package playn.robovm;

import java.io.UnsupportedEncodingException;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSError;
import org.robovm.apple.foundation.NSHTTPURLResponse;
import org.robovm.apple.foundation.NSMutableData;
import org.robovm.apple.foundation.NSMutableURLRequest;
import org.robovm.apple.foundation.NSURL;
import org.robovm.apple.foundation.NSURLConnection;
import org.robovm.apple.foundation.NSURLConnectionDataDelegateAdapter;
import org.robovm.apple.foundation.NSURLConnectionDelegate;
import org.robovm.apple.foundation.NSURLRequest;
import org.robovm.apple.foundation.NSURLResponse;
import org.robovm.apple.uikit.UIImage;
import playn.core.Image;
import playn.core.Net;
import playn.core.Scale;
import playn.robovm.RoboImage;
import playn.robovm.RoboPlatform;
import playn.robovm.RoboWebSocket;
import react.RFuture;
import react.RPromise;

public class RoboNet
extends Net {
    private final RoboPlatform plat;

    public RoboNet(RoboPlatform plat) {
        this.plat = plat;
    }

    public Net.WebSocket createWebSocket(String url, Net.WebSocket.Listener listener) {
        return new RoboWebSocket(this.plat.exec(), url, listener);
    }

    protected RFuture<Net.Response> execute(Net.Builder req) {
        RPromise result = this.plat.exec().deferredPromise();
        NSMutableURLRequest mreq = new NSMutableURLRequest();
        mreq.setURL(new NSURL(req.url));
        for (Net.Header header : req.headers) {
            mreq.setHTTPHeaderField(header.name, header.value);
        }
        mreq.setHTTPMethod(req.method());
        if (req.isPost()) {
            mreq.setHTTPHeaderField("Content-type", req.contentType());
            if (req.payloadString != null) {
                try {
                    mreq.setHTTPBody(new NSData(req.payloadString.getBytes("UTF-8")));
                }
                catch (UnsupportedEncodingException uee) {
                    throw new RuntimeException(uee);
                }
            } else {
                mreq.setHTTPBody(new NSData(req.payloadBytes));
            }
        }
        this.sendRequest((NSURLRequest)mreq, (RPromise<Net.Response>)result);
        return result;
    }

    protected void sendRequest(final NSURLRequest req, final RPromise<Net.Response> result) {
        new NSURLConnection(req, (NSURLConnectionDelegate)new NSURLConnectionDataDelegateAdapter(){
            private NSMutableData data;
            private int rspCode = -1;
            private Map<String, String> headers;

            public void didReceiveResponse(NSURLConnection conn, NSURLResponse rsp) {
                this.data = new NSMutableData();
                if (rsp instanceof NSHTTPURLResponse) {
                    NSHTTPURLResponse hrsp = (NSHTTPURLResponse)rsp;
                    this.rspCode = (int)hrsp.getStatusCode();
                    this.headers = hrsp.getAllHeaderFields();
                }
            }

            public void didReceiveData(NSURLConnection conn, NSData data) {
                this.data.append(data);
            }

            public void didFail(NSURLConnection conn, NSError error) {
                String errmsg = error.getLocalizedDescription();
                result.fail((Throwable)(this.rspCode > 0 ? new Net.HttpException(this.rspCode, errmsg) : new Exception(errmsg)));
            }

            public void didFinishLoading(NSURLConnection conn) {
                result.succeed((Object)new Net.Response(this.rspCode){

                    protected Map<String, List<String>> extractHeaders() {
                        HashMap<String, List<String>> headerMap = new HashMap<String, List<String>>();
                        if (headers != null) {
                            for (Map.Entry entry : headers.entrySet()) {
                                headerMap.put((String)entry.getKey(), Collections.singletonList((String)entry.getValue()));
                            }
                        }
                        return headerMap;
                    }

                    public String payloadString() {
                        try {
                            return new String(data.getBytes(), "UTF-8");
                        }
                        catch (UnsupportedEncodingException uee) {
                            throw new RuntimeException(uee);
                        }
                    }

                    public byte[] payload() {
                        return data.getBytes();
                    }

                    public Image payloadImage(Scale scale) {
                        UIImage img = new UIImage((NSData)data);
                        return new RoboImage(RoboNet.this.plat.graphics(), scale, img.getCGImage(), req.getURL().toString());
                    }
                });
            }
        }, true);
    }
}

