/*
 * Decompiled with CFR 0.152.
 */
package playn.robovm;

import org.robovm.apple.coregraphics.CGBitmapContext;
import org.robovm.apple.coregraphics.CGBitmapInfo;
import org.robovm.apple.coregraphics.CGColorSpace;
import org.robovm.apple.coregraphics.CGImageAlphaInfo;
import org.robovm.apple.coregraphics.CGRect;
import org.robovm.apple.foundation.Foundation;
import org.robovm.apple.uikit.UIDevice;
import org.robovm.apple.uikit.UIDeviceOrientation;
import org.robovm.apple.uikit.UIScreen;
import org.robovm.apple.uikit.UIUserInterfaceIdiom;
import playn.core.Canvas;
import playn.core.GL20;
import playn.core.Gradient;
import playn.core.Graphics;
import playn.core.Path;
import playn.core.Platform;
import playn.core.Scale;
import playn.core.TextFormat;
import playn.core.TextLayout;
import playn.core.TextWrap;
import playn.robovm.RoboCanvas;
import playn.robovm.RoboCanvasImage;
import playn.robovm.RoboGL20;
import playn.robovm.RoboGradient;
import playn.robovm.RoboPath;
import playn.robovm.RoboPlatform;
import playn.robovm.RoboTextLayout;
import pythagoras.f.Dimension;
import pythagoras.f.IDimension;
import pythagoras.f.IPoint;
import pythagoras.f.Point;

public class RoboGraphics
extends Graphics {
    static final CGColorSpace colorSpace = CGColorSpace.createDeviceRGB();
    final Platform plat;
    private final RoboPlatform.Config config;
    private final float touchScale;
    private final Point touchTemp = new Point();
    private final Dimension screenSize = new Dimension();
    private int defaultFramebuffer;
    private static final int S_SIZE = 10;
    final CGBitmapContext scratchCtx = RoboGraphics.createCGBitmap(10, 10);

    private static boolean useHalfSize(RoboPlatform.Config config) {
        boolean isPad = UIDevice.getCurrentDevice().getUserInterfaceIdiom() == UIUserInterfaceIdiom.Pad;
        return isPad && config.iPadLikePhone;
    }

    private static Scale viewScale(RoboPlatform.Config config) {
        float deviceScale = (float)(Foundation.getMajorSystemVersion() >= 8 ? UIScreen.getMainScreen().getNativeScale() : UIScreen.getMainScreen().getScale());
        boolean useHalfSize = RoboGraphics.useHalfSize(config);
        return new Scale((float)(useHalfSize ? 2 : 1) * deviceScale);
    }

    public RoboGraphics(Platform plat, RoboPlatform.Config config, CGRect bounds) {
        super(plat, (GL20)new RoboGL20(), RoboGraphics.viewScale(config));
        this.plat = plat;
        this.config = config;
        this.touchScale = RoboGraphics.useHalfSize(config) ? 2.0f : 1.0f;
        this.boundsChanged(bounds);
    }

    public IDimension screenSize() {
        CGRect screenBounds = UIScreen.getMainScreen().getBounds();
        this.screenSize.width = (int)screenBounds.getWidth();
        this.screenSize.height = (int)screenBounds.getHeight();
        if (RoboGraphics.useHalfSize(this.config)) {
            this.screenSize.width /= 2.0f;
            this.screenSize.height /= 2.0f;
        }
        return this.screenSize;
    }

    public Canvas createCanvas(Scale scale, int pixelWidth, int pixelHeight) {
        return new RoboCanvas(this, new RoboCanvasImage((Graphics)this, scale, pixelWidth, pixelHeight, this.config.interpolateCanvasDrawing));
    }

    public Path createPath() {
        return new RoboPath();
    }

    public Gradient createGradient(Gradient.Config cfg) {
        if (cfg instanceof Gradient.Linear) {
            return new RoboGradient.Linear((Gradient.Linear)cfg);
        }
        if (cfg instanceof Gradient.Radial) {
            return new RoboGradient.Radial((Gradient.Radial)cfg);
        }
        throw new IllegalArgumentException("Unknown config: " + cfg);
    }

    public TextLayout layoutText(String text, TextFormat format) {
        return RoboTextLayout.layoutText(this, text, format);
    }

    public TextLayout[] layoutText(String text, TextFormat format, TextWrap wrap) {
        return RoboTextLayout.layoutText(this, text, format, wrap);
    }

    protected int defaultFramebuffer() {
        return this.defaultFramebuffer;
    }

    static CGBitmapContext createCGBitmap(int width, int height) {
        return CGBitmapContext.create((long)width, (long)height, (long)8L, (long)(4 * width), (CGColorSpace)colorSpace, (CGBitmapInfo)new CGBitmapInfo(CGImageAlphaInfo.PremultipliedLast.value()));
    }

    static Graphics.OrientationDetail toOrientationDetail(UIDeviceOrientation orient) {
        switch (orient) {
            case Portrait: {
                return Graphics.OrientationDetail.PORTRAIT;
            }
            case PortraitUpsideDown: {
                return Graphics.OrientationDetail.PORTRAIT_UPSIDE_DOWN;
            }
            case LandscapeLeft: {
                return Graphics.OrientationDetail.LANDSCAPE_LEFT;
            }
            case LandscapeRight: {
                return Graphics.OrientationDetail.LANDSCAPE_RIGHT;
            }
            case FaceUp: {
                return Graphics.OrientationDetail.FACE_UP;
            }
            case FaceDown: {
                return Graphics.OrientationDetail.FACE_DOWN;
            }
        }
        return Graphics.OrientationDetail.UNKNOWN;
    }

    void viewDidInit(CGRect bounds) {
        this.defaultFramebuffer = this.gl.glGetInteger(36006);
        if (this.defaultFramebuffer == 0) {
            throw new IllegalStateException("Failed to determine defaultFramebuffer");
        }
        this.boundsChanged(bounds);
    }

    void boundsChanged(CGRect bounds) {
        this.viewportChanged(this.scale().scaledCeil((float)bounds.getWidth()), this.scale().scaledCeil((float)bounds.getHeight()));
        this.orientDetailM.update((Object)RoboGraphics.toOrientationDetail(UIDevice.getCurrentDevice().getOrientation()));
    }

    IPoint transformTouch(float x, float y) {
        return this.touchTemp.set(x / this.touchScale, y / this.touchScale);
    }
}

