/*
 * Decompiled with CFR 0.152.
 */
package playn.robovm;

import java.io.File;
import java.io.FileNotFoundException;
import java.nio.ByteBuffer;
import org.robovm.apple.coregraphics.CGImage;
import org.robovm.apple.foundation.NSBundle;
import org.robovm.apple.foundation.NSData;
import org.robovm.apple.foundation.NSDataReadingOptions;
import org.robovm.apple.uikit.UIImage;
import playn.core.Assets;
import playn.core.Image;
import playn.core.ImageImpl;
import playn.core.Net;
import playn.core.Scale;
import playn.core.Sound;
import playn.robovm.RoboImage;
import playn.robovm.RoboPlatform;
import react.SignalView;
import react.Slot;

public class RoboAssets
extends Assets {
    private final RoboPlatform plat;
    private final File bundleRoot = new File(NSBundle.getMainBundle().getBundlePath());
    private File assetRoot = new File(this.bundleRoot, "assets");
    protected static final NSDataReadingOptions READ_OPTS = new NSDataReadingOptions(NSDataReadingOptions.MappedIfSafe.value() | NSDataReadingOptions.Uncached.value());

    public RoboAssets(RoboPlatform plat) {
        super(plat.exec());
        this.plat = plat;
    }

    public void setPathPrefix(String pathPrefix) {
        this.assetRoot = new File(this.bundleRoot, pathPrefix);
    }

    public Image getRemoteImage(final String url, int width, int height) {
        final ImageImpl image = this.createImage(true, width, height, url);
        this.plat.net().req(url).execute().onSuccess((SignalView.Listener)new Slot<Net.Response>(){

            public void onEmit(Net.Response rsp) {
                try {
                    image.succeed(RoboAssets.this.toData(Scale.ONE, new UIImage(new NSData(rsp.payload()))));
                }
                catch (Throwable t) {
                    RoboAssets.this.plat.log().warn("Failed to decode remote image [url=" + url + "]", t);
                    image.fail(t);
                }
            }
        }).onFailure((SignalView.Listener)new Slot<Throwable>(){

            public void onEmit(Throwable cause) {
                image.fail(cause);
            }
        });
        return image;
    }

    public Sound getSound(String path) {
        return this.createSound(path, false);
    }

    public Sound getMusic(String path) {
        return this.createSound(path, true);
    }

    public String getTextSync(String path) throws Exception {
        byte[] bytes;
        this.plat.log().debug("Loading text " + path);
        ByteBuffer data = this.getBytesSync(path);
        if (data.hasArray()) {
            bytes = data.array();
        } else {
            bytes = new byte[data.remaining()];
            data.get(bytes);
        }
        return new String(bytes, "UTF-8");
    }

    public ByteBuffer getBytesSync(String path) throws Exception {
        File fullPath = this.resolvePath(path);
        this.plat.log().debug("Loading bytes " + fullPath);
        return NSData.read((File)fullPath, (NSDataReadingOptions)READ_OPTS).asByteBuffer();
    }

    protected ImageImpl.Data load(String path) throws Exception {
        Exception error = null;
        for (Scale.ScaledResource rsrc : this.plat.graphics().scale().getScaledResources(path)) {
            File fullPath = this.resolvePath(rsrc.path);
            if (!fullPath.exists()) continue;
            UIImage img = UIImage.getImage((File)fullPath);
            if (img != null) {
                return this.toData(rsrc.scale, img);
            }
            this.plat.log().warn("Failed to load image '" + fullPath + "'.");
            error = new Exception("Failed to load " + fullPath);
        }
        if (error == null) {
            File fullPath = this.resolvePath(path);
            this.plat.log().warn("Missing image '" + fullPath + "'.");
            error = new FileNotFoundException(fullPath.toString());
        }
        throw error;
    }

    protected ImageImpl createImage(boolean async, int rwid, int rhei, String source) {
        return new RoboImage(this.plat, async, rwid, rhei, source);
    }

    private ImageImpl.Data toData(Scale scale, UIImage image) {
        CGImage bitmap = image.getCGImage();
        return new ImageImpl.Data(scale, (Object)bitmap, (int)bitmap.getWidth(), (int)bitmap.getHeight());
    }

    protected File resolvePath(String path) {
        return new File(this.assetRoot, path);
    }

    private Sound createSound(String path, boolean isMusic) {
        for (String encpath : new String[]{path + ".caf", path + ".aifc", path + ".mp3"}) {
            File fullPath = this.resolvePath(encpath);
            if (!fullPath.exists()) continue;
            return this.plat.audio().createSound(fullPath, isMusic);
        }
        this.plat.log().warn("Missing sound: " + path);
        return new Sound.Error((Exception)new FileNotFoundException(path));
    }
}

