/*
 * Decompiled with CFR 0.152.
 */
package playn.robovm;

import org.robovm.apple.coregraphics.CGBitmapContext;
import org.robovm.apple.coregraphics.CGImage;
import org.robovm.apple.coregraphics.CGInterpolationQuality;
import playn.core.Graphics;
import playn.core.Scale;
import playn.core.Texture;
import playn.robovm.RoboGraphics;
import playn.robovm.RoboImage;

public class RoboCanvasImage
extends RoboImage {
    CGBitmapContext bctx;

    public RoboCanvasImage(Graphics gfx, Scale scale, int pixelWidth, int pixelHeight, boolean interpolate) {
        super(gfx, scale, pixelWidth, pixelHeight, "<canvas>");
        this.bctx = RoboGraphics.createCGBitmap(pixelWidth, pixelHeight);
        if (!interpolate) {
            this.bctx.setInterpolationQuality(CGInterpolationQuality.None);
        }
    }

    @Override
    public CGImage cgImage() {
        return this.bctx.toImage();
    }

    @Override
    protected void upload(Graphics gfx, Texture tex) {
        this.upload(gfx, tex.id, this.pixelWidth, this.pixelHeight, this.bctx.getData());
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.bctx != null) {
            this.bctx.dispose();
            this.bctx = null;
        }
    }
}

