/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import org.jbox2d.callbacks.DebugDraw;
import org.jbox2d.common.Color3f;
import org.jbox2d.common.IViewportTransform;
import org.jbox2d.common.OBBViewportTransform;
import org.jbox2d.common.Transform;
import org.jbox2d.common.Vec2;
import playn.core.Canvas;
import playn.core.Color;
import playn.core.Path;
import playn.core.Platform;

public class DebugDrawBox2D
extends DebugDraw {
    private final Platform plat;
    private float strokeWidth;
    private int strokeAlpha;
    private int fillAlpha;
    private float cameraX;
    private float cameraY;
    private float cameraScale = 1.0f;
    private static float cacheFillR;
    private static float cacheFillG;
    private static float cacheFillB;
    private static float cacheStrokeR;
    private static float cacheStrokeG;
    private static float cacheStrokeB;
    private final Vec2 tempVec1 = new Vec2();
    private final Vec2 tempVec2 = new Vec2();
    private final Vec2 tempVec3 = new Vec2();
    public final Canvas canvas;

    public DebugDrawBox2D(Platform plat, float width, float height) {
        super((IViewportTransform)new OBBViewportTransform());
        this.plat = plat;
        this.viewportTransform.setYFlip(true);
        this.strokeWidth = 1.0f;
        this.strokeAlpha = 255;
        this.fillAlpha = 150;
        this.canvas = plat.graphics().createCanvas(width, height);
        this.canvas.setStrokeWidth(this.strokeWidth);
        this.setStrokeColorFromCache();
        this.setFillColorFromCache();
    }

    public void drawCircle(Vec2 center, float radius, Color3f color) {
        this.setFillColor(color);
        this.setStrokeColor(color);
        this.tempVec1.set(center.x + radius, center.y + radius);
        this.getWorldToScreenToOut(this.tempVec1, this.tempVec1);
        this.getWorldToScreenToOut(center, this.tempVec2);
        this.canvas.fillCircle(this.tempVec2.x, this.tempVec2.y, this.tempVec1.x - this.tempVec2.x);
        this.canvas.strokeCircle(this.tempVec2.x, this.tempVec2.y, this.tempVec1.x - this.tempVec2.x);
    }

    public void drawPoint(Vec2 argPoint, float argRadiusOnScreen, Color3f color) {
        this.setFillColor(color);
        this.setStrokeColor(color);
        this.getWorldToScreenToOut(argPoint, this.tempVec1);
        this.canvas.fillCircle(this.tempVec1.x, this.tempVec1.y, argRadiusOnScreen);
    }

    public void drawSegment(Vec2 p1, Vec2 p2, Color3f color) {
        this.setStrokeColor(color);
        this.setFillColor(color);
        this.getWorldToScreenToOut(p1, this.tempVec1);
        this.getWorldToScreenToOut(p2, this.tempVec2);
        this.canvas.drawLine(this.tempVec1.x, this.tempVec1.y, this.tempVec2.x, this.tempVec2.y);
    }

    public void drawSolidCircle(Vec2 center, float radius, Vec2 axis, Color3f color) {
        this.setFillColor(color);
        this.setStrokeColor(color);
        this.tempVec1.set(center.x + radius, center.y + radius);
        this.getWorldToScreenToOut(this.tempVec1, this.tempVec1);
        this.getWorldToScreenToOut(center, this.tempVec2);
        this.getWorldToScreenToOut(axis, this.tempVec3);
        this.canvas.fillCircle(this.tempVec2.x, this.tempVec2.y, this.tempVec1.x - this.tempVec2.x);
        this.canvas.strokeCircle(this.tempVec2.x, this.tempVec2.y, this.tempVec1.x - this.tempVec2.x);
    }

    public void drawSolidPolygon(Vec2[] vertices, int vertexCount, Color3f color) {
        this.setFillColor(color);
        this.setStrokeColor(color);
        Path path = this.canvas.createPath();
        for (int i = 0; i < vertexCount; ++i) {
            this.getWorldToScreenToOut(vertices[i], this.tempVec1);
            if (i == 0) {
                path.moveTo(this.tempVec1.x, this.tempVec1.y);
                continue;
            }
            path.lineTo(this.tempVec1.x, this.tempVec1.y);
        }
        path.close();
        this.canvas.fillPath(path);
        this.canvas.strokePath(path);
    }

    public void drawString(float x, float y, String s, Color3f color) {
        this.plat.log().info("drawString not yet implemented in DebugDrawBox2D: " + s);
    }

    public void drawTransform(Transform xf) {
        this.getWorldToScreenToOut(xf.p, this.tempVec1);
        this.tempVec2.setZero();
        this.canvas.setStrokeColor(Color.rgb((int)1, (int)0, (int)0));
        this.tempVec2.x = xf.p.x;
        this.tempVec2.y = xf.p.y;
        this.getWorldToScreenToOut(this.tempVec2, this.tempVec2);
        this.canvas.drawLine(this.tempVec1.x, this.tempVec1.y, this.tempVec2.x, this.tempVec2.y);
        this.canvas.setStrokeColor(Color.rgb((int)0, (int)1, (int)0));
        this.tempVec2.x = xf.p.x;
        this.tempVec2.y = xf.p.y;
        this.getWorldToScreenToOut(this.tempVec2, this.tempVec2);
        this.canvas.drawLine(this.tempVec1.x, this.tempVec1.y, this.tempVec2.x, this.tempVec2.y);
        this.canvas.setStrokeColor(Color.argb((int)this.strokeAlpha, (int)1, (int)0, (int)0));
    }

    public int getFillAlpha() {
        return this.fillAlpha;
    }

    public int getStrokeAlpha() {
        return this.strokeAlpha;
    }

    public float getStrokeWidth() {
        return this.strokeWidth;
    }

    public void setCamera(float x, float y, float scale) {
        this.cameraX = x;
        this.cameraY = y;
        this.cameraScale = scale;
        this.updateCamera();
    }

    public void setCameraScale(float scale) {
        this.cameraScale = scale;
        this.updateCamera();
    }

    public void setCameraX(float x) {
        this.cameraX = x;
        this.updateCamera();
    }

    public void setCameraY(float y) {
        this.cameraY = y;
        this.updateCamera();
    }

    public void setFillAlpha(int fillAlpha) {
        this.fillAlpha = fillAlpha;
        this.setFillColorFromCache();
    }

    public void setFlipY(boolean flip) {
        this.viewportTransform.setYFlip(flip);
    }

    public void setStrokeAlpha(int strokeAlpha) {
        this.strokeAlpha = strokeAlpha;
        this.setStrokeColorFromCache();
    }

    public void setStrokeWidth(float strokeWidth) {
        this.strokeWidth = strokeWidth;
        this.canvas.setStrokeWidth(strokeWidth);
    }

    private void setFillColor(Color3f color) {
        if (cacheFillR != color.x || cacheFillG != color.y || cacheFillB != color.z) {
            cacheFillR = color.x;
            cacheFillG = color.y;
            cacheFillB = color.z;
            this.setFillColorFromCache();
        }
    }

    private void setFillColorFromCache() {
        this.canvas.setFillColor(Color.argb((int)this.fillAlpha, (int)((int)(255.0f * cacheFillR)), (int)((int)(255.0f * cacheFillG)), (int)((int)(255.0f * cacheFillB))));
    }

    private void setStrokeColor(Color3f color) {
        if (cacheStrokeR != color.x || cacheStrokeG != color.y || cacheStrokeB != color.z) {
            cacheStrokeR = color.x;
            cacheStrokeG = color.y;
            cacheStrokeB = color.z;
            this.setStrokeColorFromCache();
        }
    }

    private void setStrokeColorFromCache() {
        this.canvas.setStrokeColor(Color.argb((int)this.strokeAlpha, (int)((int)(255.0f * cacheStrokeR)), (int)((int)(255.0f * cacheStrokeG)), (int)((int)(255.0f * cacheStrokeB))));
    }

    private void updateCamera() {
        super.setCamera(this.cameraX, this.cameraY, this.cameraScale);
    }
}

