/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import playn.core.Platform;
import playn.java.JavaPlatform;
import playn.java.SWTGraphics;
import playn.java.SWTInput;

public class SWTPlatform
extends JavaPlatform {
    private final Display display;
    private final Shell shell;
    private final Composite comp;
    private final SWTGraphics graphics;
    private final SWTInput input;

    public SWTPlatform(JavaPlatform.Config config) {
        super(config);
        Display.setAppName((String)config.appName);
        this.display = new Display();
        this.shell = new Shell(this.display);
        this.shell.setLayout((Layout)new FillLayout());
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellActivated(ShellEvent e) {
                SWTPlatform.this.dispatchEvent(SWTPlatform.this.lifecycle, Platform.Lifecycle.RESUME);
            }

            public void shellDeactivated(ShellEvent e) {
                SWTPlatform.this.dispatchEvent(SWTPlatform.this.lifecycle, Platform.Lifecycle.PAUSE);
            }
        });
        this.comp = new Composite((Composite)this.shell, 0);
        this.comp.setLayout(null);
        this.graphics = new SWTGraphics(this, this.comp);
        this.input = new SWTInput(this);
    }

    public Display display() {
        return this.display;
    }

    public Shell shell() {
        return this.shell;
    }

    public Composite composite() {
        return this.comp;
    }

    public SWTGraphics graphics() {
        return this.graphics;
    }

    public SWTInput input() {
        return this.input;
    }

    protected void loop() {
        this.shell.setText(this.config.appName);
        this.shell.open();
        this.display.asyncExec(new Runnable(){

            @Override
            public void run() {
                if (!SWTPlatform.this.shell.isDisposed()) {
                    SWTPlatform.this.graphics.onBeforeFrame();
                    SWTPlatform.this.emitFrame();
                    SWTPlatform.this.graphics.onAfterFrame();
                    SWTPlatform.this.display.asyncExec((Runnable)this);
                }
            }
        });
        while (!this.shell.isDisposed()) {
            if (this.display.readAndDispatch()) continue;
            this.display.sleep();
        }
        this.display.dispose();
    }
}

