/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import playn.core.Key;
import playn.core.Keyboard;
import playn.core.Mouse;
import playn.java.JavaInput;
import playn.java.JavaPlatform;
import playn.java.SWTPlatform;
import react.RFuture;
import react.RPromise;

public class SWTInput
extends JavaInput {
    private final SWTPlatform plat;

    public SWTInput(SWTPlatform splat) {
        super((JavaPlatform)splat);
        this.plat = splat;
        this.plat.display().addFilter(3, new Listener(){

            public void handleEvent(Event event) {
                Mouse.ButtonEvent.Id btn;
                if (event.widget == ((SWTInput)SWTInput.this).plat.graphics().canvas && (btn = SWTInput.this.mapButton(event.button)) != null) {
                    SWTInput.this.emitMouseButton(SWTInput.this.mods(event), event.time, event.x, event.y, btn, true);
                }
            }
        });
        this.plat.display().addFilter(4, new Listener(){

            public void handleEvent(Event event) {
                Mouse.ButtonEvent.Id btn;
                if (event.widget == ((SWTInput)SWTInput.this).plat.graphics().canvas && (btn = SWTInput.this.mapButton(event.button)) != null) {
                    SWTInput.this.emitMouseButton(SWTInput.this.mods(event), event.time, event.x, event.y, btn, false);
                }
            }
        });
        this.plat.display().addFilter(5, new Listener(){
            private float lastX;
            private float lastY;

            public void handleEvent(Event event) {
                if (event.widget == ((SWTInput)SWTInput.this).plat.graphics().canvas) {
                    float dx = (float)event.x - this.lastX;
                    float dy = (float)event.y - this.lastY;
                    SWTInput.this.emitMouseMotion(SWTInput.this.mods(event), event.time, event.x, event.y, dx, dy);
                }
            }
        });
        this.plat.display().addFilter(37, new Listener(){

            public void handleEvent(Event event) {
                if (event.widget == ((SWTInput)SWTInput.this).plat.graphics().canvas) {
                    SWTInput.this.emitMouseWheel(SWTInput.this.mods(event), event.time, event.x, event.y, -event.count);
                }
            }
        });
        this.plat.display().addFilter(1, new Listener(){

            public void handleEvent(Event event) {
                Key key = SWTInput.this.translateKey(event.keyCode);
                if (key != null) {
                    SWTInput.this.emitKeyPress(SWTInput.this.mods(event), event.time, key, true);
                } else {
                    System.err.println("KEY? " + event.keyCode + " / " + event.character);
                }
                char keyChar = event.character;
                if (Character.isISOControl(keyChar)) {
                    SWTInput.this.emitKeyTyped(event.time, keyChar);
                }
            }
        });
        this.plat.display().addFilter(2, new Listener(){

            public void handleEvent(Event event) {
                Key key = SWTInput.this.translateKey(event.keyCode);
                if (key != null) {
                    SWTInput.this.emitKeyPress(SWTInput.this.mods(event), event.time, key, false);
                }
            }
        });
    }

    public RFuture<String> getText(Keyboard.TextType textType, String label, String initVal, String okLbl, String cancelLbl) {
        final RPromise result = RPromise.create();
        final Shell shell = new Shell(this.plat.shell(), 67680);
        GridLayout layout = new GridLayout(2, true);
        layout.marginTop = 10;
        layout.marginLeft = 10;
        layout.marginBottom = 10;
        layout.marginRight = 10;
        layout.verticalSpacing = 10;
        shell.setLayout((Layout)layout);
        shell.addListener(31, new Listener(){

            public void handleEvent(Event event) {
                if (event.detail == 2) {
                    result.succeed(null);
                }
            }
        });
        Label info = new Label((Composite)shell, 0);
        GridData idata = new GridData();
        idata.horizontalSpan = 2;
        info.setLayoutData((Object)idata);
        info.setText(label);
        final Text text = new Text((Composite)shell, 2052);
        GridData tdata = new GridData(768);
        tdata.horizontalSpan = 2;
        text.setLayoutData((Object)tdata);
        if (initVal != null) {
            text.setText(initVal);
        }
        Button ok = new Button((Composite)shell, 8);
        ok.setText(okLbl);
        ok.setLayoutData((Object)new GridData(128));
        ok.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                String r = text.getText();
                shell.dispose();
                result.succeed((Object)r);
            }
        });
        shell.setDefaultButton(ok);
        Button cancel = new Button((Composite)shell, 8);
        cancel.setText(cancelLbl);
        cancel.addListener(13, new Listener(){

            public void handleEvent(Event event) {
                shell.dispose();
                result.succeed(null);
            }
        });
        shell.pack();
        Rectangle psize = this.plat.shell().getBounds();
        Rectangle ssize = shell.getBounds();
        shell.setLocation(new Point(psize.x + (psize.width - ssize.width) / 2, psize.y + (psize.height - ssize.height) / 2));
        shell.open();
        this.emitFakeMouseUp();
        return result;
    }

    public RFuture<Boolean> sysDialog(String title, String text, String ok, String cancel) {
        int style = cancel == null ? 34 : 292;
        MessageBox box = new MessageBox(this.plat.shell(), style);
        box.setText(title);
        box.setMessage(text);
        this.emitFakeMouseUp();
        int button = box.open();
        return RFuture.success((Object)(button == 32 ? 1 : 0));
    }

    private void emitFakeMouseUp() {
        this.emitMouseButton(0, this.plat.time(), 0.0f, 0.0f, Mouse.ButtonEvent.Id.LEFT, false);
    }

    private int mods(Event event) {
        return this.modifierFlags((event.stateMask & 0x10000) == 65536, (event.stateMask & 0x40000) == 262144, (event.stateMask & 0x400000) == 0x400000, (event.stateMask & 0x20000) == 131072);
    }

    private Mouse.ButtonEvent.Id mapButton(int swtButton) {
        switch (swtButton) {
            case 1: {
                return Mouse.ButtonEvent.Id.LEFT;
            }
            case 2: {
                return Mouse.ButtonEvent.Id.MIDDLE;
            }
            case 3: {
                return Mouse.ButtonEvent.Id.RIGHT;
            }
        }
        return null;
    }

    public Key translateKey(int keyCode) {
        switch (keyCode) {
            case 65536: {
                return Key.ALT;
            }
            case 0x1000002: {
                return Key.DOWN;
            }
            case 0x1000003: {
                return Key.LEFT;
            }
            case 0x1000004: {
                return Key.RIGHT;
            }
            case 0x1000001: {
                return Key.UP;
            }
            case 16777302: {
                return Key.BREAK;
            }
            case 16777298: {
                return Key.CAPS_LOCK;
            }
            case 0x400000: {
                return Key.META;
            }
            case 262144: {
                return Key.CONTROL;
            }
            case 127: {
                return Key.DELETE;
            }
            case 0x1000008: {
                return Key.END;
            }
            case 27: {
                return Key.ESCAPE;
            }
            case 0x100000A: {
                return Key.F1;
            }
            case 0x1000013: {
                return Key.F10;
            }
            case 0x1000014: {
                return Key.F11;
            }
            case 0x1000015: {
                return Key.F12;
            }
            case 0x100000B: {
                return Key.F2;
            }
            case 0x100000C: {
                return Key.F3;
            }
            case 0x100000D: {
                return Key.F4;
            }
            case 0x100000E: {
                return Key.F5;
            }
            case 0x100000F: {
                return Key.F6;
            }
            case 0x1000010: {
                return Key.F7;
            }
            case 0x1000011: {
                return Key.F8;
            }
            case 0x1000012: {
                return Key.F9;
            }
            case 0x1000007: {
                return Key.HOME;
            }
            case 0x1000009: {
                return Key.INSERT;
            }
            case 0x1000030: {
                return Key.NP0;
            }
            case 0x1000031: {
                return Key.NP1;
            }
            case 16777266: {
                return Key.NP2;
            }
            case 0x1000033: {
                return Key.NP3;
            }
            case 16777268: {
                return Key.NP4;
            }
            case 16777269: {
                return Key.NP5;
            }
            case 16777270: {
                return Key.NP6;
            }
            case 16777271: {
                return Key.NP7;
            }
            case 16777272: {
                return Key.NP8;
            }
            case 16777273: {
                return Key.NP9;
            }
            case 0x1000050: {
                return Key.ENTER;
            }
            case 16777262: {
                return Key.NP_DECIMAL;
            }
            case 16777263: {
                return Key.NP_DIVIDE;
            }
            case 16777258: {
                return Key.NP_MULTIPLY;
            }
            case 16777261: {
                return Key.NP_SUBTRACT;
            }
            case 16777299: {
                return Key.NP_NUM_LOCK;
            }
            case 0x1000006: {
                return Key.PAGE_DOWN;
            }
            case 0x1000005: {
                return Key.PAGE_UP;
            }
            case 0x1000055: {
                return Key.PAUSE;
            }
            case 16777303: {
                return Key.PRINT_SCREEN;
            }
            case 16777300: {
                return Key.SCROLL_LOCK;
            }
            case 131072: {
                return Key.SHIFT;
            }
            case 9: {
                return Key.TAB;
            }
            case 97: {
                return Key.A;
            }
            case 98: {
                return Key.B;
            }
            case 99: {
                return Key.C;
            }
            case 100: {
                return Key.D;
            }
            case 101: {
                return Key.E;
            }
            case 102: {
                return Key.F;
            }
            case 103: {
                return Key.G;
            }
            case 104: {
                return Key.H;
            }
            case 105: {
                return Key.I;
            }
            case 106: {
                return Key.J;
            }
            case 107: {
                return Key.K;
            }
            case 108: {
                return Key.L;
            }
            case 109: {
                return Key.M;
            }
            case 110: {
                return Key.N;
            }
            case 111: {
                return Key.O;
            }
            case 112: {
                return Key.P;
            }
            case 113: {
                return Key.Q;
            }
            case 114: {
                return Key.R;
            }
            case 115: {
                return Key.S;
            }
            case 116: {
                return Key.T;
            }
            case 117: {
                return Key.U;
            }
            case 118: {
                return Key.V;
            }
            case 119: {
                return Key.W;
            }
            case 120: {
                return Key.X;
            }
            case 121: {
                return Key.Y;
            }
            case 122: {
                return Key.Z;
            }
            case 48: {
                return Key.K0;
            }
            case 49: {
                return Key.K1;
            }
            case 50: {
                return Key.K2;
            }
            case 51: {
                return Key.K3;
            }
            case 52: {
                return Key.K4;
            }
            case 53: {
                return Key.K5;
            }
            case 54: {
                return Key.K6;
            }
            case 55: {
                return Key.K7;
            }
            case 56: {
                return Key.K8;
            }
            case 57: {
                return Key.K9;
            }
            case 96: {
                return Key.BACKQUOTE;
            }
            case 45: {
                return Key.MINUS;
            }
            case 32: {
                return Key.SPACE;
            }
            case 61: {
                return Key.EQUALS;
            }
            case 91: {
                return Key.LEFT_BRACKET;
            }
            case 93: {
                return Key.RIGHT_BRACKET;
            }
            case 59: {
                return Key.SEMICOLON;
            }
            case 47: {
                return Key.SLASH;
            }
            case 44: {
                return Key.COMMA;
            }
            case 46: {
                return Key.PERIOD;
            }
            case 126: {
                return Key.TILDE;
            }
            case 8: {
                return Key.BACKSPACE;
            }
            case 39: {
                return Key.QUOTE;
            }
            case 92: {
                return Key.BACKSLASH;
            }
            case 10: {
                return Key.ENTER;
            }
            case 13: {
                return Key.ENTER;
            }
        }
        return null;
    }
}

