/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.opengl.GLCanvas;
import org.eclipse.swt.opengl.GLData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.lwjgl.opengl.GL;
import playn.core.Scale;
import playn.java.JavaPlatform;
import playn.java.LWJGLGraphics;
import playn.java.SWTMacHack;
import playn.java.SWTPlatform;
import pythagoras.f.Dimension;
import pythagoras.f.IDimension;

public class SWTGraphics
extends LWJGLGraphics {
    private final SWTPlatform plat;
    GLCanvas canvas;

    public SWTGraphics(SWTPlatform splat, final Composite comp) {
        super((JavaPlatform)splat);
        this.plat = splat;
        boolean isMac = "Mac OS X".equals(System.getProperty("os.name"));
        final Hack hack = isMac ? new SWTMacHack() : new Hack();
        this.scaleChanged(hack.hackScale());
        GLData data = new GLData();
        data.doubleBuffer = true;
        this.canvas = new GLCanvas(comp, 0x140000, data);
        hack.hackCanvas(this.canvas);
        this.canvas.setCurrent();
        GL.createCapabilities();
        comp.addListener(11, new Listener(){

            public void handleEvent(Event event) {
                Rectangle bounds = comp.getBounds();
                comp.setBounds(bounds);
                SWTGraphics.this.canvas.setBounds(bounds);
                SWTGraphics.this.canvas.setCurrent();
                hack.convertToBacking(SWTGraphics.this.canvas, bounds);
                SWTGraphics.this.viewportChanged(bounds.width, bounds.height);
            }
        });
        this.plat.log().info("Setting size " + this.plat.config.width + "x" + this.plat.config.height);
        this.setSize(this.plat.config.width, this.plat.config.height, this.plat.config.fullscreen);
    }

    public GLCanvas canvas() {
        return this.canvas;
    }

    public IDimension screenSize() {
        Rectangle db = this.plat.display().getBounds();
        return new Dimension((float)db.width, (float)db.height);
    }

    public void setSize(int width, int height, boolean fullscreen) {
        this.plat.composite().setSize(width, height);
        this.plat.shell().setFullScreen(fullscreen);
        this.plat.shell().pack();
    }

    void setTitle(String title) {
        this.plat.shell().setText(title);
    }

    void onBeforeFrame() {
        this.canvas.setCurrent();
    }

    void onAfterFrame() {
        this.canvas.swapBuffers();
    }

    public static class Hack {
        public Scale hackScale() {
            return Scale.ONE;
        }

        public void hackCanvas(GLCanvas canvas) {
        }

        public void convertToBacking(GLCanvas canvas, Rectangle bounds) {
        }
    }
}

