/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.zip.CRC32;

public class SharedLibraryExtractor {
    private final boolean isWindows = System.getProperty("os.name").contains("Windows");
    private final boolean isLinux = System.getProperty("os.name").contains("Linux");
    private final boolean isMac = System.getProperty("os.name").contains("Mac");
    private final boolean is64Bit = System.getProperty("os.arch").equals("amd64");

    public File extractLibrary(String libraryName, String dirName) throws IOException {
        File javaLibPath = new File(System.getProperty("java.library.path"));
        for (String sourcePath : this.platformNames(libraryName)) {
            InputStream cinput;
            try {
                cinput = this.readFile(sourcePath);
            }
            catch (FileNotFoundException fnfe) {
                File file = new File(javaLibPath, sourcePath);
                if (!file.exists()) continue;
                return file;
            }
            String sourceCrc = this.crc(cinput);
            if (dirName == null) {
                dirName = sourceCrc;
            }
            File extractedDir = new File(System.getProperty("java.io.tmpdir") + "/playn" + System.getProperty("user.name") + "/" + dirName);
            File extractedFile = new File(extractedDir, new File(sourcePath).getName());
            String extractedCrc = null;
            if (extractedFile.exists()) {
                try {
                    extractedCrc = this.crc(new FileInputStream(extractedFile));
                }
                catch (FileNotFoundException fileNotFoundException) {
                    // empty catch block
                }
            }
            if (extractedCrc == null || !extractedCrc.equals(sourceCrc)) {
                extractedDir.mkdirs();
                this.copyTo(sourcePath, extractedFile);
                if (sourcePath.endsWith(".jnilib")) {
                    String hackPath = sourcePath.replaceAll(".jnilib", ".dylib");
                    this.copyTo(sourcePath, new File(extractedDir, new File(hackPath).getName()));
                }
            }
            return extractedFile;
        }
        throw new FileNotFoundException("Unable to find shared lib for '" + libraryName + "'");
    }

    private String[] platformNames(String libraryName) {
        if (this.isWindows) {
            return new String[]{libraryName + (this.is64Bit ? "64.dll" : ".dll")};
        }
        if (this.isLinux) {
            return new String[]{"lib" + libraryName + (this.is64Bit ? "64.so" : ".so")};
        }
        if (this.isMac) {
            return new String[]{"lib" + libraryName + ".jnilib", "lib" + libraryName + ".dylib"};
        }
        return new String[]{libraryName};
    }

    private String crc(InputStream input) {
        if (input == null) {
            throw new IllegalArgumentException("input cannot be null.");
        }
        CRC32 crc = new CRC32();
        byte[] buffer = new byte[4096];
        try {
            int length;
            while ((length = input.read(buffer)) != -1) {
                crc.update(buffer, 0, length);
            }
        }
        catch (Exception ex) {
            try {
                input.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return Long.toString(crc.getValue());
    }

    private InputStream readFile(String path) throws IOException {
        InputStream input = this.getClass().getResourceAsStream("/" + path);
        if (input == null) {
            throw new FileNotFoundException("Unable to read file for extraction: " + path);
        }
        return input;
    }

    private void copyTo(String sourcePath, File target) {
        try {
            int length;
            InputStream input = this.readFile(sourcePath);
            FileOutputStream output = new FileOutputStream(target);
            byte[] buffer = new byte[4096];
            while ((length = input.read(buffer)) != -1) {
                output.write(buffer, 0, length);
            }
            input.close();
            output.close();
        }
        catch (IOException ex) {
            throw new RuntimeException("Error extracting file: " + sourcePath, ex);
        }
    }
}

