/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWErrorCallback;
import org.lwjgl.glfw.GLFWErrorCallbackI;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.opengl.GL;
import playn.core.Platform;
import playn.java.GLFWGraphics;
import playn.java.GLFWInput;
import playn.java.JavaGraphics;
import playn.java.JavaInput;
import playn.java.JavaPlatform;

public class LWJGLPlatform
extends JavaPlatform {
    private final GLFWErrorCallback errorCallback;
    private final GLFWGraphics graphics;
    private final GLFWInput input;
    private final long window;

    public LWJGLPlatform(JavaPlatform.Config config) {
        super(config);
        if (this.needsHeadless()) {
            System.setProperty("java.awt.headless", "true");
        }
        this.errorCallback = new GLFWErrorCallback(){

            public void invoke(int error, long description) {
                LWJGLPlatform.this.log().error("GL Error (" + error + "):" + 1.getDescription((long)description));
            }
        };
        GLFW.glfwSetErrorCallback((GLFWErrorCallbackI)this.errorCallback);
        if (!GLFW.glfwInit()) {
            throw new RuntimeException("Failed to init GLFW.");
        }
        long monitor = GLFW.glfwGetPrimaryMonitor();
        GLFWVidMode vidMode = GLFW.glfwGetVideoMode((long)monitor);
        int width = config.width;
        int height = config.height;
        if (config.fullscreen) {
            width = vidMode.width();
            height = vidMode.height();
        } else {
            monitor = 0L;
        }
        GLFW.glfwDefaultWindowHints();
        GLFW.glfwWindowHint((int)131076, (int)0);
        GLFW.glfwWindowHint((int)131075, (int)0);
        this.window = GLFW.glfwCreateWindow((int)width, (int)height, (CharSequence)config.appName, (long)monitor, (long)0L);
        if (this.window == 0L) {
            throw new RuntimeException("Failed to create window; see error log.");
        }
        this.graphics = new GLFWGraphics(this, this.window);
        this.input = new GLFWInput(this, this.window);
        GLFW.glfwSetWindowPos((long)this.window, (int)((vidMode.width() - width) / 2), (int)((vidMode.height() - height) / 2));
        GLFW.glfwMakeContextCurrent((long)this.window);
        GLFW.glfwSwapInterval((int)1);
        this.graphics.setSize(config.width, config.height, config.fullscreen);
        GLFW.glfwShowWindow((long)this.window);
        GL.createCapabilities();
    }

    boolean needsHeadless() {
        return System.getProperty("os.name").equals("Mac OS X");
    }

    public JavaGraphics graphics() {
        return this.graphics;
    }

    public JavaInput input() {
        return this.input;
    }

    protected void loop() {
        boolean wasActive;
        boolean bl = wasActive = GLFW.glfwGetWindowAttrib((long)this.window, (int)131076) > 0;
        while (!GLFW.glfwWindowShouldClose((long)this.window)) {
            boolean newActive;
            boolean bl2 = newActive = GLFW.glfwGetWindowAttrib((long)this.window, (int)131076) > 0;
            if (wasActive != newActive) {
                this.dispatchEvent(this.lifecycle, wasActive ? Platform.Lifecycle.PAUSE : Platform.Lifecycle.RESUME);
                wasActive = newActive;
            }
            if (newActive || !this.config.truePause) {
                this.processFrame();
            }
            GLFW.glfwSwapBuffers((long)this.window);
        }
        this.input.shutdown();
        this.graphics.shutdown();
        this.errorCallback.close();
        GLFW.glfwDestroyWindow((long)this.window);
        GLFW.glfwTerminate();
    }
}

