/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.image.BufferedImage;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.nio.ByteBuffer;
import org.lwjgl.opengl.GL11;
import playn.core.GL20;
import playn.core.Platform;
import playn.core.Scale;
import playn.core.Texture;
import playn.java.JavaGraphics;
import playn.java.JavaPlatform;
import playn.java.LWJGLGL20;

public abstract class LWJGLGraphics
extends JavaGraphics {
    protected LWJGLGraphics(JavaPlatform jplat) {
        super((Platform)jplat, (GL20)new LWJGLGL20(), Scale.ONE);
    }

    void upload(BufferedImage img, Texture tex) {
        int type;
        int format;
        ByteBuffer bbuf;
        BufferedImage bitmap = LWJGLGraphics.convertImage((BufferedImage)img);
        DataBuffer dbuf = bitmap.getRaster().getDataBuffer();
        if (bitmap.getType() == 3) {
            DataBufferInt ibuf = (DataBufferInt)dbuf;
            int iSize = ibuf.getSize() * 4;
            bbuf = this.checkGetImageBuffer(iSize);
            bbuf.asIntBuffer().put(ibuf.getData());
            bbuf.position(bbuf.position() + iSize);
            bbuf.flip();
            format = 32993;
            type = 33639;
        } else if (bitmap.getType() == 6) {
            DataBufferByte dbbuf = (DataBufferByte)dbuf;
            bbuf = this.checkGetImageBuffer(dbbuf.getSize());
            bbuf.put(dbbuf.getData());
            bbuf.flip();
            format = 6408;
            type = 32821;
        } else {
            throw new RuntimeException("Image type wasn't converted to usable: " + bitmap.getType());
        }
        this.gl.glBindTexture(3553, tex.id);
        GL11.glTexImage2D((int)3553, (int)0, (int)6408, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (int)0, (int)format, (int)type, (ByteBuffer)bbuf);
        this.gl.checkError("updateTexture");
    }
}

