/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.io.UnsupportedEncodingException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.DoubleBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.EXTFramebufferObject;
import org.lwjgl.opengl.GL11;
import org.lwjgl.opengl.GL12;
import org.lwjgl.opengl.GL13;
import org.lwjgl.opengl.GL14;
import org.lwjgl.opengl.GL15;
import org.lwjgl.opengl.GL20;
import org.lwjgl.opengl.GL41;
import org.lwjgl.system.MemoryUtil;
import playn.core.GL20;

final class LWJGLGL20
extends playn.core.GL20 {
    public LWJGLGL20() {
        super(new GL20.Buffers(){

            public ByteBuffer createByteBuffer(int size) {
                return BufferUtils.createByteBuffer((int)size);
            }
        }, Boolean.getBoolean("playn.glerrors"));
    }

    public void glActiveTexture(int texture) {
        GL13.glActiveTexture((int)texture);
    }

    public void glAttachShader(int program, int shader) {
        GL20.glAttachShader((int)program, (int)shader);
    }

    public void glBindAttribLocation(int program, int index, String name) {
        GL20.glBindAttribLocation((int)program, (int)index, (CharSequence)name);
    }

    public void glBindBuffer(int target, int buffer) {
        GL15.glBindBuffer((int)target, (int)buffer);
    }

    public void glBindFramebuffer(int target, int framebuffer) {
        EXTFramebufferObject.glBindFramebufferEXT((int)target, (int)framebuffer);
    }

    public void glBindRenderbuffer(int target, int renderbuffer) {
        EXTFramebufferObject.glBindRenderbufferEXT((int)target, (int)renderbuffer);
    }

    public void glBindTexture(int target, int texture) {
        GL11.glBindTexture((int)target, (int)texture);
    }

    public void glBlendColor(float red, float green, float blue, float alpha) {
        GL14.glBlendColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public void glBlendEquation(int mode) {
        GL14.glBlendEquation((int)mode);
    }

    public void glBlendEquationSeparate(int modeRGB, int modeAlpha) {
        GL20.glBlendEquationSeparate((int)modeRGB, (int)modeAlpha);
    }

    public void glBlendFunc(int sfactor, int dfactor) {
        GL11.glBlendFunc((int)sfactor, (int)dfactor);
    }

    public void glBlendFuncSeparate(int srcRGB, int dstRGB, int srcAlpha, int dstAlpha) {
        GL14.glBlendFuncSeparate((int)srcRGB, (int)dstRGB, (int)srcAlpha, (int)dstAlpha);
    }

    public void glBufferData(int target, int size, Buffer data, int usage) {
        if (data == null) {
            GL15.glBufferData((int)target, (long)size, (int)usage);
            return;
        }
        int oldLimit = data.limit();
        if (data instanceof ByteBuffer) {
            ByteBuffer subData = (ByteBuffer)data;
            subData.limit(subData.position() + size);
            GL15.glBufferData((int)target, (ByteBuffer)subData, (int)usage);
        } else if (data instanceof IntBuffer) {
            IntBuffer subData = (IntBuffer)data;
            subData.limit(subData.position() + size / 4);
            GL15.glBufferData((int)target, (IntBuffer)subData, (int)usage);
        } else if (data instanceof FloatBuffer) {
            FloatBuffer subData = (FloatBuffer)data;
            subData.limit(subData.position() + size / 4);
            GL15.glBufferData((int)target, (FloatBuffer)subData, (int)usage);
        } else if (data instanceof DoubleBuffer) {
            DoubleBuffer subData = (DoubleBuffer)data;
            subData.limit(subData.position() + size / 8);
            GL15.glBufferData((int)target, (DoubleBuffer)subData, (int)usage);
        } else if (data instanceof ShortBuffer) {
            ShortBuffer subData = (ShortBuffer)data;
            subData.limit(subData.position() + size / 2);
            GL15.glBufferData((int)target, (ShortBuffer)subData, (int)usage);
        }
        data.limit(oldLimit);
    }

    public void glBufferSubData(int target, int offset, int size, Buffer data) {
        int oldLimit = data.limit();
        if (data instanceof ByteBuffer) {
            ByteBuffer subData = (ByteBuffer)data;
            subData.limit(subData.position() + size);
            GL15.glBufferSubData((int)target, (long)offset, (ByteBuffer)subData);
        } else if (data instanceof IntBuffer) {
            IntBuffer subData = (IntBuffer)data;
            subData.limit(subData.position() + size / 4);
            GL15.glBufferSubData((int)target, (long)offset, (IntBuffer)subData);
        } else if (data instanceof FloatBuffer) {
            FloatBuffer subData = (FloatBuffer)data;
            subData.limit(subData.position() + size / 4);
            GL15.glBufferSubData((int)target, (long)offset, (FloatBuffer)subData);
        } else if (data instanceof DoubleBuffer) {
            DoubleBuffer subData = (DoubleBuffer)data;
            subData.limit(subData.position() + size / 8);
            GL15.glBufferSubData((int)target, (long)offset, (DoubleBuffer)subData);
        } else if (data instanceof ShortBuffer) {
            ShortBuffer subData = (ShortBuffer)data;
            subData.limit(subData.position() + size / 2);
            GL15.glBufferSubData((int)target, (long)offset, (ShortBuffer)subData);
        }
        data.limit(oldLimit);
    }

    public int glCheckFramebufferStatus(int target) {
        return EXTFramebufferObject.glCheckFramebufferStatusEXT((int)target);
    }

    public void glClear(int mask) {
        GL11.glClear((int)mask);
    }

    public void glClearColor(float red, float green, float blue, float alpha) {
        GL11.glClearColor((float)red, (float)green, (float)blue, (float)alpha);
    }

    public void glClearDepthf(float depth) {
        GL11.glClearDepth((double)depth);
    }

    public void glClearStencil(int s) {
        GL11.glClearStencil((int)s);
    }

    public void glColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        GL11.glColorMask((boolean)red, (boolean)green, (boolean)blue, (boolean)alpha);
    }

    public void glCompileShader(int shader) {
        GL20.glCompileShader((int)shader);
    }

    public void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, Buffer data) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, Buffer data) {
        throw new UnsupportedOperationException("not implemented");
    }

    public void glCopyTexImage2D(int target, int level, int internalformat, int x, int y, int width, int height, int border) {
        GL11.glCopyTexImage2D((int)target, (int)level, (int)internalformat, (int)x, (int)y, (int)width, (int)height, (int)border);
    }

    public void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        GL11.glCopyTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)x, (int)y, (int)width, (int)height);
    }

    public int glCreateProgram() {
        return GL20.glCreateProgram();
    }

    public int glCreateShader(int type) {
        return GL20.glCreateShader((int)type);
    }

    public void glCullFace(int mode) {
        GL11.glCullFace((int)mode);
    }

    public void glDeleteBuffers(int n, IntBuffer buffers) {
        GL15.glDeleteBuffers((IntBuffer)buffers);
    }

    public void glDeleteFramebuffers(int n, IntBuffer framebuffers) {
        EXTFramebufferObject.glDeleteFramebuffersEXT((IntBuffer)framebuffers);
    }

    public void glDeleteProgram(int program) {
        GL20.glDeleteProgram((int)program);
    }

    public void glDeleteRenderbuffers(int n, IntBuffer renderbuffers) {
        EXTFramebufferObject.glDeleteRenderbuffersEXT((IntBuffer)renderbuffers);
    }

    public void glDeleteShader(int shader) {
        GL20.glDeleteShader((int)shader);
    }

    public void glDeleteTextures(int n, IntBuffer textures) {
        GL11.glDeleteTextures((IntBuffer)textures);
    }

    public void glDepthFunc(int func) {
        GL11.glDepthFunc((int)func);
    }

    public void glDepthMask(boolean flag) {
        GL11.glDepthMask((boolean)flag);
    }

    public void glDepthRangef(float zNear, float zFar) {
        GL11.glDepthRange((double)zNear, (double)zFar);
    }

    public void glDetachShader(int program, int shader) {
        GL20.glDetachShader((int)program, (int)shader);
    }

    public void glDisable(int cap) {
        GL11.glDisable((int)cap);
    }

    public void glDisableVertexAttribArray(int index) {
        GL20.glDisableVertexAttribArray((int)index);
    }

    public void glDrawArrays(int mode, int first, int count) {
        GL11.glDrawArrays((int)mode, (int)first, (int)count);
    }

    public void glDrawElements(int mode, int count, int type, Buffer indices) {
        if (indices instanceof ShortBuffer && type == 5123) {
            GL11.glDrawElements((int)mode, (ShortBuffer)((ShortBuffer)indices));
        } else if (indices instanceof ByteBuffer && type == 5123) {
            GL11.glDrawElements((int)mode, (ShortBuffer)((ByteBuffer)indices).asShortBuffer());
        } else if (indices instanceof ByteBuffer && type == 5121) {
            GL11.glDrawElements((int)mode, (ByteBuffer)((ByteBuffer)indices));
        } else {
            throw new RuntimeException("Can't use " + indices.getClass().getName() + " with this method. Use ShortBuffer or ByteBuffer instead. Blame LWJGL");
        }
    }

    public void glEnable(int cap) {
        GL11.glEnable((int)cap);
    }

    public void glEnableVertexAttribArray(int index) {
        GL20.glEnableVertexAttribArray((int)index);
    }

    public void glFinish() {
        GL11.glFinish();
    }

    public void glFlush() {
        GL11.glFlush();
    }

    public void glFramebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer) {
        EXTFramebufferObject.glFramebufferRenderbufferEXT((int)target, (int)attachment, (int)renderbuffertarget, (int)renderbuffer);
    }

    public void glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level) {
        EXTFramebufferObject.glFramebufferTexture2DEXT((int)target, (int)attachment, (int)textarget, (int)texture, (int)level);
    }

    public void glFrontFace(int mode) {
        GL11.glFrontFace((int)mode);
    }

    public void glGenBuffers(int n, IntBuffer buffers) {
        GL15.glGenBuffers((IntBuffer)buffers);
    }

    public void glGenFramebuffers(int n, IntBuffer framebuffers) {
        EXTFramebufferObject.glGenFramebuffersEXT((IntBuffer)framebuffers);
    }

    public void glGenRenderbuffers(int n, IntBuffer renderbuffers) {
        EXTFramebufferObject.glGenRenderbuffersEXT((IntBuffer)renderbuffers);
    }

    public void glGenTextures(int n, IntBuffer textures) {
        GL11.glGenTextures((IntBuffer)textures);
    }

    public void glGenerateMipmap(int target) {
        EXTFramebufferObject.glGenerateMipmapEXT((int)target);
    }

    public int glGetAttribLocation(int program, String name) {
        return GL20.glGetAttribLocation((int)program, (CharSequence)name);
    }

    public void glGetBufferParameteriv(int target, int pname, IntBuffer params) {
        GL15.glGetBufferParameteriv((int)target, (int)pname, (IntBuffer)params);
    }

    public int glGetError() {
        return GL11.glGetError();
    }

    public void glGetFloatv(int pname, FloatBuffer params) {
        GL11.glGetFloatv((int)pname, (FloatBuffer)params);
    }

    public void glGetFramebufferAttachmentParameteriv(int target, int attachment, int pname, IntBuffer params) {
        EXTFramebufferObject.glGetFramebufferAttachmentParameterivEXT((int)target, (int)attachment, (int)pname, (IntBuffer)params);
    }

    public void glGetIntegerv(int pname, IntBuffer params) {
        GL11.glGetIntegerv((int)pname, (IntBuffer)params);
    }

    public String glGetProgramInfoLog(int program) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(10240);
        buffer.order(ByteOrder.nativeOrder());
        ByteBuffer tmp = ByteBuffer.allocateDirect(4);
        tmp.order(ByteOrder.nativeOrder());
        IntBuffer intBuffer = tmp.asIntBuffer();
        GL20.glGetProgramInfoLog((int)program, (IntBuffer)intBuffer, (ByteBuffer)buffer);
        int numBytes = intBuffer.get(0);
        byte[] bytes = new byte[numBytes];
        buffer.get(bytes);
        return new String(bytes);
    }

    public void glGetProgramiv(int program, int pname, IntBuffer params) {
        GL20.glGetProgramiv((int)program, (int)pname, (IntBuffer)params);
    }

    public void glGetRenderbufferParameteriv(int target, int pname, IntBuffer params) {
        EXTFramebufferObject.glGetRenderbufferParameterivEXT((int)target, (int)pname, (IntBuffer)params);
    }

    public String glGetShaderInfoLog(int shader) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(10240);
        buffer.order(ByteOrder.nativeOrder());
        ByteBuffer tmp = ByteBuffer.allocateDirect(4);
        tmp.order(ByteOrder.nativeOrder());
        IntBuffer intBuffer = tmp.asIntBuffer();
        GL20.glGetShaderInfoLog((int)shader, (IntBuffer)intBuffer, (ByteBuffer)buffer);
        int numBytes = intBuffer.get(0);
        byte[] bytes = new byte[numBytes];
        buffer.get(bytes);
        return new String(bytes);
    }

    public void glGetShaderPrecisionFormat(int shadertype, int precisiontype, IntBuffer range, IntBuffer precision) {
        this.glGetShaderPrecisionFormat(shadertype, precisiontype, range, precision);
    }

    public void glGetShaderiv(int shader, int pname, IntBuffer params) {
        GL20.glGetShaderiv((int)shader, (int)pname, (IntBuffer)params);
    }

    public String glGetString(int name) {
        return GL11.glGetString((int)name);
    }

    public void glGetTexParameterfv(int target, int pname, FloatBuffer params) {
        GL11.glGetTexParameterfv((int)target, (int)pname, (FloatBuffer)params);
    }

    public void glGetTexParameteriv(int target, int pname, IntBuffer params) {
        GL11.glGetTexParameteriv((int)target, (int)pname, (IntBuffer)params);
    }

    public int glGetUniformLocation(int program, String name) {
        return GL20.glGetUniformLocation((int)program, (CharSequence)name);
    }

    public void glGetUniformfv(int program, int location, FloatBuffer params) {
        GL20.glGetUniformfv((int)program, (int)location, (FloatBuffer)params);
    }

    public void glGetUniformiv(int program, int location, IntBuffer params) {
        GL20.glGetUniformiv((int)program, (int)location, (IntBuffer)params);
    }

    public void glGetVertexAttribfv(int index, int pname, FloatBuffer params) {
        GL20.glGetVertexAttribfv((int)index, (int)pname, (FloatBuffer)params);
    }

    public void glGetVertexAttribiv(int index, int pname, IntBuffer params) {
        GL20.glGetVertexAttribiv((int)index, (int)pname, (IntBuffer)params);
    }

    public void glHint(int target, int mode) {
        GL11.glHint((int)target, (int)mode);
    }

    public boolean glIsBuffer(int buffer) {
        return GL15.glIsBuffer((int)buffer);
    }

    public boolean glIsEnabled(int cap) {
        return GL11.glIsEnabled((int)cap);
    }

    public boolean glIsFramebuffer(int framebuffer) {
        return EXTFramebufferObject.glIsFramebufferEXT((int)framebuffer);
    }

    public boolean glIsProgram(int program) {
        return GL20.glIsProgram((int)program);
    }

    public boolean glIsRenderbuffer(int renderbuffer) {
        return EXTFramebufferObject.glIsRenderbufferEXT((int)renderbuffer);
    }

    public boolean glIsShader(int shader) {
        return GL20.glIsShader((int)shader);
    }

    public boolean glIsTexture(int texture) {
        return GL11.glIsTexture((int)texture);
    }

    public void glLineWidth(float width) {
        GL11.glLineWidth((float)width);
    }

    public void glLinkProgram(int program) {
        GL20.glLinkProgram((int)program);
    }

    public void glPixelStorei(int pname, int param) {
        GL11.glPixelStorei((int)pname, (int)param);
    }

    public void glPolygonOffset(float factor, float units) {
        GL11.glPolygonOffset((float)factor, (float)units);
    }

    public void glReadPixels(int x, int y, int width, int height, int format, int type, Buffer pixels) {
        if (pixels instanceof ByteBuffer) {
            GL11.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (ByteBuffer)((ByteBuffer)pixels));
        } else if (pixels instanceof ShortBuffer) {
            GL11.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (ShortBuffer)((ShortBuffer)pixels));
        } else if (pixels instanceof IntBuffer) {
            GL11.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (IntBuffer)((IntBuffer)pixels));
        } else if (pixels instanceof FloatBuffer) {
            GL11.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (FloatBuffer)((FloatBuffer)pixels));
        } else {
            throw new RuntimeException("Can't use " + pixels.getClass().getName() + " with this method. Use ByteBuffer, " + "ShortBuffer, IntBuffer or FloatBuffer instead. Blame LWJGL");
        }
    }

    public void glReleaseShaderCompiler() {
    }

    public void glRenderbufferStorage(int target, int internalformat, int width, int height) {
        EXTFramebufferObject.glRenderbufferStorageEXT((int)target, (int)internalformat, (int)width, (int)height);
    }

    public void glSampleCoverage(float value, boolean invert) {
        GL13.glSampleCoverage((float)value, (boolean)invert);
    }

    public void glScissor(int x, int y, int width, int height) {
        GL11.glScissor((int)x, (int)y, (int)width, (int)height);
    }

    public void glShaderBinary(int n, IntBuffer shaders, int binaryformat, Buffer binary, int length) {
        throw new UnsupportedOperationException("unsupported, won't implement");
    }

    public void glShaderSource(int shader, String string) {
        GL20.glShaderSource((int)shader, (CharSequence)string);
    }

    public void glStencilFunc(int func, int ref, int mask) {
        GL11.glStencilFunc((int)func, (int)ref, (int)mask);
    }

    public void glStencilFuncSeparate(int face, int func, int ref, int mask) {
        GL20.glStencilFuncSeparate((int)face, (int)func, (int)ref, (int)mask);
    }

    public void glStencilMask(int mask) {
        GL11.glStencilMask((int)mask);
    }

    public void glStencilMaskSeparate(int face, int mask) {
        GL20.glStencilMaskSeparate((int)face, (int)mask);
    }

    public void glStencilOp(int fail, int zfail, int zpass) {
        GL11.glStencilOp((int)fail, (int)zfail, (int)zpass);
    }

    public void glStencilOpSeparate(int face, int fail, int zfail, int zpass) {
        GL20.glStencilOpSeparate((int)face, (int)fail, (int)zfail, (int)zpass);
    }

    public void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, Buffer pixels) {
        if (pixels instanceof ByteBuffer || pixels == null) {
            GL11.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (ByteBuffer)((ByteBuffer)pixels));
        } else if (pixels instanceof ShortBuffer) {
            GL11.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (ShortBuffer)((ShortBuffer)pixels));
        } else if (pixels instanceof IntBuffer) {
            GL11.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (IntBuffer)((IntBuffer)pixels));
        } else if (pixels instanceof FloatBuffer) {
            GL11.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (FloatBuffer)((FloatBuffer)pixels));
        } else if (pixels instanceof DoubleBuffer) {
            GL11.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (DoubleBuffer)((DoubleBuffer)pixels));
        } else {
            throw new RuntimeException("Can't use " + pixels.getClass().getName() + " with this method. Use ByteBuffer, " + "ShortBuffer, IntBuffer, FloatBuffer or DoubleBuffer instead. Blame LWJGL");
        }
    }

    public void glTexParameterf(int target, int pname, float param) {
        GL11.glTexParameterf((int)target, (int)pname, (float)param);
    }

    public void glTexParameterfv(int target, int pname, FloatBuffer params) {
        GL11.glTexParameterfv((int)target, (int)pname, (FloatBuffer)params);
    }

    public void glTexParameteri(int target, int pname, int param) {
        GL11.glTexParameteri((int)target, (int)pname, (int)param);
    }

    public void glTexParameteriv(int target, int pname, IntBuffer params) {
        GL11.glTexParameteriv((int)target, (int)pname, (IntBuffer)params);
    }

    public void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, Buffer pixels) {
        if (pixels instanceof ByteBuffer) {
            GL11.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (ByteBuffer)((ByteBuffer)pixels));
        } else if (pixels instanceof ShortBuffer) {
            GL11.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (ShortBuffer)((ShortBuffer)pixels));
        } else if (pixels instanceof IntBuffer) {
            GL11.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (IntBuffer)((IntBuffer)pixels));
        } else if (pixels instanceof FloatBuffer) {
            GL11.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (FloatBuffer)((FloatBuffer)pixels));
        } else if (pixels instanceof DoubleBuffer) {
            GL11.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (DoubleBuffer)((DoubleBuffer)pixels));
        } else {
            throw new RuntimeException("Can't use " + pixels.getClass().getName() + " with this method. Use ByteBuffer, " + "ShortBuffer, IntBuffer, FloatBuffer or DoubleBuffer instead. Blame LWJGL");
        }
    }

    public void glUniform1f(int location, float x) {
        GL20.glUniform1f((int)location, (float)x);
    }

    public void glUniform1fv(int location, int count, FloatBuffer buffer) {
        int oldLimit = buffer.limit();
        buffer.limit(buffer.position() + count);
        GL20.glUniform1fv((int)location, (FloatBuffer)buffer);
        buffer.limit(oldLimit);
    }

    public void glUniform1i(int location, int x) {
        GL20.glUniform1i((int)location, (int)x);
    }

    public void glUniform1iv(int location, int count, IntBuffer buffer) {
        int oldLimit = buffer.limit();
        buffer.limit(buffer.position() + count);
        GL20.glUniform1iv((int)location, (IntBuffer)buffer);
        buffer.limit(oldLimit);
    }

    public void glUniform2f(int location, float x, float y) {
        GL20.glUniform2f((int)location, (float)x, (float)y);
    }

    public void glUniform2fv(int location, int count, FloatBuffer buffer) {
        int oldLimit = buffer.limit();
        buffer.limit(buffer.position() + 2 * count);
        GL20.glUniform2fv((int)location, (FloatBuffer)buffer);
        buffer.limit(oldLimit);
    }

    public void glUniform2i(int location, int x, int y) {
        GL20.glUniform2i((int)location, (int)x, (int)y);
    }

    public void glUniform2iv(int location, int count, IntBuffer buffer) {
        int oldLimit = buffer.limit();
        buffer.limit(buffer.position() + 2 * count);
        GL20.glUniform2iv((int)location, (IntBuffer)buffer);
        buffer.limit(oldLimit);
    }

    public void glUniform3f(int location, float x, float y, float z) {
        GL20.glUniform3f((int)location, (float)x, (float)y, (float)z);
    }

    public void glUniform3fv(int location, int count, FloatBuffer buffer) {
        int oldLimit = buffer.limit();
        buffer.limit(buffer.position() + 3 * count);
        GL20.glUniform3fv((int)location, (FloatBuffer)buffer);
        buffer.limit(oldLimit);
    }

    public void glUniform3i(int location, int x, int y, int z) {
        GL20.glUniform3i((int)location, (int)x, (int)y, (int)z);
    }

    public void glUniform3iv(int location, int count, IntBuffer buffer) {
        int oldLimit = buffer.limit();
        buffer.limit(buffer.position() + 3 * count);
        GL20.glUniform3iv((int)location, (IntBuffer)buffer);
        buffer.limit(oldLimit);
    }

    public void glUniform4f(int location, float x, float y, float z, float w) {
        GL20.glUniform4f((int)location, (float)x, (float)y, (float)z, (float)w);
    }

    public void glUniform4fv(int location, int count, FloatBuffer buffer) {
        int oldLimit = buffer.limit();
        buffer.limit(buffer.position() + 4 * count);
        GL20.glUniform4fv((int)location, (FloatBuffer)buffer);
        buffer.limit(oldLimit);
    }

    public void glUniform4i(int location, int x, int y, int z, int w) {
        GL20.glUniform4i((int)location, (int)x, (int)y, (int)z, (int)w);
    }

    public void glUniform4iv(int location, int count, IntBuffer buffer) {
        int oldLimit = buffer.limit();
        buffer.limit(buffer.position() + 4 * count);
        GL20.glUniform4iv((int)location, (IntBuffer)buffer);
        buffer.limit(oldLimit);
    }

    public void glUniformMatrix2fv(int location, int count, boolean transpose, FloatBuffer buffer) {
        int oldLimit = buffer.limit();
        buffer.limit(buffer.position() + 4 * count);
        GL20.glUniformMatrix2fv((int)location, (boolean)transpose, (FloatBuffer)buffer);
        buffer.limit(oldLimit);
    }

    public void glUniformMatrix3fv(int location, int count, boolean transpose, FloatBuffer buffer) {
        int oldLimit = buffer.limit();
        buffer.limit(buffer.position() + 9 * count);
        GL20.glUniformMatrix3fv((int)location, (boolean)transpose, (FloatBuffer)buffer);
        buffer.limit(oldLimit);
    }

    public void glUniformMatrix4fv(int location, int count, boolean transpose, FloatBuffer buffer) {
        int oldLimit = buffer.limit();
        buffer.limit(buffer.position() + 16 * count);
        GL20.glUniformMatrix4fv((int)location, (boolean)transpose, (FloatBuffer)buffer);
        buffer.limit(oldLimit);
    }

    public void glUseProgram(int program) {
        GL20.glUseProgram((int)program);
    }

    public void glValidateProgram(int program) {
        GL20.glValidateProgram((int)program);
    }

    public void glVertexAttrib1f(int indx, float x) {
        GL20.glVertexAttrib1f((int)indx, (float)x);
    }

    public void glVertexAttrib1fv(int indx, FloatBuffer values) {
        GL20.glVertexAttrib1f((int)indx, (float)values.get());
    }

    public void glVertexAttrib2f(int indx, float x, float y) {
        GL20.glVertexAttrib2f((int)indx, (float)x, (float)y);
    }

    public void glVertexAttrib2fv(int indx, FloatBuffer values) {
        GL20.glVertexAttrib2f((int)indx, (float)values.get(), (float)values.get());
    }

    public void glVertexAttrib3f(int indx, float x, float y, float z) {
        GL20.glVertexAttrib3f((int)indx, (float)x, (float)y, (float)z);
    }

    public void glVertexAttrib3fv(int indx, FloatBuffer values) {
        GL20.glVertexAttrib3f((int)indx, (float)values.get(), (float)values.get(), (float)values.get());
    }

    public void glVertexAttrib4f(int indx, float x, float y, float z, float w) {
        GL20.glVertexAttrib4f((int)indx, (float)x, (float)y, (float)z, (float)w);
    }

    public void glVertexAttrib4fv(int indx, FloatBuffer values) {
        GL20.glVertexAttrib4f((int)indx, (float)values.get(), (float)values.get(), (float)values.get(), (float)values.get());
    }

    public void glVertexAttribPointer(int indx, int size, int type, boolean normalized, int stride, Buffer ptr) {
        if (ptr instanceof FloatBuffer) {
            GL20.glVertexAttribPointer((int)indx, (int)size, (int)type, (boolean)normalized, (int)stride, (FloatBuffer)((FloatBuffer)ptr));
        } else if (ptr instanceof ByteBuffer) {
            GL20.glVertexAttribPointer((int)indx, (int)size, (int)type, (boolean)normalized, (int)stride, (ByteBuffer)((ByteBuffer)ptr));
        } else if (ptr instanceof ShortBuffer) {
            GL20.glVertexAttribPointer((int)indx, (int)size, (int)type, (boolean)normalized, (int)stride, (ShortBuffer)((ShortBuffer)ptr));
        } else if (ptr instanceof IntBuffer) {
            GL20.glVertexAttribPointer((int)indx, (int)size, (int)type, (boolean)normalized, (int)stride, (IntBuffer)((IntBuffer)ptr));
        } else {
            throw new RuntimeException("NYI for " + ptr.getClass());
        }
    }

    public void glViewport(int x, int y, int width, int height) {
        GL11.glViewport((int)x, (int)y, (int)width, (int)height);
    }

    public void glDrawElements(int mode, int count, int type, int indices) {
        GL11.glDrawElements((int)mode, (int)count, (int)type, (long)indices);
    }

    public void glVertexAttribPointer(int indx, int size, int type, boolean normalized, int stride, int ptr) {
        GL20.glVertexAttribPointer((int)indx, (int)size, (int)type, (boolean)normalized, (int)stride, (long)ptr);
    }

    public String getPlatformGLExtensions() {
        throw new UnsupportedOperationException("NYI - not in LWJGL.");
    }

    public int getSwapInterval() {
        throw new UnsupportedOperationException("NYI - not in LWJGL.");
    }

    public void glClearDepth(double depth) {
        GL11.glClearDepth((double)depth);
    }

    public void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int data_imageSize, int data) {
        GL13.glCompressedTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)data_imageSize, (long)data);
    }

    public void glCompressedTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, Buffer data) {
        GL13.glCompressedTexImage3D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)depth, (int)border, (int)imageSize, (long)MemoryUtil.memAddress((ByteBuffer)((ByteBuffer)data)));
    }

    public void glCompressedTexImage3D(int target, int level, int internalformat, int width, int height, int depth, int border, int imageSize, int data) {
        GL13.glCompressedTexImage3D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)depth, (int)border, (int)imageSize, (long)data);
    }

    public void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int data_imageSize, int data) {
        GL13.glCompressedTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)data_imageSize, (long)data);
    }

    public void glCompressedTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, Buffer data) {
        GL13.glCompressedTexSubImage3D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (int)format, (ByteBuffer)((ByteBuffer)data));
    }

    public void glCompressedTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int imageSize, int data) {
        ByteBuffer dataBuffer = BufferUtils.createByteBuffer((int)4);
        dataBuffer.putInt(data);
        dataBuffer.rewind();
        GL13.glCompressedTexSubImage3D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (int)format, (ByteBuffer)dataBuffer);
    }

    public void glCopyTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int x, int y, int width, int height) {
        GL12.glCopyTexSubImage3D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)x, (int)y, (int)width, (int)height);
    }

    public void glDepthRange(double zNear, double zFar) {
        GL11.glDepthRange((double)zNear, (double)zFar);
    }

    public void glFramebufferTexture3D(int target, int attachment, int textarget, int texture, int level, int zoffset) {
        EXTFramebufferObject.glFramebufferTexture3DEXT((int)target, (int)attachment, (int)textarget, (int)texture, (int)level, (int)zoffset);
    }

    public void glGetActiveAttrib(int program, int index, int bufsize, int[] length, int lengthOffset, int[] size, int sizeOffset, int[] type, int typeOffset, byte[] name, int nameOffset) {
        this.bufs.resizeIntBuffer(2);
        String nameString = GL20.glGetActiveAttrib((int)program, (int)index, (IntBuffer)BufferUtils.createIntBuffer((int)bufsize), (IntBuffer)this.bufs.intBuffer);
        try {
            byte[] nameBytes = nameString.getBytes("UTF-8");
            int nameLength = nameBytes.length - nameOffset;
            this.bufs.setByteBuffer(nameBytes, nameOffset, nameLength);
            this.bufs.byteBuffer.get(name, nameOffset, nameLength);
            length[lengthOffset] = nameLength;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.bufs.intBuffer.get(size, 0, 1);
        this.bufs.intBuffer.get(type, 0, 1);
    }

    public void glGetActiveAttrib(int program, int index, int bufsize, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        IntBuffer typeTmp = BufferUtils.createIntBuffer((int)2);
        GL20.glGetActiveAttrib((int)program, (int)index, (IntBuffer)BufferUtils.createIntBuffer((int)256), (IntBuffer)typeTmp);
        type.put(typeTmp.get(0));
        type.rewind();
    }

    public void glGetActiveUniform(int program, int index, int bufsize, int[] length, int lengthOffset, int[] size, int sizeOffset, int[] type, int typeOffset, byte[] name, int nameOffset) {
        this.bufs.resizeIntBuffer(2);
        String nameString = GL20.glGetActiveUniform((int)program, (int)index, (IntBuffer)BufferUtils.createIntBuffer((int)256), (IntBuffer)this.bufs.intBuffer);
        try {
            byte[] nameBytes = nameString.getBytes("UTF-8");
            int nameLength = nameBytes.length - nameOffset;
            this.bufs.setByteBuffer(nameBytes, nameOffset, nameLength);
            this.bufs.byteBuffer.get(name, nameOffset, nameLength);
            length[lengthOffset] = nameLength;
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        this.bufs.intBuffer.get(size, 0, 1);
        this.bufs.intBuffer.get(type, 0, 1);
    }

    public void glGetActiveUniform(int program, int index, int bufsize, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        IntBuffer typeTmp = BufferUtils.createIntBuffer((int)2);
        GL20.glGetActiveAttrib((int)program, (int)index, (IntBuffer)BufferUtils.createIntBuffer((int)256), (IntBuffer)typeTmp);
        type.put(typeTmp.get(0));
        type.rewind();
    }

    public void glGetAttachedShaders(int program, int maxcount, IntBuffer count, IntBuffer shaders) {
        GL20.glGetAttachedShaders((int)program, (IntBuffer)count, (IntBuffer)shaders);
    }

    public boolean glGetBoolean(int pname) {
        return GL11.glGetBoolean((int)pname);
    }

    public void glGetBooleanv(int pname, ByteBuffer params) {
        GL11.glGetBooleanv((int)pname, (ByteBuffer)params);
    }

    public int glGetBoundBuffer(int arg0) {
        throw new UnsupportedOperationException("glGetBoundBuffer not supported in GLES 2.0 or LWJGL.");
    }

    public float glGetFloat(int pname) {
        return GL11.glGetFloat((int)pname);
    }

    public int glGetInteger(int pname) {
        return GL11.glGetInteger((int)pname);
    }

    public void glGetProgramBinary(int program, int bufSize, IntBuffer length, IntBuffer binaryFormat, Buffer binary) {
        GL41.glGetProgramBinary((int)program, (IntBuffer)length, (IntBuffer)binaryFormat, (ByteBuffer)((ByteBuffer)binary));
    }

    public void glGetProgramInfoLog(int program, int bufsize, IntBuffer length, ByteBuffer infolog) {
        ByteBuffer buffer = ByteBuffer.allocateDirect(10240);
        buffer.order(ByteOrder.nativeOrder());
        ByteBuffer tmp = ByteBuffer.allocateDirect(4);
        tmp.order(ByteOrder.nativeOrder());
        IntBuffer intBuffer = tmp.asIntBuffer();
        GL20.glGetProgramInfoLog((int)program, (IntBuffer)intBuffer, (ByteBuffer)buffer);
    }

    public void glGetShaderInfoLog(int shader, int bufsize, IntBuffer length, ByteBuffer infolog) {
        GL20.glGetShaderInfoLog((int)shader, (IntBuffer)length, (ByteBuffer)infolog);
    }

    public void glGetShaderPrecisionFormat(int shadertype, int precisiontype, int[] range, int rangeOffset, int[] precision, int precisionOffset) {
        throw new UnsupportedOperationException("NYI");
    }

    public void glGetShaderSource(int shader, int bufsize, int[] length, int lengthOffset, byte[] source, int sourceOffset) {
        throw new UnsupportedOperationException("NYI");
    }

    public void glGetShaderSource(int shader, int bufsize, IntBuffer length, ByteBuffer source) {
        throw new UnsupportedOperationException("NYI");
    }

    public boolean glIsVBOArrayEnabled() {
        throw new UnsupportedOperationException("NYI - not in LWJGL.");
    }

    public boolean glIsVBOElementEnabled() {
        throw new UnsupportedOperationException("NYI - not in LWJGL.");
    }

    public ByteBuffer glMapBuffer(int target, int access) {
        return GL15.glMapBuffer((int)target, (int)access, null);
    }

    public void glProgramBinary(int program, int binaryFormat, Buffer binary, int length) {
        GL41.glProgramBinary((int)program, (int)binaryFormat, (ByteBuffer)((ByteBuffer)binary));
    }

    public void glReadPixels(int x, int y, int width, int height, int format, int type, int pixelsBufferOffset) {
        GL11.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)format, (int)type, (long)pixelsBufferOffset);
    }

    public void glShaderBinary(int n, int[] shaders, int offset, int binaryformat, Buffer binary, int length) {
        throw new UnsupportedOperationException("NYI");
    }

    public void glShaderSource(int shader, int count, String[] strings, int[] length, int lengthOff) {
        for (String str : strings) {
            GL20.glShaderSource((int)shader, (CharSequence)str);
        }
    }

    public void glShaderSource(int shader, int count, String[] strings, IntBuffer length) {
        for (String str : strings) {
            GL20.glShaderSource((int)shader, (CharSequence)str);
        }
    }

    public void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, int pixels) {
        GL11.glTexImage2D((int)target, (int)level, (int)internalformat, (int)width, (int)height, (int)border, (int)format, (int)type, (long)pixels);
    }

    public void glTexImage3D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, Buffer arg9) {
        if (!(arg9 instanceof ByteBuffer)) {
            throw new UnsupportedOperationException("Buffer must be a ByteBuffer.");
        }
        GL12.glTexImage3D((int)arg0, (int)arg1, (int)arg2, (int)arg3, (int)arg4, (int)arg5, (int)arg6, (int)arg7, (int)arg8, (ByteBuffer)((ByteBuffer)arg9));
    }

    public void glTexImage3D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9) {
        GL12.glTexImage3D((int)arg0, (int)arg1, (int)arg2, (int)arg3, (int)arg4, (int)arg5, (int)arg6, (int)arg7, (int)arg8, (long)arg9);
    }

    public void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, int pixels) {
        GL11.glTexSubImage2D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)width, (int)height, (int)format, (int)type, (long)pixels);
    }

    public void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, Buffer pixels) {
        GL12.glTexSubImage3D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (int)format, (int)type, (ByteBuffer)((ByteBuffer)pixels));
    }

    public void glTexSubImage3D(int target, int level, int xoffset, int yoffset, int zoffset, int width, int height, int depth, int format, int type, int pixels) {
        ByteBuffer byteBuffer = BufferUtils.createByteBuffer((int)1);
        byteBuffer.putInt(pixels);
        byteBuffer.rewind();
        GL12.glTexSubImage3D((int)target, (int)level, (int)xoffset, (int)yoffset, (int)zoffset, (int)width, (int)height, (int)depth, (int)format, (int)type, (ByteBuffer)byteBuffer);
    }

    public boolean glUnmapBuffer(int target) {
        return GL15.glUnmapBuffer((int)target);
    }

    public boolean hasGLSL() {
        throw new UnsupportedOperationException("NYI - not in LWJGL.");
    }

    public boolean isExtensionAvailable(String extension) {
        throw new UnsupportedOperationException("NYI - not in LWJGL.");
    }

    public boolean isFunctionAvailable(String function) {
        throw new UnsupportedOperationException("NYI - not in LWJGL.");
    }
}

