/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.nio.ByteBuffer;
import javax.swing.JOptionPane;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWCharCallback;
import org.lwjgl.glfw.GLFWCursorPosCallback;
import org.lwjgl.glfw.GLFWKeyCallback;
import org.lwjgl.glfw.GLFWMouseButtonCallback;
import org.lwjgl.glfw.GLFWScrollCallback;
import playn.core.Key;
import playn.core.Keyboard;
import playn.core.Mouse;
import playn.java.JavaInput;
import playn.java.JavaPlatform;
import playn.java.LWJGLPlatform;
import pythagoras.f.Point;
import react.RFuture;

public class GLFWInput
extends JavaInput {
    private final LWJGLPlatform plat;
    private final long window;
    private float lastMouseX = -1.0f;
    private float lastMouseY = -1.0f;
    private final GLFWCharCallback charCallback = new GLFWCharCallback(){

        public void invoke(long window, int codepoint) {
            GLFWInput.this.emitKeyTyped(System.currentTimeMillis(), (char)codepoint);
        }
    };
    private final GLFWKeyCallback keyCallback = new GLFWKeyCallback(){

        public void invoke(long window, int keyCode, int scancode, int action, int mods) {
            boolean pressed;
            int flags = GLFWInput.this.modifierFlags();
            double time = System.currentTimeMillis();
            Key key = GLFWInput.this.translateKey(keyCode);
            boolean bl = pressed = action == 1 || action == 2;
            if (key != null) {
                GLFWInput.this.emitKeyPress(time, key, pressed, flags);
            } else {
                GLFWInput.this.plat.log().warn("Unknown keyCode:" + keyCode);
            }
        }
    };
    private final GLFWMouseButtonCallback mouseBtnCallback = new GLFWMouseButtonCallback(){

        public void invoke(long handle, int btnIdx, int action, int mods) {
            double time = System.currentTimeMillis();
            Point m = GLFWInput.this.queryCursorPosition();
            Mouse.ButtonEvent.Id btn = GLFWInput.getButton(btnIdx);
            if (btn == null) {
                return;
            }
            GLFWInput.this.emitMouseButton(time, m.x, m.y, btn, action == 1, mods);
        }
    };
    private final GLFWCursorPosCallback cursorPosCallback = new GLFWCursorPosCallback(){

        public void invoke(long handle, double xpos, double ypos) {
            double time = System.currentTimeMillis();
            float x = (float)xpos;
            float y = (float)ypos;
            if (GLFWInput.this.lastMouseX == -1.0f) {
                GLFWInput.this.lastMouseX = x;
                GLFWInput.this.lastMouseY = y;
            }
            float dx = x - GLFWInput.this.lastMouseX;
            float dy = y - GLFWInput.this.lastMouseY;
            GLFWInput.this.emitMouseMotion(time, x, y, dx, dy, GLFWInput.this.modifierFlags());
            GLFWInput.this.lastMouseX = x;
            GLFWInput.this.lastMouseY = y;
        }
    };
    private final GLFWScrollCallback scrollCallback = new GLFWScrollCallback(){

        public void invoke(long handle, double xoffset, double yoffset) {
            Point m = GLFWInput.this.queryCursorPosition();
            double time = System.currentTimeMillis();
            if (212995 == GLFW.glfwGetInputMode((long)GLFWInput.this.window, (int)208897)) {
                GLFWInput.this.emitMouseMotion(time, m.x, m.y, (float)xoffset, -((float)yoffset), 0);
            } else {
                GLFWInput.this.emitMouseWheel(time, m.x, m.y, yoffset > 0.0 ? -1 : 1, 0);
            }
        }
    };
    private static String NO_UI_ERROR = "The java-lwjgl backend does not allow interop with AWT on Mac OS X. Use the java-swt backend if you need native dialogs.";
    private ByteBuffer xpos = BufferUtils.createByteBuffer((int)8);
    private ByteBuffer ypos = BufferUtils.createByteBuffer((int)8);
    private Point cpos = new Point();

    public GLFWInput(LWJGLPlatform plat, long window) {
        super((JavaPlatform)plat);
        this.plat = plat;
        this.window = window;
        GLFW.glfwSetCharCallback((long)window, (GLFWCharCallback)this.charCallback);
        GLFW.glfwSetKeyCallback((long)window, (GLFWKeyCallback)this.keyCallback);
        GLFW.glfwSetMouseButtonCallback((long)window, (GLFWMouseButtonCallback)this.mouseBtnCallback);
        GLFW.glfwSetCursorPosCallback((long)window, (GLFWCursorPosCallback)this.cursorPosCallback);
        GLFW.glfwSetScrollCallback((long)window, (GLFWScrollCallback)this.scrollCallback);
    }

    void update() {
        GLFW.glfwPollEvents();
        super.update();
    }

    void shutdown() {
        this.charCallback.release();
        this.keyCallback.release();
        this.mouseBtnCallback.release();
        this.cursorPosCallback.release();
        this.scrollCallback.release();
    }

    public RFuture<String> getText(Keyboard.TextType textType, String label, String initVal) {
        if (this.plat.needsHeadless()) {
            throw new UnsupportedOperationException(NO_UI_ERROR);
        }
        Object result = JOptionPane.showInputDialog(null, label, "", 3, null, null, initVal);
        return RFuture.success((Object)((String)result));
    }

    public RFuture<Boolean> sysDialog(String title, String text, String ok, String cancel) {
        Object[] objectArray;
        int msgType;
        if (this.plat.needsHeadless()) {
            throw new UnsupportedOperationException(NO_UI_ERROR);
        }
        int optType = 2;
        int n = msgType = cancel == null ? 1 : 3;
        if (cancel == null) {
            Object[] objectArray2 = new Object[1];
            objectArray = objectArray2;
            objectArray2[0] = ok;
        } else {
            Object[] objectArray3 = new Object[2];
            objectArray3[0] = ok;
            objectArray = objectArray3;
            objectArray3[1] = cancel;
        }
        Object[] options = objectArray;
        String defOption = cancel == null ? ok : cancel;
        int result = JOptionPane.showOptionDialog(null, text, title, optType, msgType, null, options, defOption);
        return RFuture.success((Object)(result == 0 ? 1 : 0));
    }

    public boolean hasMouseLock() {
        return true;
    }

    public boolean isMouseLocked() {
        return GLFW.glfwGetInputMode((long)this.window, (int)208897) == 212995;
    }

    public void setMouseLocked(boolean locked) {
        GLFW.glfwSetInputMode((long)this.window, (int)208897, (int)(locked ? 212995 : 212993));
    }

    private Point queryCursorPosition() {
        this.xpos.rewind();
        this.ypos.rewind();
        GLFW.glfwGetCursorPos((long)this.window, (ByteBuffer)this.xpos, (ByteBuffer)this.ypos);
        this.cpos.set((float)this.xpos.getDouble(), (float)this.ypos.getDouble());
        return this.cpos;
    }

    private int modifierFlags() {
        return this.modifierFlags(this.isKeyDown(342) || this.isKeyDown(342), this.isKeyDown(341) || this.isKeyDown(345), this.isKeyDown(343) || this.isKeyDown(347), this.isKeyDown(340) || this.isKeyDown(344));
    }

    private boolean isKeyDown(int key) {
        return GLFW.glfwGetKey((long)this.window, (int)key) == 1;
    }

    private static Mouse.ButtonEvent.Id getButton(int lwjglButton) {
        switch (lwjglButton) {
            case 0: {
                return Mouse.ButtonEvent.Id.LEFT;
            }
            case 2: {
                return Mouse.ButtonEvent.Id.MIDDLE;
            }
            case 1: {
                return Mouse.ButtonEvent.Id.RIGHT;
            }
        }
        return null;
    }

    private Key translateKey(int keyCode) {
        switch (keyCode) {
            case 256: {
                return Key.ESCAPE;
            }
            case 49: {
                return Key.K1;
            }
            case 50: {
                return Key.K2;
            }
            case 51: {
                return Key.K3;
            }
            case 52: {
                return Key.K4;
            }
            case 53: {
                return Key.K5;
            }
            case 54: {
                return Key.K6;
            }
            case 55: {
                return Key.K7;
            }
            case 56: {
                return Key.K8;
            }
            case 57: {
                return Key.K9;
            }
            case 48: {
                return Key.K0;
            }
            case 45: {
                return Key.MINUS;
            }
            case 61: {
                return Key.EQUALS;
            }
            case 259: {
                return Key.BACK;
            }
            case 258: {
                return Key.TAB;
            }
            case 81: {
                return Key.Q;
            }
            case 87: {
                return Key.W;
            }
            case 69: {
                return Key.E;
            }
            case 82: {
                return Key.R;
            }
            case 84: {
                return Key.T;
            }
            case 89: {
                return Key.Y;
            }
            case 85: {
                return Key.U;
            }
            case 73: {
                return Key.I;
            }
            case 79: {
                return Key.O;
            }
            case 80: {
                return Key.P;
            }
            case 91: {
                return Key.LEFT_BRACKET;
            }
            case 93: {
                return Key.RIGHT_BRACKET;
            }
            case 257: {
                return Key.ENTER;
            }
            case 345: {
                return Key.CONTROL;
            }
            case 341: {
                return Key.CONTROL;
            }
            case 65: {
                return Key.A;
            }
            case 83: {
                return Key.S;
            }
            case 68: {
                return Key.D;
            }
            case 70: {
                return Key.F;
            }
            case 71: {
                return Key.G;
            }
            case 72: {
                return Key.H;
            }
            case 74: {
                return Key.J;
            }
            case 75: {
                return Key.K;
            }
            case 76: {
                return Key.L;
            }
            case 59: {
                return Key.SEMICOLON;
            }
            case 39: {
                return Key.QUOTE;
            }
            case 96: {
                return Key.BACKQUOTE;
            }
            case 340: {
                return Key.SHIFT;
            }
            case 92: {
                return Key.BACKSLASH;
            }
            case 90: {
                return Key.Z;
            }
            case 88: {
                return Key.X;
            }
            case 67: {
                return Key.C;
            }
            case 86: {
                return Key.V;
            }
            case 66: {
                return Key.B;
            }
            case 78: {
                return Key.N;
            }
            case 77: {
                return Key.M;
            }
            case 44: {
                return Key.COMMA;
            }
            case 46: {
                return Key.PERIOD;
            }
            case 47: {
                return Key.SLASH;
            }
            case 344: {
                return Key.SHIFT;
            }
            case 332: {
                return Key.MULTIPLY;
            }
            case 32: {
                return Key.SPACE;
            }
            case 280: {
                return Key.CAPS_LOCK;
            }
            case 290: {
                return Key.F1;
            }
            case 291: {
                return Key.F2;
            }
            case 292: {
                return Key.F3;
            }
            case 293: {
                return Key.F4;
            }
            case 294: {
                return Key.F5;
            }
            case 295: {
                return Key.F6;
            }
            case 296: {
                return Key.F7;
            }
            case 297: {
                return Key.F8;
            }
            case 298: {
                return Key.F9;
            }
            case 299: {
                return Key.F10;
            }
            case 282: {
                return Key.NP_NUM_LOCK;
            }
            case 281: {
                return Key.SCROLL_LOCK;
            }
            case 327: {
                return Key.NP7;
            }
            case 328: {
                return Key.NP8;
            }
            case 329: {
                return Key.NP9;
            }
            case 333: {
                return Key.NP_SUBTRACT;
            }
            case 324: {
                return Key.NP4;
            }
            case 325: {
                return Key.NP5;
            }
            case 326: {
                return Key.NP6;
            }
            case 334: {
                return Key.NP_ADD;
            }
            case 321: {
                return Key.NP1;
            }
            case 322: {
                return Key.NP2;
            }
            case 323: {
                return Key.NP3;
            }
            case 320: {
                return Key.NP0;
            }
            case 330: {
                return Key.NP_DECIMAL;
            }
            case 300: {
                return Key.F11;
            }
            case 301: {
                return Key.F12;
            }
            case 346: {
                return Key.ALT;
            }
            case 342: {
                return Key.ALT;
            }
            case 348: {
                return Key.FUNCTION;
            }
            case 284: {
                return Key.PAUSE;
            }
            case 268: {
                return Key.HOME;
            }
            case 265: {
                return Key.UP;
            }
            case 266: {
                return Key.PAGE_UP;
            }
            case 263: {
                return Key.LEFT;
            }
            case 262: {
                return Key.RIGHT;
            }
            case 269: {
                return Key.END;
            }
            case 264: {
                return Key.DOWN;
            }
            case 267: {
                return Key.PAGE_DOWN;
            }
            case 260: {
                return Key.INSERT;
            }
            case 261: {
                return Key.DELETE;
            }
            case 347: {
                return Key.META;
            }
            case 343: {
                return Key.META;
            }
        }
        return null;
    }
}

