/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.nio.IntBuffer;
import org.lwjgl.BufferUtils;
import org.lwjgl.glfw.GLFW;
import org.lwjgl.glfw.GLFWFramebufferSizeCallback;
import org.lwjgl.glfw.GLFWVidMode;
import org.lwjgl.system.MemoryUtil;
import playn.core.Scale;
import playn.java.JavaPlatform;
import playn.java.LWJGLGraphics;
import pythagoras.f.Dimension;
import pythagoras.f.IDimension;

public class GLFWGraphics
extends LWJGLGraphics {
    private final GLFWFramebufferSizeCallback fbSizeCallback = new GLFWFramebufferSizeCallback(){

        public void invoke(long window, int width, int height) {
            GLFWGraphics.this.viewportAndScaleChanged(width, height);
        }
    };
    private final Dimension screenSize = new Dimension();
    private final JavaPlatform plat;
    private final long window;

    public GLFWGraphics(JavaPlatform jplat, long window) {
        super(jplat);
        this.plat = jplat;
        this.window = window;
        GLFW.glfwSetFramebufferSizeCallback((long)window, (GLFWFramebufferSizeCallback)this.fbSizeCallback);
    }

    void shutdown() {
        this.fbSizeCallback.release();
    }

    void setTitle(String title) {
        if (this.window != 0L) {
            GLFW.glfwSetWindowTitle((long)this.window, (CharSequence)title);
        }
    }

    public void setSize(int width, int height, boolean fullscreen) {
        if (this.plat.config.fullscreen != fullscreen) {
            this.plat.log().warn("fullscreen cannot be changed via setSize, use config.fullscreen instead");
            return;
        }
        GLFW.glfwSetWindowSize((long)this.window, (int)width, (int)height);
        this.viewSizeM.setSize((float)width, (float)height);
        IntBuffer fbSize = BufferUtils.createIntBuffer((int)2);
        long addr = MemoryUtil.memAddress((IntBuffer)fbSize);
        GLFW.nglfwGetFramebufferSize((long)this.window, (long)addr, (long)(addr + 4L));
        this.viewportAndScaleChanged(fbSize.get(0), fbSize.get(1));
    }

    public IDimension screenSize() {
        GLFWVidMode vidMode = GLFW.glfwGetVideoMode((long)GLFW.glfwGetPrimaryMonitor());
        this.screenSize.width = vidMode.width();
        this.screenSize.height = vidMode.height();
        return this.screenSize;
    }

    private void viewportAndScaleChanged(int fbWidth, int fbHeight) {
        float scale = (float)fbWidth / this.viewSizeM.width;
        if (scale != this.scale().factor) {
            this.scaleChanged(new Scale(scale));
        }
        this.viewportChanged(fbWidth, fbHeight);
    }
}

