/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.font.TextLayout;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;
import java.util.ArrayList;
import playn.core.TextFormat;
import playn.core.TextWrap;
import playn.java.JavaGraphics;
import pythagoras.f.IRectangle;
import pythagoras.f.Rectangle;

class JavaTextLayout
extends playn.core.TextLayout {
    private final TextLayout layout;

    public static JavaTextLayout layoutText(JavaGraphics gfx, String text, TextFormat format) {
        AttributedString astring = new AttributedString(text.length() == 0 ? " " : text);
        if (format.font != null) {
            astring.addAttribute(TextAttribute.FONT, gfx.resolveFont(format.font));
        }
        FontRenderContext frc = format.antialias ? gfx.aaFontContext() : gfx.aFontContext();
        return new JavaTextLayout(text, format, new TextLayout(astring.getIterator(), frc));
    }

    public static JavaTextLayout[] layoutText(JavaGraphics gfx, String text, TextFormat format, TextWrap wrap) {
        String ltext = (text = JavaTextLayout.normalizeEOL((String)text)).length() == 0 ? " " : text;
        AttributedString astring = new AttributedString(ltext);
        if (format.font != null) {
            astring.addAttribute(TextAttribute.FONT, gfx.resolveFont(format.font));
        }
        ArrayList<JavaTextLayout> layouts = new ArrayList<JavaTextLayout>();
        FontRenderContext frc = format.antialias ? gfx.aaFontContext() : gfx.aFontContext();
        LineBreakMeasurer measurer = new LineBreakMeasurer(astring.getIterator(), frc);
        int lastPos = ltext.length();
        int curPos = 0;
        char eol = '\n';
        while (curPos < lastPos) {
            int nextRet = ltext.indexOf(eol, measurer.getPosition() + 1);
            if (nextRet == -1) {
                nextRet = lastPos;
            }
            TextLayout layout = measurer.nextLayout(wrap.width, nextRet, false);
            int endPos = measurer.getPosition();
            while (curPos < endPos && ltext.charAt(curPos) == eol) {
                ++curPos;
            }
            layouts.add(new JavaTextLayout(ltext.substring(curPos, endPos), format, layout));
            curPos = endPos;
        }
        return layouts.toArray(new JavaTextLayout[layouts.size()]);
    }

    JavaTextLayout(String text, TextFormat format, TextLayout layout) {
        super(text, format, (IRectangle)JavaTextLayout.computeBounds(layout), layout.getAscent() + layout.getDescent());
        this.layout = layout;
    }

    public float ascent() {
        return this.layout.getAscent();
    }

    public float descent() {
        return this.layout.getDescent();
    }

    public float leading() {
        return this.layout.getLeading();
    }

    void stroke(Graphics2D gfx, float x, float y) {
        this.paint(gfx, x, y, true);
    }

    void fill(Graphics2D gfx, float x, float y) {
        this.paint(gfx, x, y, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void paint(Graphics2D gfx, float x, float y, boolean stroke) {
        Object ohint = gfx.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        try {
            gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, this.format.antialias ? RenderingHints.VALUE_ANTIALIAS_ON : RenderingHints.VALUE_ANTIALIAS_OFF);
            float yoff = y + this.layout.getAscent();
            if (stroke) {
                gfx.translate(x, yoff);
                gfx.draw(this.layout.getOutline(null));
                gfx.translate(-x, -yoff);
            } else {
                this.layout.draw(gfx, x, yoff);
            }
        }
        finally {
            gfx.setRenderingHint(RenderingHints.KEY_ANTIALIASING, ohint);
        }
    }

    private static Rectangle computeBounds(TextLayout layout) {
        Rectangle2D bounds = layout.getBounds();
        return new Rectangle((float)bounds.getX(), (float)bounds.getY() + layout.getAscent(), (float)bounds.getWidth(), (float)bounds.getHeight());
    }
}

