/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.prefs.AbstractPreferences;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import playn.core.BatchImpl;
import playn.core.Log;
import playn.core.Storage;

class JavaStorage
implements Storage {
    private final Log log;
    private final Preferences preferences;
    private boolean isPersisted;

    JavaStorage(Log log, String storageFileName) {
        this.log = log;
        Preferences prefs = null;
        try {
            this.isPersisted = Preferences.userRoot().nodeExists(storageFileName);
            prefs = Preferences.userRoot().node(storageFileName);
        }
        catch (Exception e) {
            log.warn("Couldn't open Preferences: " + e.getMessage());
            this.isPersisted = false;
            prefs = new MemoryPreferences();
        }
        this.preferences = prefs;
    }

    public void setItem(String key, String value) {
        this.preferences.put(key, value);
        this.maybePersistPreferences();
    }

    public void removeItem(String key) {
        this.preferences.remove(key);
        this.maybePersistPreferences();
    }

    public String getItem(String key) {
        return this.preferences.get(key, null);
    }

    public Storage.Batch startBatch() {
        return new BatchImpl(this){

            protected void setImpl(String key, String data) {
                JavaStorage.this.preferences.put(key, data);
            }

            protected void removeImpl(String key) {
                JavaStorage.this.preferences.remove(key);
            }

            protected void onAfterCommit() {
                JavaStorage.this.maybePersistPreferences();
            }
        };
    }

    public Iterable<String> keys() {
        try {
            return Arrays.asList(this.preferences.keys());
        }
        catch (Exception e) {
            this.log.warn("Error reading preferences: " + e.getMessage());
            return Collections.emptyList();
        }
    }

    public boolean isPersisted() {
        return this.isPersisted;
    }

    private void maybePersistPreferences() {
        if (this.preferences instanceof MemoryPreferences) {
            return;
        }
        try {
            this.preferences.flush();
            this.isPersisted = true;
        }
        catch (Exception e) {
            this.log.info("Error persisting properties: " + e.getMessage());
            this.isPersisted = false;
        }
    }

    private class MemoryPreferences
    extends AbstractPreferences {
        protected Map<String, String> _values;

        MemoryPreferences() {
            super(null, "");
            this._values = new HashMap<String, String>();
        }

        @Override
        protected void putSpi(String key, String value) {
            this._values.put(key, value);
        }

        @Override
        protected String getSpi(String key) {
            return this._values.get(key);
        }

        @Override
        protected void removeSpi(String key) {
            this._values.remove(key);
        }

        @Override
        protected void removeNodeSpi() throws BackingStoreException {
            throw new BackingStoreException("Not implemented");
        }

        @Override
        protected String[] keysSpi() throws BackingStoreException {
            return this._values.keySet().toArray(new String[this._values.size()]);
        }

        @Override
        protected String[] childrenNamesSpi() throws BackingStoreException {
            throw new BackingStoreException("Not implemented");
        }

        @Override
        protected AbstractPreferences childSpi(String name) {
            throw new RuntimeException("Not implemented");
        }

        @Override
        protected void syncSpi() throws BackingStoreException {
            throw new BackingStoreException("Not implemented");
        }

        @Override
        protected void flushSpi() throws BackingStoreException {
            throw new BackingStoreException("Not implemented");
        }
    }
}

