/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import java.awt.Desktop;
import java.awt.image.BufferedImage;
import java.net.URI;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import playn.core.Exec;
import playn.core.Json;
import playn.core.Key;
import playn.core.Keyboard;
import playn.core.Log;
import playn.core.Net;
import playn.core.Platform;
import playn.core.Scale;
import playn.core.Storage;
import playn.core.Texture;
import playn.core.json.JsonImpl;
import playn.java.JavaAssets;
import playn.java.JavaAudio;
import playn.java.JavaGraphics;
import playn.java.JavaInput;
import playn.java.JavaLog;
import playn.java.JavaNet;
import playn.java.JavaStorage;
import pythagoras.f.Dimension;
import pythagoras.f.IDimension;
import react.SignalView;
import react.Slot;

public abstract class JavaPlatform
extends Platform {
    final Config config;
    private boolean active = true;
    private final long start = System.nanoTime();
    private final ExecutorService pool = Executors.newFixedThreadPool(4);
    private final JavaLog log = new JavaLog();
    private final Exec exec = new Exec.Default(this){

        public boolean isAsyncSupported() {
            return true;
        }

        public void invokeAsync(Runnable action) {
            JavaPlatform.this.pool.execute(action);
        }
    };
    private final JavaAudio audio = new JavaAudio(this.exec);
    private final JavaNet net = new JavaNet(this.exec);
    private final JavaStorage storage;
    private final JsonImpl json = new JsonImpl();
    private final JavaGraphics graphics;
    private final JavaInput input;
    private final JavaAssets assets = new JavaAssets(this);

    public JavaPlatform(final Config config) {
        this.config = config;
        this.preInit();
        this.graphics = this.createGraphics();
        this.input = this.createInput();
        this.storage = new JavaStorage(this.log, config.storageFileName);
        if (config.activationKey != null) {
            this.input.keyboardEvents.connect((SignalView.Listener)new Slot<Keyboard.Event>(){

                public void onEmit(Keyboard.Event event) {
                    if (event instanceof Keyboard.KeyEvent) {
                        Keyboard.KeyEvent kevent = (Keyboard.KeyEvent)event;
                        if (kevent.key == config.activationKey && kevent.down) {
                            JavaPlatform.this.toggleActivation();
                        }
                    }
                }
            });
        }
        this.setTitle(config.appName);
        this.graphics.init();
        this.input.init();
    }

    public abstract void setTitle(String var1);

    public abstract void start();

    public double time() {
        return System.currentTimeMillis();
    }

    public Platform.Type type() {
        return Platform.Type.JAVA;
    }

    public int tick() {
        return (int)((System.nanoTime() - this.start) / 1000000L);
    }

    public JavaAssets assets() {
        return this.assets;
    }

    public JavaAudio audio() {
        return this.audio;
    }

    public Exec exec() {
        return this.exec;
    }

    public JavaGraphics graphics() {
        return this.graphics;
    }

    public JavaInput input() {
        return this.input;
    }

    public Json json() {
        return this.json;
    }

    public Log log() {
        return this.log;
    }

    public Net net() {
        return this.net;
    }

    public Storage storage() {
        return this.storage;
    }

    public void openURL(String url) {
        try {
            Desktop.getDesktop().browse(URI.create(url));
        }
        catch (Exception e) {
            this.reportError("Failed to open URL [url=" + url + "]", e);
        }
    }

    protected abstract void preInit();

    protected abstract JavaGraphics createGraphics();

    protected abstract JavaInput createInput();

    protected void shutdown() {
        this.dispatchEvent(this.lifecycle, Platform.Lifecycle.EXIT);
        try {
            this.pool.shutdown();
            this.pool.awaitTermination(1L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        System.exit(0);
    }

    protected void processFrame() {
        this.input.update();
        this.emitFrame();
    }

    protected void toggleActivation() {
        this.active = !this.active;
    }

    public static class Headless
    extends JavaPlatform {
        public Headless(Config config) {
            super(config);
        }

        @Override
        public void start() {
        }

        @Override
        public void setTitle(String title) {
        }

        @Override
        protected void preInit() {
        }

        @Override
        protected JavaGraphics createGraphics() {
            return new JavaGraphics(this, null, Scale.ONE){
                {
                    this.setSize(Headless.this.config.width, Headless.this.config.height, Headless.this.config.fullscreen);
                }

                @Override
                public void setSize(int width, int height, boolean fullscreen) {
                    this.viewportChanged(width, height);
                }

                public IDimension screenSize() {
                    return new Dimension((float)Headless.this.config.width, (float)Headless.this.config.height);
                }

                @Override
                protected void init() {
                }

                @Override
                protected void upload(BufferedImage img, Texture tex) {
                }
            };
        }

        @Override
        protected JavaInput createInput() {
            return new JavaInput(this);
        }
    }

    public static class Config {
        public String storageFileName = "playn";
        public int width = 640;
        public int height = 480;
        public boolean fullscreen;
        public boolean emulateTouch;
        public Key pivotKey = Key.F11;
        public Key activationKey;
        public boolean convertImagesOnLoad = true;
        public String appName = "Game";
        public boolean truePause;
    }
}

