/*
 * Decompiled with CFR 0.152.
 */
package playn.html;

import com.google.gwt.canvas.dom.client.CanvasPixelArray;
import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.canvas.dom.client.ImageData;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.CanvasElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.dom.client.NativeEvent;
import playn.core.Graphics;
import playn.core.Image;
import playn.core.ImageImpl;
import playn.core.Pattern;
import playn.core.Scale;
import playn.core.Texture;
import playn.html.EventHandler;
import playn.html.HtmlBitmapTransformer;
import playn.html.HtmlGraphics;
import playn.html.HtmlInput;
import playn.html.HtmlPattern;
import react.RFuture;
import react.RPromise;

public class HtmlImage
extends ImageImpl {
    private ImageElement img;
    CanvasElement canvas;

    private static native boolean isComplete(ImageElement var0);

    public HtmlImage(Graphics gfx, Scale scale, CanvasElement elem, String source) {
        super(gfx, scale, elem.getWidth(), elem.getHeight(), source, (Object)elem);
        this.canvas = elem;
    }

    public HtmlImage(Graphics gfx, Scale scale, ImageElement elem, String source) {
        super(gfx, (RFuture)RPromise.create(), scale, elem.getWidth(), elem.getHeight(), source);
        this.img = elem;
        RPromise pstate = (RPromise)this.state;
        if (HtmlImage.isComplete(this.img)) {
            pstate.succeed((Object)this);
        } else {
            final Scale fscale = scale;
            HtmlInput.addEventListener((JavaScriptObject)this.img, "load", new EventHandler(){

                @Override
                public void handleEvent(NativeEvent evt) {
                    HtmlImage.this.succeed(new ImageImpl.Data(fscale, (Object)HtmlImage.this.img, HtmlImage.this.img.getWidth(), HtmlImage.this.img.getHeight()));
                }
            }, false);
            HtmlInput.addEventListener((JavaScriptObject)this.img, "error", new EventHandler(){

                @Override
                public void handleEvent(NativeEvent evt) {
                    HtmlImage.this.fail(new RuntimeException("Error loading image " + HtmlImage.this.img.getSrc()));
                }
            }, false);
        }
    }

    public HtmlImage(Graphics gfx, Throwable error) {
        super(gfx, RFuture.failure((Throwable)error), Scale.ONE, 50, 50, "<error>");
        this.setBitmap(this.createErrorBitmap(this.pixelWidth, this.pixelHeight));
    }

    public ImageElement imageElement() {
        return this.img;
    }

    HtmlImage preload(int prePixelWidth, int prePixelHeight) {
        this.pixelWidth = prePixelWidth;
        this.pixelHeight = prePixelHeight;
        return this;
    }

    public Pattern createPattern(boolean repeatX, boolean repeatY) {
        assert (this.isLoaded()) : "Cannot createPattern() a non-ready image";
        return new HtmlPattern(this.img, repeatX, repeatY);
    }

    public void getRgb(int startX, int startY, int width, int height, int[] rgbArray, int offset, int scanSize) {
        assert (this.isLoaded()) : "Cannot getRgb() a non-ready image";
        if (this.canvas == null) {
            this.canvas = this.img.getOwnerDocument().createCanvasElement();
            this.canvas.setHeight(this.img.getHeight());
            this.canvas.setWidth(this.img.getWidth());
            this.canvas.getContext2d().drawImage(this.img, 0.0, 0.0);
        }
        Context2d ctx = this.canvas.getContext2d();
        ImageData imageData = ctx.getImageData((double)startX, (double)startY, (double)width, (double)height);
        CanvasPixelArray pixelData = imageData.getData();
        int i = 0;
        int dst = offset;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int r = pixelData.get(i++);
                int g = pixelData.get(i++);
                int b = pixelData.get(i++);
                int a = pixelData.get(i++);
                rgbArray[dst + x] = a << 24 | r << 16 | g << 8 | b;
            }
            dst += scanSize;
        }
    }

    public void setRgb(int startX, int startY, int width, int height, int[] rgbArray, int offset, int scanSize) {
        Context2d ctx = this.canvas.getContext2d();
        ImageData imageData = ctx.createImageData(width, height);
        CanvasPixelArray pixelData = imageData.getData();
        int i = 0;
        int dst = offset;
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                int argb = rgbArray[dst + x];
                pixelData.set(i++, argb >> 16 & 0xFF);
                pixelData.set(i++, argb >> 8 & 0xFF);
                pixelData.set(i++, argb & 0xFF);
                pixelData.set(i++, argb >> 24 & 0xFF);
            }
            dst += scanSize;
        }
        ctx.putImageData(imageData, (double)startX, (double)startY);
    }

    public Image transform(Image.BitmapTransformer xform) {
        return new HtmlImage(this.gfx, this.scale, ((HtmlBitmapTransformer)xform).transform(this.img), this.source);
    }

    public void draw(Object ctx, float x, float y, float width, float height) {
        ((Context2d)ctx).drawImage(this.img, (double)x, (double)y, (double)width, (double)height);
    }

    public void draw(Object ctx, float dx, float dy, float dw, float dh, float sx, float sy, float sw, float sh) {
        ((Context2d)ctx).drawImage(this.img, (double)(sx *= this.scale.factor), (double)(sy *= this.scale.factor), (double)(sw *= this.scale.factor), (double)(sh *= this.scale.factor), (double)dx, (double)dy, (double)dw, (double)dh);
    }

    public String toString() {
        return "Image[src=" + this.source + ", scale=" + this.scale + ", size=" + this.width() + "x" + this.height() + ", psize=" + this.pixelWidth + "x" + this.pixelHeight + ", img=" + this.img + ", canvas=" + this.canvas + "]";
    }

    protected void setBitmap(Object bitmap) {
        this.img = (ImageElement)bitmap;
    }

    protected Object createErrorBitmap(int pixelWidth, int pixelHeight) {
        ImageElement img = Document.get().createImageElement();
        img.setWidth(pixelWidth);
        img.setHeight(pixelHeight);
        return img;
    }

    protected void upload(Graphics gfx, Texture tex) {
        ((HtmlGraphics)gfx).updateTexture(tex.id, this.img);
    }
}

