/*
 * Decompiled with CFR 0.152.
 */
package playn.html;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.CanvasElement;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.typedarrays.shared.ArrayBuffer;
import com.google.gwt.typedarrays.shared.ArrayBufferView;
import com.google.gwt.typedarrays.shared.Float32Array;
import com.google.gwt.typedarrays.shared.Int16Array;
import com.google.gwt.typedarrays.shared.Int32Array;
import com.google.gwt.typedarrays.shared.TypedArrays;
import com.google.gwt.webgl.client.WebGLBuffer;
import com.google.gwt.webgl.client.WebGLFramebuffer;
import com.google.gwt.webgl.client.WebGLProgram;
import com.google.gwt.webgl.client.WebGLRenderbuffer;
import com.google.gwt.webgl.client.WebGLRenderingContext;
import com.google.gwt.webgl.client.WebGLShader;
import com.google.gwt.webgl.client.WebGLTexture;
import com.google.gwt.webgl.client.WebGLUniformLocation;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import playn.core.GL20;
import playn.html.HasArrayBufferView;
import playn.html.HtmlUrlParameters;

public final class HtmlGL20
extends GL20 {
    static final int VERTEX_ATTRIB_ARRAY_COUNT = 5;
    private final IntMap<WebGLProgram> programs = IntMap.create();
    private final IntMap<WebGLShader> shaders = IntMap.create();
    private final IntMap<WebGLBuffer> buffers = IntMap.create();
    private final IntMap<WebGLFramebuffer> frameBuffers = IntMap.create();
    private final IntMap<WebGLRenderbuffer> renderBuffers = IntMap.create();
    private final IntMap<WebGLTexture> textures = IntMap.create();
    private final IntMap<IntMap<WebGLUniformLocation>> uniforms = IntMap.create();
    private int currProgram = 0;
    private int enabledArrays = 0;
    private int previouslyEnabledArrays = 0;
    private int useNioBuffer = 0;
    private VertexAttribArrayState[] vertexAttribArrayState = new VertexAttribArrayState[5];
    private WebGLBuffer elementBuffer;
    private WebGLBuffer boundArrayBuffer;
    private WebGLBuffer requestedArrayBuffer;
    private WebGLBuffer boundElementArrayBuffer;
    private WebGLBuffer requestedElementArrayBuffer;
    private WebGLRenderingContext gl;

    public HtmlGL20() {
        super(new GL20.Buffers(){

            public ByteBuffer createByteBuffer(int size) {
                ByteBuffer buffer = ByteBuffer.allocateDirect(size);
                buffer.order(ByteOrder.nativeOrder());
                return buffer;
            }
        }, HtmlUrlParameters.checkGLErrors);
    }

    public Float32Array copy(FloatBuffer buffer) {
        return ((Float32Array)((HasArrayBufferView)((Object)buffer)).getTypedArray()).subarray(buffer.position(), buffer.remaining());
    }

    public Int16Array copy(ShortBuffer buffer) {
        return ((Int16Array)((HasArrayBufferView)((Object)buffer)).getTypedArray()).subarray(buffer.position(), buffer.remaining());
    }

    public Int32Array copy(IntBuffer buffer) {
        return ((Int32Array)((HasArrayBufferView)((Object)buffer)).getTypedArray()).subarray(buffer.position(), buffer.remaining());
    }

    private static int getElementSize(Buffer buffer) {
        if (buffer instanceof FloatBuffer || buffer instanceof IntBuffer) {
            return 4;
        }
        if (buffer instanceof ShortBuffer) {
            return 2;
        }
        if (buffer instanceof ByteBuffer) {
            return 1;
        }
        throw new RuntimeException("Unrecognized buffer type: " + buffer.getClass());
    }

    private ArrayBufferView getTypedArray(Buffer buffer, int type, int byteSize) {
        if (!(buffer instanceof HasArrayBufferView)) {
            throw new RuntimeException("Native buffer required " + buffer);
        }
        HasArrayBufferView arrayHolder = (HasArrayBufferView)((Object)buffer);
        int bufferElementSize = arrayHolder.getElementSize();
        ArrayBufferView webGLArray = arrayHolder.getTypedArray();
        if (byteSize == -1) {
            byteSize = buffer.remaining() * bufferElementSize;
        }
        if (byteSize == buffer.capacity() * bufferElementSize && type == arrayHolder.getElementType()) {
            return webGLArray;
        }
        int byteOffset = webGLArray.byteOffset() + buffer.position() * bufferElementSize;
        switch (type) {
            case 5126: {
                return TypedArrays.createFloat32Array((ArrayBuffer)webGLArray.buffer(), (int)byteOffset, (int)(byteSize / 4));
            }
            case 5121: {
                return TypedArrays.createUint8Array((ArrayBuffer)webGLArray.buffer(), (int)byteOffset, (int)byteSize);
            }
            case 5123: {
                return TypedArrays.createUint16Array((ArrayBuffer)webGLArray.buffer(), (int)byteOffset, (int)(byteSize / 2));
            }
            case 5124: {
                return TypedArrays.createInt32Array((ArrayBuffer)webGLArray.buffer(), (int)byteOffset, (int)(byteSize / 4));
            }
            case 5122: {
                return TypedArrays.createInt16Array((ArrayBuffer)webGLArray.buffer(), (int)byteOffset, (int)(byteSize / 2));
            }
            case 5120: {
                return TypedArrays.createInt8Array((ArrayBuffer)webGLArray.buffer(), (int)byteOffset, (int)byteSize);
            }
        }
        throw new IllegalArgumentException("Type: " + type);
    }

    private int getTypeSize(int type) {
        switch (type) {
            case 5124: 
            case 5126: {
                return 4;
            }
            case 5122: 
            case 5123: {
                return 2;
            }
            case 5120: 
            case 5121: {
                return 1;
            }
        }
        throw new IllegalArgumentException();
    }

    private WebGLUniformLocation getUniformLocation(int location) {
        return this.uniforms.get(this.currProgram).get(location);
    }

    void init(WebGLRenderingContext gl) {
        gl.pixelStorei(37441, 1);
        this.gl = gl;
        this.elementBuffer = gl.createBuffer();
        for (int ii = 0; ii < 5; ++ii) {
            VertexAttribArrayState data = new VertexAttribArrayState();
            data.webGlBuffer = gl.createBuffer();
            this.vertexAttribArrayState[ii] = data;
        }
    }

    protected void prepareDraw() {
        VertexAttribArrayState previousNio = null;
        int previousElementSize = 0;
        if (this.useNioBuffer == 0 && this.enabledArrays == this.previouslyEnabledArrays) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            int mask = 1 << i;
            int enabled = this.enabledArrays & mask;
            if (enabled != (this.previouslyEnabledArrays & mask)) {
                if (enabled != 0) {
                    this.gl.enableVertexAttribArray(i);
                } else {
                    this.gl.disableVertexAttribArray(i);
                }
            }
            if (enabled == 0 || (this.useNioBuffer & mask) == 0) continue;
            VertexAttribArrayState data = this.vertexAttribArrayState[i];
            if (previousNio != null && previousNio.nioBuffer == data.nioBuffer && previousNio.nioBufferLimit >= data.nioBufferLimit) {
                if (this.boundArrayBuffer != previousNio.webGlBuffer) {
                    this.gl.bindBuffer(34962, previousNio.webGlBuffer);
                    this.boundArrayBuffer = data.webGlBuffer;
                }
                this.gl.vertexAttribPointer(i, data.size, data.type, data.normalize, data.stride, data.nioBufferPosition * previousElementSize);
                continue;
            }
            if (this.boundArrayBuffer != data.webGlBuffer) {
                this.gl.bindBuffer(34962, data.webGlBuffer);
                this.boundArrayBuffer = data.webGlBuffer;
            }
            int elementSize = HtmlGL20.getElementSize(data.nioBuffer);
            int savePosition = data.nioBuffer.position();
            if (data.nioBufferPosition * elementSize < data.stride) {
                data.nioBuffer.position(0);
                this.gl.bufferData(34962, this.getTypedArray(data.nioBuffer, data.type, data.nioBufferLimit * elementSize), 35040);
                this.gl.vertexAttribPointer(i, data.size, data.type, data.normalize, data.stride, data.nioBufferPosition * elementSize);
                previousNio = data;
                previousElementSize = elementSize;
            } else {
                data.nioBuffer.position(data.nioBufferPosition);
                this.gl.bufferData(34962, this.getTypedArray(data.nioBuffer, data.type, (data.nioBufferLimit - data.nioBufferPosition) * elementSize), 35040);
                this.gl.vertexAttribPointer(i, data.size, data.type, data.normalize, data.stride, 0);
            }
            data.nioBuffer.position(savePosition);
        }
        this.previouslyEnabledArrays = this.enabledArrays;
    }

    public int getSwapInterval() {
        throw new RuntimeException("NYI getSwapInterval");
    }

    public void glActiveTexture(int texture) {
        this.gl.activeTexture(texture);
    }

    public void glAttachShader(int program, int shader) {
        WebGLProgram glProgram = this.programs.get(program);
        WebGLShader glShader = this.shaders.get(shader);
        this.gl.attachShader(glProgram, glShader);
    }

    public void glBindAttribLocation(int program, int index, String name) {
        WebGLProgram glProgram = this.programs.get(program);
        this.gl.bindAttribLocation(glProgram, index, name);
    }

    public void glBindBuffer(int target, int buffer) {
        WebGLBuffer webGlBuf = this.buffers.get(buffer);
        if (target == 34962) {
            this.requestedArrayBuffer = webGlBuf;
        } else if (target == 34963) {
            this.requestedElementArrayBuffer = webGlBuf;
        } else {
            this.gl.bindBuffer(target, webGlBuf);
        }
    }

    public void glBindFramebuffer(int target, int framebuffer) {
        this.gl.bindFramebuffer(target, this.frameBuffers.get(framebuffer));
    }

    public void glBindRenderbuffer(int target, int renderbuffer) {
        this.gl.bindRenderbuffer(target, this.renderBuffers.get(renderbuffer));
    }

    public void glBindTexture(int target, int texture) {
        this.gl.bindTexture(target, this.textures.get(texture));
    }

    public void glBlendColor(float red, float green, float blue, float alpha) {
        this.gl.blendColor(red, green, blue, alpha);
    }

    public void glBlendEquation(int mode) {
        this.gl.blendEquation(mode);
    }

    public void glBlendEquationSeparate(int modeRGB, int modeAlpha) {
        this.gl.blendEquationSeparate(modeRGB, modeAlpha);
    }

    public void glBlendFunc(int sfactor, int dfactor) {
        this.gl.blendFunc(sfactor, dfactor);
    }

    public void glBlendFuncSeparate(int srcRGB, int dstRGB, int srcAlpha, int dstAlpha) {
        this.gl.blendFuncSeparate(srcRGB, dstRGB, srcAlpha, dstAlpha);
    }

    public void glBufferData(int target, int byteSize, Buffer data, int usage) {
        if (target == 34962) {
            if (this.requestedArrayBuffer != this.boundArrayBuffer) {
                this.gl.bindBuffer(target, this.requestedArrayBuffer);
                this.boundArrayBuffer = this.requestedArrayBuffer;
            }
        } else if (target == 34963 && this.requestedElementArrayBuffer != this.boundElementArrayBuffer) {
            this.gl.bindBuffer(target, this.requestedElementArrayBuffer);
            this.boundElementArrayBuffer = this.requestedElementArrayBuffer;
        }
        this.gl.bufferData(target, this.getTypedArray(data, 5120, byteSize), usage);
    }

    public void glBufferSubData(int target, int offset, int size, Buffer data) {
        if (target == 34962 && this.requestedArrayBuffer != this.boundArrayBuffer) {
            this.gl.bindBuffer(target, this.requestedArrayBuffer);
            this.boundArrayBuffer = this.requestedArrayBuffer;
        }
        throw new RuntimeException("NYI glBufferSubData");
    }

    public int glCheckFramebufferStatus(int target) {
        return this.gl.checkFramebufferStatus(target);
    }

    public final void glClear(int mask) {
        this.gl.clear(mask);
    }

    public final void glClearColor(float red, float green, float blue, float alpha) {
        this.gl.clearColor(red, green, blue, alpha);
    }

    public void glClearDepth(double depth) {
        this.gl.clearDepth((float)depth);
    }

    public void glClearDepthf(float depth) {
        this.gl.clearDepth(depth);
    }

    public void glClearStencil(int s) {
        this.gl.clearStencil(s);
    }

    public void glColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        this.gl.colorMask(red, green, blue, alpha);
    }

    public void glCompileShader(int shader) {
        WebGLShader glShader = this.shaders.get(shader);
        this.gl.compileShader(glShader);
    }

    public void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, Buffer data) {
        throw new RuntimeException("NYI glCompressedTexImage2D");
    }

    public void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, Buffer data) {
        throw new RuntimeException("NYI glCompressedTexSubImage2D");
    }

    public void glCompressedTexImage3D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, Buffer arg8) {
        throw new RuntimeException("NYI glCompressedTexImage3D");
    }

    public void glCompressedTexImage2D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7) {
        throw new RuntimeException("NYI glCompressedTexImage2D");
    }

    public void glCompressedTexImage3D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8) {
        throw new RuntimeException("NYI glCompressedTexImage3D");
    }

    public void glCompressedTexSubImage2D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8) {
        throw new RuntimeException("NYI glCompressedTexSubImage2D");
    }

    public void glCompressedTexSubImage3D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10) {
        throw new RuntimeException("NYI glCompressedTexSubImage3D");
    }

    public void glCompressedTexSubImage3D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, Buffer arg10) {
        throw new RuntimeException("NYI glCompressedTexSubImage3D");
    }

    public void glCopyTexSubImage3D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8) {
        throw new RuntimeException("NYI glCopyTexSubImage3D");
    }

    public void glCopyTexImage2D(int target, int level, int internalformat, int x, int y, int width, int height, int border) {
        this.gl.copyTexImage2D(target, level, internalformat, x, y, width, height, border);
    }

    public void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        this.gl.copyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
    }

    public int glCreateProgram() {
        WebGLProgram program = this.gl.createProgram();
        return this.programs.add(program);
    }

    public int glCreateShader(int type) {
        WebGLShader shader = this.gl.createShader(type);
        return this.shaders.add(shader);
    }

    public final void glCullFace(int mode) {
        this.gl.cullFace(mode);
    }

    public void glDeleteBuffers(int n, IntBuffer buffers) {
        int pos = buffers.position();
        for (int i = 0; i < n; ++i) {
            int id = buffers.get(pos + i);
            WebGLBuffer buffer = this.buffers.remove(id);
            this.gl.deleteBuffer(buffer);
        }
    }

    public void glDeleteBuffers(int n, int[] buffers, int offset) {
        for (int i = 0; i < n; ++i) {
            int id = buffers[i + offset];
            WebGLBuffer buffer = this.buffers.remove(id);
            this.gl.deleteBuffer(buffer);
        }
    }

    public void glDeleteFramebuffers(int n, IntBuffer framebuffers) {
        int pos = framebuffers.position();
        for (int i = 0; i < n; ++i) {
            int id = framebuffers.get(pos + i);
            WebGLFramebuffer fb = this.frameBuffers.remove(id);
            this.gl.deleteFramebuffer(fb);
        }
    }

    public void glDeleteFramebuffers(int n, int[] framebuffers, int offset) {
        for (int i = 0; i < n; ++i) {
            int id = framebuffers[i + offset];
            WebGLFramebuffer fb = this.frameBuffers.remove(id);
            this.gl.deleteFramebuffer(fb);
        }
    }

    public void glDeleteProgram(int program) {
        WebGLProgram prog = this.programs.remove(program);
        this.gl.deleteProgram(prog);
    }

    public void glDeleteRenderbuffers(int n, IntBuffer renderbuffers) {
        int pos = renderbuffers.position();
        for (int i = 0; i < n; ++i) {
            int id = renderbuffers.get(pos + i);
            WebGLRenderbuffer rb = this.renderBuffers.remove(id);
            this.gl.deleteRenderbuffer(rb);
        }
    }

    public void glDeleteRenderbuffers(int n, int[] renderbuffers, int offset) {
        for (int i = 0; i < n; ++i) {
            int id = renderbuffers[i + offset];
            WebGLRenderbuffer rb = this.renderBuffers.remove(id);
            this.gl.deleteRenderbuffer(rb);
        }
    }

    public void glDeleteShader(int shader) {
        WebGLShader sh = this.shaders.remove(shader);
        this.gl.deleteShader(sh);
    }

    public void glDeleteTextures(int n, IntBuffer textures) {
        int pos = textures.position();
        for (int i = 0; i < n; ++i) {
            int id = textures.get(pos + i);
            WebGLTexture texture = this.textures.remove(id);
            this.gl.deleteTexture(texture);
        }
    }

    public void glDeleteTextures(int n, int[] textures, int offset) {
        for (int i = 0; i < n; ++i) {
            int id = textures[i + offset];
            WebGLTexture texture = this.textures.remove(id);
            this.gl.deleteTexture(texture);
        }
    }

    public void glDepthFunc(int func) {
        this.gl.depthFunc(func);
    }

    public void glDepthMask(boolean flag) {
        this.gl.depthMask(flag);
    }

    public void glDepthRange(double zNear, double zFar) {
        this.gl.depthRange((float)zNear, (float)zFar);
    }

    public void glDepthRangef(float zNear, float zFar) {
        this.gl.depthRange(zNear, zFar);
    }

    public void glDetachShader(int program, int shader) {
        this.gl.detachShader(this.programs.get(program), this.shaders.get(shader));
    }

    public void glDisable(int cap) {
        this.gl.disable(cap);
    }

    public void glDisableVertexAttribArray(int index) {
        this.enabledArrays &= ~(1 << index);
    }

    public void glDrawArrays(int mode, int first, int count) {
        this.prepareDraw();
        this.gl.drawArrays(mode, first, count);
    }

    public void glDrawElements(int mode, int count, int type, Buffer indices) {
        this.prepareDraw();
        if (this.boundElementArrayBuffer != this.elementBuffer) {
            this.gl.bindBuffer(34963, this.elementBuffer);
            this.boundElementArrayBuffer = this.elementBuffer;
        }
        this.gl.bufferData(34963, this.getTypedArray(indices, type, count * this.getTypeSize(type)), 35040);
        this.gl.drawElements(mode, count, type, 0);
    }

    public void glDrawElements(int mode, int count, int type, int indices) {
        this.prepareDraw();
        if (this.requestedElementArrayBuffer != this.boundElementArrayBuffer) {
            this.gl.bindBuffer(34963, this.requestedElementArrayBuffer);
            this.boundElementArrayBuffer = this.requestedElementArrayBuffer;
        }
        this.gl.drawElements(mode, count, type, indices);
    }

    public void glEnable(int cap) {
        this.gl.enable(cap);
    }

    public void glEnableVertexAttribArray(int index) {
        this.enabledArrays |= 1 << index;
    }

    public void glFinish() {
        this.gl.finish();
    }

    public void glFlush() {
        this.gl.flush();
    }

    public void glFramebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer) {
        this.gl.framebufferRenderbuffer(target, attachment, renderbuffertarget, this.renderBuffers.get(renderbuffer));
    }

    public void glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level) {
        this.gl.framebufferTexture2D(target, attachment, textarget, this.textures.get(texture), level);
    }

    public void glFramebufferTexture3D(int target, int attachment, int textarget, int texture, int level, int zoffset) {
        throw new RuntimeException("NYI glFramebufferTexture3D");
    }

    public void glFrontFace(int mode) {
        this.gl.frontFace(mode);
    }

    public int glGenBuffer() {
        WebGLBuffer buffer = this.gl.createBuffer();
        return this.buffers.add(buffer);
    }

    public void glGenBuffers(int n, IntBuffer buffers) {
        int pos = buffers.position();
        for (int i = 0; i < n; ++i) {
            WebGLBuffer buffer = this.gl.createBuffer();
            int id = this.buffers.add(buffer);
            buffers.put(pos + i, id);
        }
    }

    public void glGenBuffers(int n, int[] buffers, int offset) {
        for (int i = 0; i < n; ++i) {
            int id;
            WebGLBuffer buffer = this.gl.createBuffer();
            buffers[i + offset] = id = this.buffers.add(buffer);
        }
    }

    public void glGenerateMipmap(int target) {
        this.gl.generateMipmap(target);
    }

    public void glGenFramebuffers(int n, IntBuffer framebuffers) {
        int pos = framebuffers.position();
        for (int i = 0; i < n; ++i) {
            WebGLFramebuffer fb = this.gl.createFramebuffer();
            int id = this.frameBuffers.add(fb);
            framebuffers.put(pos + i, id);
        }
    }

    public void glGenFramebuffers(int n, int[] framebuffers, int offset) {
        for (int i = 0; i < n; ++i) {
            int id;
            WebGLFramebuffer fb = this.gl.createFramebuffer();
            framebuffers[i + offset] = id = this.frameBuffers.add(fb);
        }
    }

    public void glGenRenderbuffers(int n, IntBuffer renderbuffers) {
        int pos = renderbuffers.position();
        for (int i = 0; i < n; ++i) {
            WebGLRenderbuffer rb = this.gl.createRenderbuffer();
            int id = this.renderBuffers.add(rb);
            renderbuffers.put(pos + i, id);
        }
    }

    public void glGenRenderbuffers(int n, int[] renderbuffers, int offset) {
        for (int i = 0; i < n; ++i) {
            int id;
            WebGLRenderbuffer rb = this.gl.createRenderbuffer();
            renderbuffers[i + offset] = id = this.renderBuffers.add(rb);
        }
    }

    public void glGenTextures(int n, IntBuffer textures) {
        int pos = textures.position();
        for (int i = 0; i < n; ++i) {
            WebGLTexture texture = this.gl.createTexture();
            int id = this.textures.add(texture);
            textures.put(pos + i, id);
        }
    }

    public void glGenTextures(int n, int[] textures, int offset) {
        for (int i = 0; i < n; ++i) {
            int id;
            WebGLTexture texture = this.gl.createTexture();
            textures[i + offset] = id = this.textures.add(texture);
        }
    }

    public void glGetActiveAttrib(int program, int index, int bufsize, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        throw new RuntimeException("NYI glGetActiveAttrib");
    }

    public void glGetActiveAttrib(int program, int index, int bufsize, int[] length, int lengthOffset, int[] size, int sizeOffset, int[] type, int typeOffset, byte[] name, int nameOffset) {
        throw new RuntimeException("NYI glGetActiveAttrib");
    }

    public void glGetAttachedShaders(int program, int maxcount, IntBuffer count, IntBuffer shaders) {
        throw new RuntimeException("NYI glGetAttachedShaders");
    }

    public void glGetAttachedShaders(int program, int maxcount, int[] count, int countOffset, int[] shaders, int shadersOffset) {
        throw new RuntimeException("NYI glGetAttachedShaders");
    }

    public void glGetActiveUniform(int program, int index, int bufsize, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        throw new RuntimeException("NYI glGetActiveUniform");
    }

    public void glGetActiveUniform(int program, int index, int bufsize, int[] length, int lengthOffset, int[] size, int sizeOffset, int[] type, int typeOffset, byte[] name, int nameOffset) {
        throw new RuntimeException("NYI glGetActiveUniform");
    }

    public int glGetAttribLocation(int program, String name) {
        WebGLProgram prog = this.programs.get(program);
        return this.gl.getAttribLocation(prog, name);
    }

    public boolean glGetBoolean(int pname) {
        return this.gl.getParameterb(pname);
    }

    public void glGetBooleanv(int pname, ByteBuffer params) {
        throw new RuntimeException("NYI glGetBooleanv");
    }

    public int glGetBoundBuffer(int arg0) {
        throw new RuntimeException("NYI glGetBoundBuffer");
    }

    public void glGetBufferParameteriv(int target, int pname, IntBuffer params) {
        params.put(params.position(), this.gl.getBufferParameter(target, pname));
    }

    public final int glGetError() {
        return this.gl.getError();
    }

    public int glGetInteger(int pname) {
        return this.gl.getParameteri(pname);
    }

    public void glGetIntegerv(int pname, IntBuffer params) {
        Int32Array result = (Int32Array)this.gl.getParameterv(pname);
        int pos = params.position();
        int len = result.length();
        for (int i = 0; i < len; ++i) {
            params.put(pos + i, result.get(i));
        }
    }

    public float glGetFloat(int pname) {
        return this.gl.getParameterf(pname);
    }

    public void glGetFloatv(int pname, FloatBuffer params) {
        throw new RuntimeException("NYI glGetFloatv");
    }

    public void glGetFramebufferAttachmentParameteriv(int target, int attachment, int pname, IntBuffer params) {
        throw new RuntimeException("NYI glGetFramebufferAttachmentParameteriv");
    }

    public void glGetProgramiv(int program, int pname, IntBuffer params) {
        if (pname != 35714) {
            throw new RuntimeException("NYI glGetProgramiv");
        }
        params.put(this.gl.getProgramParameterb(this.programs.get(program), 35714) ? 1 : 0);
    }

    public String glGetProgramInfoLog(int program) {
        return this.gl.getProgramInfoLog(this.programs.get(program));
    }

    public void glGetProgramBinary(int arg0, int arg1, IntBuffer arg2, IntBuffer arg3, Buffer arg4) {
        throw new RuntimeException("NYI glGetProgramBinary");
    }

    public void glGetProgramInfoLog(int program, int bufsize, IntBuffer length, ByteBuffer infolog) {
        throw new RuntimeException("NYI glGetProgramInfoLog");
    }

    public void glGetProgramiv(int program, int pname, int[] params, int offset) {
        if (pname != 35714) {
            throw new RuntimeException("NYI glGetProgramiv: " + pname);
        }
        params[offset] = this.gl.getProgramParameterb(this.programs.get(program), 35714) ? 1 : 0;
    }

    public void glGetRenderbufferParameteriv(int target, int pname, IntBuffer params) {
        throw new RuntimeException("NYI glGetRenderbufferParameteriv");
    }

    public void glGetShaderInfoLog(int shader, int bufsize, IntBuffer length, ByteBuffer infolog) {
        throw new RuntimeException("NYI glGetShaderInfoLog");
    }

    public void glGetShaderiv(int shader, int pname, int[] params, int offset) {
        if (pname != 35713) {
            throw new RuntimeException("NYI glGetShaderiv: " + pname);
        }
        params[offset] = this.gl.getShaderParameterb(this.shaders.get(shader), 35713) ? 1 : 0;
    }

    public void glGetShaderPrecisionFormat(int shadertype, int precisiontype, int[] range, int rangeOffset, int[] precision, int precisionOffset) {
        throw new RuntimeException("NYI glGetShaderPrecisionFormat");
    }

    public void glGetShaderSource(int shader, int bufsize, int[] length, int lengthOffset, byte[] source, int sourceOffset) {
        throw new RuntimeException("NYI glGetShaderSource");
    }

    public void glGetShaderSource(int shader, int bufsize, IntBuffer length, ByteBuffer source) {
        throw new RuntimeException("NYI glGetShaderSource");
    }

    public void glGetShaderiv(int shader, int pname, IntBuffer params) {
        if (pname != 35713) {
            throw new RuntimeException("NYI glGetShaderiv: " + pname);
        }
        params.put(this.gl.getShaderParameterb(this.shaders.get(shader), 35713) ? 1 : 0);
    }

    public String glGetShaderInfoLog(int shader) {
        return this.gl.getShaderInfoLog(this.shaders.get(shader));
    }

    public void glGetShaderPrecisionFormat(int shadertype, int precisiontype, IntBuffer range, IntBuffer precision) {
        throw new RuntimeException("NYI glGetShaderInfoLog");
    }

    public String glGetString(int id) {
        return this.gl.getParameterString(id);
    }

    public void glGetTexParameterfv(int target, int pname, FloatBuffer params) {
        params.put(params.position(), this.gl.getTexParameter(target, pname));
    }

    public void glGetTexParameteriv(int target, int pname, IntBuffer params) {
        params.put(params.position(), this.gl.getTexParameter(target, pname));
    }

    public void glGetUniformfv(int program, int location, FloatBuffer params) {
        Float32Array v = (Float32Array)this.gl.getUniformv(this.programs.get(program), this.uniforms.get(program).get(location));
        for (int i = 0; i < v.length(); ++i) {
            params.put(params.position() + i, v.get(i));
        }
    }

    public void glGetUniformiv(int program, int location, IntBuffer params) {
        Int32Array v = (Int32Array)this.gl.getUniformv(this.programs.get(program), this.uniforms.get(program).get(location));
        for (int i = 0; i < v.length(); ++i) {
            params.put(params.position() + i, v.get(i));
        }
    }

    public int glGetUniformLocation(int program, String name) {
        WebGLUniformLocation location = this.gl.getUniformLocation(this.programs.get(program), name);
        IntMap<Object> progUniforms = this.uniforms.get(program);
        if (progUniforms == null) {
            progUniforms = IntMap.create();
            this.uniforms.put(program, progUniforms);
        }
        int id = progUniforms.add(location);
        return id;
    }

    public void glGetVertexAttribfv(int index, int pname, FloatBuffer params) {
        Float32Array v = this.gl.getVertexAttribv(index, pname);
        for (int i = 0; i < v.length(); ++i) {
            params.put(params.position() + i, v.get(i));
        }
    }

    public void glGetVertexAttribiv(int index, int pname, IntBuffer params) {
        throw new UnsupportedOperationException("NYI glGetVertexAttribiv: WebGL getVertexAttribv always returns a float buffer.");
    }

    public void glHint(int target, int mode) {
        this.gl.hint(target, mode);
    }

    public boolean glIsBuffer(int buffer) {
        return this.gl.isBuffer(this.buffers.get(buffer));
    }

    public boolean glIsEnabled(int cap) {
        return this.gl.isEnabled(cap);
    }

    public boolean glIsFramebuffer(int framebuffer) {
        return this.gl.isFramebuffer(this.frameBuffers.get(framebuffer));
    }

    public boolean glIsProgram(int program) {
        return this.gl.isProgram(this.programs.get(program));
    }

    public boolean glIsRenderbuffer(int renderbuffer) {
        return this.gl.isRenderbuffer(this.renderBuffers.get(renderbuffer));
    }

    public boolean glIsShader(int shader) {
        return this.gl.isShader(this.shaders.get(shader));
    }

    public boolean glIsTexture(int texture) {
        return this.gl.isTexture(this.textures.get(texture));
    }

    public boolean glIsVBOArrayEnabled() {
        throw new RuntimeException("NYI glIsVBOArrayEnabled");
    }

    public boolean glIsVBOElementEnabled() {
        throw new RuntimeException("NYI glIsVBOElementEnabled");
    }

    public void glLineWidth(float width) {
        this.gl.lineWidth(width);
    }

    public void glLinkProgram(int program) {
        this.gl.linkProgram(this.programs.get(program));
    }

    public ByteBuffer glMapBuffer(int arg0, int arg1) {
        throw new RuntimeException("NYI glMapBuffer");
    }

    public void glPixelStorei(int i, int j) {
        this.gl.pixelStorei(i, j);
    }

    public String getPlatformGLExtensions() {
        throw new RuntimeException("NYI getPlatformGLExtensions");
    }

    public void glPolygonOffset(float factor, float units) {
        this.gl.polygonOffset(factor, units);
    }

    public void glProgramBinary(int arg0, int arg1, Buffer arg2, int arg3) {
        throw new RuntimeException("NYI glProgramBinary");
    }

    public void glReadPixels(int x, int y, int width, int height, int format, int type, Buffer pixels) {
        this.gl.readPixels(x, y, width, height, format, type, this.getTypedArray(pixels, type, -1));
    }

    public void glReadPixels(int x, int y, int width, int height, int format, int type, int pixelsBufferOffset) {
        throw new RuntimeException("NYI glReadPixels");
    }

    public void glReleaseShaderCompiler() {
        throw new RuntimeException("NYI glReleaseShaderCompiler");
    }

    public void glRenderbufferStorage(int target, int internalformat, int width, int height) {
        this.gl.renderbufferStorage(target, internalformat, width, height);
    }

    public void glSampleCoverage(float value, boolean invert) {
        this.gl.sampleCoverage(value, invert);
    }

    public final void glScissor(int x, int y, int width, int height) {
        this.gl.scissor(x, y, width, height);
    }

    public void glShaderBinary(int n, IntBuffer shaders, int binaryformat, Buffer binary, int length) {
        throw new RuntimeException("NYI glReleaseShaderCompiler");
    }

    public void glShaderBinary(int n, int[] shaders, int offset, int binaryformat, Buffer binary, int length) {
        throw new RuntimeException("NYI glShaderBinary");
    }

    public void glShaderSource(int shader, int count, String[] strings, IntBuffer length) {
        throw new RuntimeException("NYI glShaderSource");
    }

    public void glShaderSource(int shader, int count, String[] strings, int[] length, int lengthOffset) {
        throw new RuntimeException("NYI glShaderSource");
    }

    public void glShaderSource(int shader, String string) {
        this.gl.shaderSource(this.shaders.get(shader), string);
    }

    public void glStencilFunc(int func, int ref, int mask) {
        this.gl.stencilFunc(func, ref, mask);
    }

    public void glStencilFuncSeparate(int face, int func, int ref, int mask) {
        this.gl.stencilFuncSeparate(face, func, ref, mask);
    }

    public void glStencilMask(int mask) {
        this.gl.stencilMask(mask);
    }

    public void glStencilMaskSeparate(int face, int mask) {
        this.gl.stencilMaskSeparate(face, mask);
    }

    public void glStencilOp(int fail, int zfail, int zpass) {
        this.gl.stencilOp(fail, zfail, zpass);
    }

    public void glStencilOpSeparate(int face, int fail, int zfail, int zpass) {
        this.gl.stencilOpSeparate(face, fail, zfail, zpass);
    }

    public void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, Buffer pixels) {
        ArrayBufferView buffer = pixels == null ? null : this.getTypedArray(pixels, type, -1);
        this.gl.texImage2D(target, level, internalformat, width, height, border, format, type, buffer);
    }

    public void glTexImage2D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8) {
        throw new RuntimeException("NYI glTexImage2D");
    }

    public void glTexImage2D(int target, int level, int internalformat, int format, int type, ImageElement image) {
        this.gl.texImage2D(target, level, internalformat, format, type, image);
        this.checkError("texImage2D");
    }

    public void glTexImage2D(int target, int level, int internalformat, int format, int type, CanvasElement image) {
        this.gl.texImage2D(target, level, internalformat, format, type, image);
        this.checkError("texImage2D");
    }

    public void glTexImage3D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, Buffer arg9) {
        throw new RuntimeException("NYI glTexImage3D");
    }

    public void glTexImage3D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9) {
        throw new RuntimeException("NYI glTexImage3D");
    }

    public void glTexParameteri(int glTexture2d, int glTextureMinFilter, int glFilterMin) {
        this.gl.texParameteri(glTexture2d, glTextureMinFilter, glFilterMin);
    }

    public void glTexParameterf(int target, int pname, float param) {
        this.gl.texParameterf(target, pname, param);
    }

    public void glTexParameterfv(int target, int pname, FloatBuffer params) {
        throw new RuntimeException("NYI glTexParameterfv");
    }

    public void glTexParameteriv(int target, int pname, IntBuffer params) {
        throw new RuntimeException("NYI glTexParameteriv");
    }

    public void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, Buffer pixels) {
        this.gl.texSubImage2D(target, level, xoffset, yoffset, width, height, format, type, this.getTypedArray(pixels, type, -1));
    }

    public void glTexSubImage2D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8) {
        throw new RuntimeException("NYI glTexSubImage2D");
    }

    public void glTexSubImage3D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, Buffer arg10) {
        throw new RuntimeException("NYI glTexSubImage3D");
    }

    public void glTexSubImage3D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10) {
        throw new RuntimeException("NYI glTexSubImage3D");
    }

    public boolean glUnmapBuffer(int arg0) {
        throw new RuntimeException("NYI glUnmapBuffer");
    }

    public void glUniform1f(int location, float x) {
        this.gl.uniform1f(this.getUniformLocation(location), x);
    }

    public void glUniform1fv(int location, int count, FloatBuffer v) {
        throw new RuntimeException("NYI glUniform1fv");
    }

    public void glUniform1i(int location, int x) {
        this.gl.uniform1i(this.getUniformLocation(location), x);
    }

    public void glUniform1iv(int location, int count, IntBuffer v) {
        this.gl.uniform1iv(this.getUniformLocation(location), (Int32Array)this.getTypedArray(v, 5124, count * 4));
    }

    public void glUniform2f(int location, float x, float y) {
        this.gl.uniform2f(this.getUniformLocation(location), x, y);
    }

    public void glUniform2fv(int location, int count, FloatBuffer v) {
        this.gl.uniform2fv(this.getUniformLocation(location), (Float32Array)this.getTypedArray(v, 5126, count * 2 * 4));
    }

    public void glUniform2i(int location, int x, int y) {
        this.gl.uniform2i(this.getUniformLocation(location), x, y);
    }

    public void glUniform2iv(int location, int count, IntBuffer v) {
        throw new RuntimeException("NYI glUniform2iv");
    }

    public void glUniform3f(int location, float x, float y, float z) {
        this.gl.uniform3f(this.getUniformLocation(location), x, y, z);
    }

    public void glUniform3fv(int location, int count, FloatBuffer v) {
        throw new RuntimeException("NYI glUniform3fv");
    }

    public void glUniform3i(int location, int x, int y, int z) {
        this.gl.uniform3i(this.getUniformLocation(location), x, y, z);
    }

    public void glUniform3iv(int location, int count, IntBuffer v) {
        throw new RuntimeException("NYI glUniform3fi");
    }

    public void glUniform4f(int location, float x, float y, float z, float w) {
        this.gl.uniform4f(this.getUniformLocation(location), x, y, z, w);
    }

    public void glUniform4fv(int location, int count, FloatBuffer v) {
        this.gl.uniform4fv(this.getUniformLocation(location), (Float32Array)this.getTypedArray(v, 5126, 16 * count));
    }

    public void glUniform4i(int location, int x, int y, int z, int w) {
        this.gl.uniform4i(this.getUniformLocation(location), x, y, z, w);
    }

    public void glUniform4iv(int location, int count, IntBuffer v) {
        throw new RuntimeException("NYI glUniform4iv");
    }

    public void glUniformMatrix2fv(int location, int count, boolean transpose, FloatBuffer value) {
        throw new RuntimeException("NYI glUniformMatrix2fv");
    }

    public void glUniformMatrix3fv(int location, int count, boolean transpose, FloatBuffer value) {
        throw new RuntimeException("NYI glUniformMatrix3fv");
    }

    public void glUniformMatrix4fv(int location, int count, boolean transpose, FloatBuffer value) {
        this.gl.uniformMatrix4fv(this.getUniformLocation(location), transpose, (Float32Array)this.getTypedArray(value, 5126, count * 16 * 4));
    }

    public void glUseProgram(int program) {
        this.currProgram = program;
        this.gl.useProgram(this.programs.get(program));
    }

    public void glValidateProgram(int program) {
        this.gl.validateProgram(this.programs.get(program));
    }

    public void glVertexAttrib1f(int indx, float x) {
        this.gl.vertexAttrib1f(indx, x);
    }

    public void glVertexAttrib1fv(int indx, FloatBuffer values) {
        this.gl.vertexAttrib1fv(indx, this.copy(values));
    }

    public void glVertexAttrib2f(int indx, float x, float y) {
        this.gl.vertexAttrib2f(indx, x, y);
    }

    public void glVertexAttrib2fv(int indx, FloatBuffer values) {
        this.gl.vertexAttrib2fv(indx, this.copy(values));
    }

    public void glVertexAttrib3f(int indx, float x, float y, float z) {
        this.gl.vertexAttrib3f(indx, x, y, z);
    }

    public void glVertexAttrib3fv(int indx, FloatBuffer values) {
        this.gl.vertexAttrib3fv(indx, this.copy(values));
    }

    public void glVertexAttrib4f(int indx, float x, float y, float z, float w) {
        this.gl.vertexAttrib4f(indx, x, y, z, w);
    }

    public void glVertexAttrib4fv(int indx, FloatBuffer values) {
        this.gl.vertexAttrib4fv(indx, this.copy(values));
    }

    public void glVertexAttribPointer(int arrayId, int size, int type, boolean normalize, int byteStride, Buffer nioBuffer) {
        VertexAttribArrayState data = this.vertexAttribArrayState[arrayId];
        this.useNioBuffer |= 1 << arrayId;
        data.nioBuffer = nioBuffer;
        data.nioBufferPosition = nioBuffer.position();
        data.nioBufferLimit = nioBuffer.limit();
        data.size = size;
        data.type = type;
        data.normalize = normalize;
        data.stride = byteStride == 0 ? size * this.getTypeSize(type) : byteStride;
    }

    public void glVertexAttribPointer(int indx, int size, int type, boolean normalized, int stride, int ptr) {
        this.useNioBuffer &= ~(1 << indx);
        if (this.boundArrayBuffer != this.requestedArrayBuffer) {
            this.gl.bindBuffer(34962, this.requestedArrayBuffer);
            this.boundArrayBuffer = this.requestedArrayBuffer;
        }
        this.gl.vertexAttribPointer(indx, size, type, normalized, stride, ptr);
    }

    public void glViewport(int x, int y, int w, int h) {
        this.gl.viewport(x, y, w, h);
    }

    public boolean isExtensionAvailable(String extension) {
        throw new RuntimeException("NYI isExtensionAvailable");
    }

    public boolean isFunctionAvailable(String function) {
        throw new RuntimeException("NYI isFunctionAvailable");
    }

    public boolean hasGLSL() {
        return true;
    }

    static final class IntMap<T extends JavaScriptObject>
    extends JavaScriptObject {
        protected IntMap() {
        }

        public static native <T extends JavaScriptObject> IntMap<T> create();

        public native T get(int var1);

        public native void put(int var1, T var2);

        public native int add(T var1);

        public native T remove(int var1);
    }

    static class VertexAttribArrayState {
        int type;
        int size;
        int stride;
        boolean normalize;
        Buffer nioBuffer;
        int nioBufferPosition;
        int nioBufferLimit;
        WebGLBuffer webGlBuffer;

        VertexAttribArrayState() {
        }
    }
}

