/*
 * Copyright 2010 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */
package playn.html.websocket;

import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.typedarrays.shared.ArrayBuffer;

public class MessageEvent extends NativeEvent {

  protected MessageEvent() {
  }

  public final native boolean dataIsText() /*-{
    return typeof this.data === "string";
  }-*/;

  public final native String stringData() /*-{
    return this.data;
  }-*/;

  public final native ArrayBuffer bufferData() /*-{
    return this.data;
  }-*/;
}
