/*
 * Decompiled with CFR 0.152.
 */
package playn.html;

import com.google.gwt.typedarrays.shared.ArrayBuffer;
import com.google.gwt.typedarrays.shared.TypedArrays;
import com.google.gwt.typedarrays.shared.Uint8Array;
import java.nio.ByteBuffer;
import playn.core.Net;
import playn.html.TypedArrayHelper;
import playn.html.websocket.CloseEvent;
import playn.html.websocket.MessageEvent;
import playn.html.websocket.OpenEvent;
import playn.html.websocket.WebSocket;

public class HtmlWebSocket
implements Net.WebSocket {
    private WebSocket ws;

    HtmlWebSocket(String url, final Net.WebSocket.Listener listener) {
        this.ws = WebSocket.create(url);
        this.ws.setListener(new WebSocket.Listener(){

            @Override
            public void onOpen(WebSocket socket, OpenEvent event) {
                listener.onOpen();
            }

            @Override
            public void onMessage(WebSocket socket, MessageEvent event) {
                if (event.dataIsText()) {
                    listener.onTextMessage(event.stringData());
                } else {
                    listener.onDataMessage(TypedArrayHelper.wrap(event.bufferData()));
                }
            }

            @Override
            public void onClose(WebSocket socket, CloseEvent event) {
                listener.onClose();
            }
        });
    }

    public void close() {
        this.ws.close();
    }

    public void send(String data) {
        this.ws.send(data);
    }

    public void send(ByteBuffer data) {
        int len = data.limit();
        ArrayBuffer buf = TypedArrays.createArrayBuffer((int)len);
        Uint8Array view = TypedArrays.createUint8Array((ArrayBuffer)buf);
        for (int i = 0; i < len; ++i) {
            view.set(i, (int)data.get(i));
        }
        this.ws.send(buf);
    }
}

