/*
 * Decompiled with CFR 0.152.
 */
package playn.html;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.Style;
import com.google.gwt.user.client.Window;
import playn.core.Exec;
import playn.core.Input;
import playn.core.Json;
import playn.core.Log;
import playn.core.Net;
import playn.core.Platform;
import playn.core.Storage;
import playn.html.HtmlAssets;
import playn.html.HtmlAudio;
import playn.html.HtmlGraphics;
import playn.html.HtmlInput;
import playn.html.HtmlJson;
import playn.html.HtmlLog;
import playn.html.HtmlNet;
import playn.html.HtmlStorage;
import playn.html.HtmlUrlParameters;

public class HtmlPlatform
extends Platform {
    static final AgentInfo agentInfo = HtmlPlatform.computeAgentInfo();
    private final double start = HtmlPlatform.initNow();
    private int backgroundFrameMillis = 0;
    private final HtmlLog log = (HtmlLog)((Object)GWT.create(HtmlLog.class));
    private final Exec exec = new Exec.Default(this){

        public boolean isMainThread() {
            return true;
        }
    };
    private final HtmlAssets assets;
    private final HtmlAudio audio;
    private final HtmlGraphics graphics;
    private final HtmlInput input;
    private final HtmlJson json = new HtmlJson();
    private final HtmlNet net;
    private final HtmlStorage storage;

    public void setTitle(String title) {
        Window.setTitle((String)title);
    }

    public void setCursor(Style.Cursor cursor) {
        Element rootElement = this.graphics.rootElement;
        if (cursor == null) {
            rootElement.getStyle().setProperty("cursor", "none");
        } else {
            rootElement.getStyle().setCursor(cursor);
        }
    }

    public void disableRightClickContextMenu() {
        HtmlPlatform.disableRightClickImpl((JavaScriptObject)this.graphics.rootElement);
    }

    static native float devicePixelRatio();

    static native float backingStorePixelRatio();

    public HtmlPlatform(Config config) {
        GWT.setUncaughtExceptionHandler((GWT.UncaughtExceptionHandler)new GWT.UncaughtExceptionHandler(){

            public void onUncaughtException(Throwable e) {
                HtmlPlatform.this.reportError("Uncaught Exception: ", e);
            }
        });
        this.log.info("DPR " + HtmlPlatform.devicePixelRatio() + " BSPR " + HtmlPlatform.backingStorePixelRatio());
        try {
            this.backgroundFrameMillis = config.backgroundFrameMillis;
            this.graphics = new HtmlGraphics(this, config);
            this.input = new HtmlInput(this, this.graphics.rootElement);
            this.audio = new HtmlAudio(this);
            this.assets = new HtmlAssets(this);
            this.net = new HtmlNet();
            this.storage = new HtmlStorage(this);
        }
        catch (Throwable e) {
            this.log.error("init()", e);
            Window.alert((String)("failed to init(): " + e.getMessage()));
            throw new RuntimeException(e);
        }
    }

    public void start() {
        this.listenForVizFocusChange(this);
        this.requestAnimationFrame(new Runnable(){

            @Override
            public void run() {
                HtmlPlatform.this.requestAnimationFrame(this);
                HtmlPlatform.this.emitFrame();
            }
        });
    }

    public Platform.Type type() {
        return Platform.Type.HTML;
    }

    public double time() {
        return HtmlPlatform.now();
    }

    public int tick() {
        return (int)(HtmlPlatform.now() - this.start);
    }

    public void openURL(String url) {
        Window.open((String)url, (String)"_blank", (String)"");
    }

    public HtmlAssets assets() {
        return this.assets;
    }

    public HtmlAudio audio() {
        return this.audio;
    }

    public HtmlGraphics graphics() {
        return this.graphics;
    }

    public Exec exec() {
        return this.exec;
    }

    public Input input() {
        return this.input;
    }

    public Json json() {
        return this.json;
    }

    public Log log() {
        return this.log;
    }

    public Net net() {
        return this.net;
    }

    public Storage storage() {
        return this.storage;
    }

    private native JavaScriptObject getWindow();

    private void gainedFocus() {
        this.dispatchEvent(this.input().focus, true);
    }

    private void lostFocus() {
        this.dispatchEvent(this.input().focus, false);
    }

    private void visibilityChanged() {
        boolean isHidden = this.isHidden();
        this.dispatchEvent(this.lifecycle, isHidden ? Platform.Lifecycle.PAUSE : Platform.Lifecycle.RESUME);
        if (isHidden && this.backgroundFrameMillis > 0) {
            this.scheduleBackgroundFrame(this.backgroundFrameMillis, new Runnable(){

                @Override
                public void run() {
                    if (HtmlPlatform.this.isHidden()) {
                        HtmlPlatform.this.scheduleBackgroundFrame(HtmlPlatform.this.backgroundFrameMillis, this);
                        HtmlPlatform.this.emitFrame();
                    }
                }
            });
        }
    }

    private native boolean isHidden();

    private native void listenForVizFocusChange(HtmlPlatform var1);

    private native void requestAnimationFrame(Runnable var1);

    private native void scheduleBackgroundFrame(int var1, Runnable var2);

    private static native AgentInfo computeAgentInfo();

    private static native void disableRightClickImpl(JavaScriptObject var0);

    private static native double initNow();

    private static native double now();

    public static class AgentInfo
    extends JavaScriptObject {
        public final native boolean isFirefox();

        public final native boolean isChrome();

        public final native boolean isSafari();

        public final native boolean isOpera();

        public final native boolean isIE();

        public final native boolean isMacOS();

        public final native boolean isLinux();

        public final native boolean isWindows();

        protected AgentInfo() {
        }
    }

    public static enum Mode {
        WEBGL,
        CANVAS,
        AUTODETECT;

    }

    public static class Config {
        public Mode mode = HtmlUrlParameters.Renderer.requestedMode();
        public boolean transparentCanvas = false;
        public boolean antiAliasing = true;
        public float scaleFactor = HtmlPlatform.devicePixelRatio();
        public float frameBufferPixelRatio = HtmlPlatform.devicePixelRatio();
        public String rootId = "playn-root";
        public int backgroundFrameMillis = 0;
        public boolean experimentalFullscreen = false;
    }
}

