/*
 * Decompiled with CFR 0.152.
 */
package playn.html;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.NativeEvent;
import com.google.gwt.dom.client.Touch;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.user.client.Window;
import playn.core.Input;
import playn.core.Key;
import playn.core.Keyboard;
import playn.core.Mouse;
import playn.core.Platform;
import playn.core.Touch;
import playn.html.EventHandler;
import playn.html.HtmlGraphics;
import playn.html.HtmlPlatform;
import pythagoras.f.Point;
import react.RFuture;

public class HtmlInput
extends Input {
    private final HtmlPlatform plat;
    private final Element rootElement;
    private final Point lastMousePt = new Point();
    private boolean inDragSequence = false;
    private boolean isRequestingMouseLock;
    private boolean inTouchSequence = false;
    private static final int KEY_PAUSE = 19;
    private static final int KEY_CAPS_LOCK = 20;
    private static final int KEY_SPACE = 32;
    private static final int KEY_INSERT = 45;
    private static final int KEY_0 = 48;
    private static final int KEY_1 = 49;
    private static final int KEY_2 = 50;
    private static final int KEY_3 = 51;
    private static final int KEY_4 = 52;
    private static final int KEY_5 = 53;
    private static final int KEY_6 = 54;
    private static final int KEY_7 = 55;
    private static final int KEY_8 = 56;
    private static final int KEY_9 = 57;
    private static final int KEY_A = 65;
    private static final int KEY_B = 66;
    private static final int KEY_C = 67;
    private static final int KEY_D = 68;
    private static final int KEY_E = 69;
    private static final int KEY_F = 70;
    private static final int KEY_G = 71;
    private static final int KEY_H = 72;
    private static final int KEY_I = 73;
    private static final int KEY_J = 74;
    private static final int KEY_K = 75;
    private static final int KEY_L = 76;
    private static final int KEY_M = 77;
    private static final int KEY_N = 78;
    private static final int KEY_O = 79;
    private static final int KEY_P = 80;
    private static final int KEY_Q = 81;
    private static final int KEY_R = 82;
    private static final int KEY_S = 83;
    private static final int KEY_T = 84;
    private static final int KEY_U = 85;
    private static final int KEY_V = 86;
    private static final int KEY_W = 87;
    private static final int KEY_X = 88;
    private static final int KEY_Y = 89;
    private static final int KEY_Z = 90;
    private static final int KEY_LEFT_WINDOW_KEY = 91;
    private static final int KEY_RIGHT_WINDOW_KEY = 92;
    private static final int KEY_NUMPAD0 = 96;
    private static final int KEY_NUMPAD1 = 97;
    private static final int KEY_NUMPAD2 = 98;
    private static final int KEY_NUMPAD3 = 99;
    private static final int KEY_NUMPAD4 = 100;
    private static final int KEY_NUMPAD5 = 101;
    private static final int KEY_NUMPAD6 = 102;
    private static final int KEY_NUMPAD7 = 103;
    private static final int KEY_NUMPAD8 = 104;
    private static final int KEY_NUMPAD9 = 105;
    private static final int KEY_MULTIPLY = 106;
    private static final int KEY_ADD = 107;
    private static final int KEY_SUBTRACT = 109;
    private static final int KEY_DECIMAL_POINT_KEY = 110;
    private static final int KEY_DIVIDE = 111;
    private static final int KEY_F1 = 112;
    private static final int KEY_F2 = 113;
    private static final int KEY_F3 = 114;
    private static final int KEY_F4 = 115;
    private static final int KEY_F5 = 116;
    private static final int KEY_F6 = 117;
    private static final int KEY_F7 = 118;
    private static final int KEY_F8 = 119;
    private static final int KEY_F9 = 120;
    private static final int KEY_F10 = 121;
    private static final int KEY_F11 = 122;
    private static final int KEY_F12 = 123;
    private static final int KEY_NUM_LOCK = 144;
    private static final int KEY_SCROLL_LOCK = 145;
    private static final int KEY_SEMICOLON = 186;
    private static final int KEY_EQUALS = 187;
    private static final int KEY_COMMA = 188;
    private static final int KEY_DASH = 189;
    private static final int KEY_PERIOD = 190;
    private static final int KEY_FORWARD_SLASH = 191;
    private static final int KEY_GRAVE_ACCENT = 192;
    private static final int KEY_OPEN_BRACKET = 219;
    private static final int KEY_BACKSLASH = 220;
    private static final int KEY_CLOSE_BRACKET = 221;
    private static final int KEY_SINGLE_QUOTE = 222;

    public HtmlInput(HtmlPlatform hplat, Element root) {
        super((Platform)hplat);
        this.plat = hplat;
        this.rootElement = root;
        HtmlInput.capturePageEvent("keydown", new EventHandler(){

            @Override
            public void handleEvent(NativeEvent nevent) {
                Key key = HtmlInput.keyForCode(nevent.getKeyCode());
                HtmlInput.this.dispatch((Keyboard.Event)new Keyboard.KeyEvent(0, HtmlInput.this.plat.time(), key, true), nevent);
            }
        });
        HtmlInput.capturePageEvent("keypress", new EventHandler(){

            @Override
            public void handleEvent(NativeEvent nevent) {
                HtmlInput.this.dispatch((Keyboard.Event)new Keyboard.TypedEvent(0, HtmlInput.this.plat.time(), (char)nevent.getCharCode()), nevent);
            }
        });
        HtmlInput.capturePageEvent("keyup", new EventHandler(){

            @Override
            public void handleEvent(NativeEvent nevent) {
                Key key = HtmlInput.keyForCode(nevent.getKeyCode());
                HtmlInput.this.dispatch((Keyboard.Event)new Keyboard.KeyEvent(0, HtmlInput.this.plat.time(), key, false), nevent);
            }
        });
        HtmlInput.addEventListener((JavaScriptObject)Document.get(), "contextmenu", new EventHandler(){

            @Override
            public void handleEvent(NativeEvent evt) {
                evt.preventDefault();
                evt.stopPropagation();
            }
        }, false);
        abstract class XYEventHandler
        implements EventHandler {
            XYEventHandler() {
            }

            @Override
            public void handleEvent(NativeEvent ev) {
                Point xy = HtmlInput.this.plat.graphics().transformMouse(HtmlInput.getRelativeX(ev, HtmlInput.this.rootElement), HtmlInput.getRelativeY(ev, HtmlInput.this.rootElement));
                this.handleEvent(ev, xy.x, xy.y);
            }

            public abstract void handleEvent(NativeEvent var1, float var2, float var3);
        }
        HtmlInput.captureEvent(this.rootElement, "mousedown", new XYEventHandler(){
            {
            }

            @Override
            public void handleEvent(NativeEvent ev, float x, float y) {
                HtmlInput.this.inDragSequence = true;
                Mouse.ButtonEvent.Id btn = HtmlInput.getMouseButton(ev);
                if (btn != null) {
                    HtmlInput.this.dispatch((Mouse.Event)new Mouse.ButtonEvent(0, HtmlInput.this.plat.time(), x, y, btn, true), ev);
                }
            }
        });
        HtmlInput.capturePageEvent("mouseup", new XYEventHandler(){
            {
            }

            @Override
            public void handleEvent(NativeEvent ev, float x, float y) {
                if (HtmlInput.this.inDragSequence) {
                    HtmlInput.this.inDragSequence = false;
                    Mouse.ButtonEvent.Id btn = HtmlInput.getMouseButton(ev);
                    if (btn != null) {
                        HtmlInput.this.dispatch((Mouse.Event)new Mouse.ButtonEvent(0, HtmlInput.this.plat.time(), x, y, btn, false), ev);
                    }
                }
                HtmlInput.this.handleRequestsInUserEventContext();
            }
        });
        abstract class MoveEventHandler
        extends XYEventHandler {
            private float lastX;
            private float lastY;

            MoveEventHandler() {
                this.lastX = -1.0f;
                this.lastY = -1.0f;
            }

            @Override
            public void handleEvent(NativeEvent ev, float x, float y) {
                if (this.lastX == -1.0f) {
                    this.lastX = x;
                    this.lastY = y;
                }
                if (HtmlInput.this.inDragSequence == this.wantDragSequence()) {
                    float dy;
                    float dx;
                    if (HtmlInput.this.isMouseLocked()) {
                        dx = HtmlInput.this.getMovementX(ev);
                        dy = HtmlInput.this.getMovementY(ev);
                    } else {
                        dx = x - this.lastX;
                        dy = y - this.lastY;
                    }
                    HtmlInput.this.dispatch((Mouse.Event)new Mouse.MotionEvent(0, HtmlInput.this.plat.time(), x, y, dx, dy), ev);
                }
                this.lastX = x;
                this.lastY = y;
                HtmlInput.this.lastMousePt.set(x, y);
            }

            protected abstract boolean wantDragSequence();
        }
        HtmlInput.capturePageEvent("mousemove", new MoveEventHandler(){
            {
            }

            @Override
            protected boolean wantDragSequence() {
                return true;
            }
        });
        HtmlInput.captureEvent(this.rootElement, "mousemove", new MoveEventHandler(){
            {
            }

            @Override
            protected boolean wantDragSequence() {
                return false;
            }
        });
        HtmlInput.captureEvent(this.rootElement, HtmlInput.getMouseWheelEvent(), new EventHandler(){

            @Override
            public void handleEvent(NativeEvent ev) {
                float vel = HtmlInput.getMouseWheelVelocity(ev);
                HtmlInput.this.dispatch((Mouse.Event)new Mouse.WheelEvent(0, HtmlInput.this.plat.time(), ((HtmlInput)HtmlInput.this).lastMousePt.x, ((HtmlInput)HtmlInput.this).lastMousePt.y, vel), ev);
            }
        });
        HtmlInput.captureEvent(this.rootElement, "touchstart", new EventHandler(){

            @Override
            public void handleEvent(NativeEvent nevent) {
                HtmlInput.this.inTouchSequence = true;
                HtmlInput.this.dispatch(HtmlInput.this.toTouchEvents(Touch.Event.Kind.START, nevent), nevent);
            }
        });
        HtmlInput.capturePageEvent("touchmove", new EventHandler(){

            @Override
            public void handleEvent(NativeEvent nevent) {
                if (HtmlInput.this.inTouchSequence) {
                    HtmlInput.this.dispatch(HtmlInput.this.toTouchEvents(Touch.Event.Kind.MOVE, nevent), nevent);
                }
            }
        });
        HtmlInput.capturePageEvent("touchend", new EventHandler(){

            @Override
            public void handleEvent(NativeEvent nevent) {
                if (HtmlInput.this.inTouchSequence) {
                    HtmlInput.this.dispatch(HtmlInput.this.toTouchEvents(Touch.Event.Kind.END, nevent), nevent);
                    if (nevent.getTouches().length() == 0) {
                        HtmlInput.this.inTouchSequence = false;
                    }
                }
            }
        });
    }

    public boolean hasHardwareKeyboard() {
        return true;
    }

    public native boolean hasTouch();

    public native boolean hasMouse();

    public native boolean hasMouseLock();

    public RFuture<String> getText(Keyboard.TextType textType, String label, String initVal, String ok, String cancel) {
        String result = Window.prompt((String)label, (String)initVal);
        this.emitFakeMouseUp();
        return RFuture.success((Object)result);
    }

    public RFuture<Boolean> sysDialog(String title, String message, String ok, String cancel) {
        boolean result;
        if (cancel != null) {
            result = Window.confirm((String)message);
        } else {
            Window.alert((String)message);
            result = true;
        }
        this.emitFakeMouseUp();
        return RFuture.success((Object)result);
    }

    private void emitFakeMouseUp() {
        this.emitMouseButton(0, this.plat.time(), 0.0f, 0.0f, Mouse.ButtonEvent.Id.LEFT, false);
    }

    public native boolean isMouseLocked();

    public void setMouseLocked(boolean locked) {
        if (locked) {
            if (this.hasMouseLock()) {
                this.isRequestingMouseLock = true;
                this.plat.log().debug("Requesting mouse lock (supported)");
            } else {
                this.plat.log().debug("Requesting mouse lock -- but unsupported");
            }
        } else {
            this.plat.log().debug("Requesting mouse unlock");
            if (this.hasMouseLock()) {
                this.isRequestingMouseLock = false;
                this.unlockImpl();
            }
        }
    }

    static HandlerRegistration addEventListener(JavaScriptObject target, String name, EventHandler handler, boolean capture) {
        return new EventCloseHandler(target, name, handler, capture);
    }

    static HandlerRegistration capturePageEvent(String name, EventHandler handler) {
        return HtmlInput.addEventListener((JavaScriptObject)Document.get(), name, handler, true);
    }

    static HandlerRegistration captureEvent(Element target, String name, EventHandler handler) {
        return HtmlInput.addEventListener((JavaScriptObject)target, name, handler, true);
    }

    static float getRelativeX(NativeEvent e, Element target) {
        return (float)(e.getClientX() - target.getAbsoluteLeft() + target.getScrollLeft() + target.getOwnerDocument().getScrollLeft()) / HtmlGraphics.experimentalScale;
    }

    static float getRelativeY(NativeEvent e, Element target) {
        return (float)(e.getClientY() - target.getAbsoluteTop() + target.getScrollTop() + target.getOwnerDocument().getScrollTop()) / HtmlGraphics.experimentalScale;
    }

    void handleRequestsInUserEventContext() {
        if (this.isRequestingMouseLock && !this.isMouseLocked()) {
            this.requestMouseLockImpl(this.rootElement);
        }
    }

    private int mods(NativeEvent event) {
        return this.modifierFlags(event.getAltKey(), event.getCtrlKey(), event.getMetaKey(), event.getShiftKey());
    }

    private void dispatch(Keyboard.Event event, NativeEvent nevent) {
        if (this.keyboardEnabled) {
            try {
                event.setFlag(this.mods(nevent));
                this.plat.dispatchEvent(this.keyboardEvents, event);
            }
            finally {
                if (event.isSet(1)) {
                    nevent.preventDefault();
                }
            }
        }
    }

    private void dispatch(Mouse.Event event, NativeEvent nevent) {
        if (this.mouseEnabled) {
            try {
                event.setFlag(this.mods(nevent));
                this.plat.dispatchEvent(this.mouseEvents, event);
            }
            finally {
                if (event.isSet(1)) {
                    nevent.preventDefault();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dispatch(Touch.Event[] events, NativeEvent nevent) {
        if (this.touchEnabled) {
            try {
                this.plat.dispatchEvent(this.touchEvents, events);
            }
            finally {
                for (Touch.Event event : events) {
                    if (!event.isSet(1)) continue;
                    nevent.preventDefault();
                }
            }
        }
    }

    private native int getMovementX(NativeEvent var1);

    private native int getMovementY(NativeEvent var1);

    native void requestMouseLockImpl(Element var1);

    private static native float getMouseWheelVelocity(NativeEvent var0);

    protected static native String getMouseWheelEvent();

    protected static Mouse.ButtonEvent.Id getMouseButton(NativeEvent evt) {
        switch (evt.getButton()) {
            case 1: {
                return Mouse.ButtonEvent.Id.LEFT;
            }
            case 4: {
                return Mouse.ButtonEvent.Id.MIDDLE;
            }
            case 2: {
                return Mouse.ButtonEvent.Id.RIGHT;
            }
        }
        return null;
    }

    private native void unlockImpl();

    private Touch.Event[] toTouchEvents(Touch.Event.Kind kind, NativeEvent nevent) {
        JsArray nativeTouches = nevent.getChangedTouches();
        int nativeTouchesLen = nativeTouches.length();
        Touch.Event[] touches = new Touch.Event[nativeTouchesLen];
        double time = this.plat.time();
        for (int t = 0; t < nativeTouchesLen; ++t) {
            Touch touch = (Touch)nativeTouches.get(t);
            float x = touch.getRelativeX(this.rootElement);
            float y = touch.getRelativeY(this.rootElement);
            Point xy = this.plat.graphics().transformMouse(x, y);
            int id = HtmlInput.getTouchIdentifier(nevent, t);
            touches[t] = new Touch.Event(0, time, xy.x, xy.y, kind, id);
        }
        return touches;
    }

    private static native int getTouchIdentifier(NativeEvent var0, int var1);

    private static Key keyForCode(int keyCode) {
        switch (keyCode) {
            case 18: {
                return Key.ALT;
            }
            case 8: {
                return Key.BACKSPACE;
            }
            case 17: {
                return Key.CONTROL;
            }
            case 46: {
                return Key.DELETE;
            }
            case 40: {
                return Key.DOWN;
            }
            case 35: {
                return Key.END;
            }
            case 13: {
                return Key.ENTER;
            }
            case 27: {
                return Key.ESCAPE;
            }
            case 36: {
                return Key.HOME;
            }
            case 37: {
                return Key.LEFT;
            }
            case 34: {
                return Key.PAGE_DOWN;
            }
            case 33: {
                return Key.PAGE_UP;
            }
            case 39: {
                return Key.RIGHT;
            }
            case 16: {
                return Key.SHIFT;
            }
            case 9: {
                return Key.TAB;
            }
            case 38: {
                return Key.UP;
            }
            case 19: {
                return Key.PAUSE;
            }
            case 20: {
                return Key.CAPS_LOCK;
            }
            case 32: {
                return Key.SPACE;
            }
            case 45: {
                return Key.INSERT;
            }
            case 48: {
                return Key.K0;
            }
            case 49: {
                return Key.K1;
            }
            case 50: {
                return Key.K2;
            }
            case 51: {
                return Key.K3;
            }
            case 52: {
                return Key.K4;
            }
            case 53: {
                return Key.K5;
            }
            case 54: {
                return Key.K6;
            }
            case 55: {
                return Key.K7;
            }
            case 56: {
                return Key.K8;
            }
            case 57: {
                return Key.K9;
            }
            case 65: {
                return Key.A;
            }
            case 66: {
                return Key.B;
            }
            case 67: {
                return Key.C;
            }
            case 68: {
                return Key.D;
            }
            case 69: {
                return Key.E;
            }
            case 70: {
                return Key.F;
            }
            case 71: {
                return Key.G;
            }
            case 72: {
                return Key.H;
            }
            case 73: {
                return Key.I;
            }
            case 74: {
                return Key.J;
            }
            case 75: {
                return Key.K;
            }
            case 76: {
                return Key.L;
            }
            case 77: {
                return Key.M;
            }
            case 78: {
                return Key.N;
            }
            case 79: {
                return Key.O;
            }
            case 80: {
                return Key.P;
            }
            case 81: {
                return Key.Q;
            }
            case 82: {
                return Key.R;
            }
            case 83: {
                return Key.S;
            }
            case 84: {
                return Key.T;
            }
            case 85: {
                return Key.U;
            }
            case 86: {
                return Key.V;
            }
            case 87: {
                return Key.W;
            }
            case 88: {
                return Key.X;
            }
            case 89: {
                return Key.Y;
            }
            case 90: {
                return Key.Z;
            }
            case 91: {
                return Key.WINDOWS;
            }
            case 92: {
                return Key.WINDOWS;
            }
            case 96: {
                return Key.NP0;
            }
            case 97: {
                return Key.NP1;
            }
            case 98: {
                return Key.NP2;
            }
            case 99: {
                return Key.NP3;
            }
            case 100: {
                return Key.NP4;
            }
            case 101: {
                return Key.NP5;
            }
            case 102: {
                return Key.NP6;
            }
            case 103: {
                return Key.NP7;
            }
            case 104: {
                return Key.NP8;
            }
            case 105: {
                return Key.NP9;
            }
            case 106: {
                return Key.NP_MULTIPLY;
            }
            case 107: {
                return Key.NP_ADD;
            }
            case 109: {
                return Key.NP_SUBTRACT;
            }
            case 110: {
                return Key.NP_DECIMAL;
            }
            case 111: {
                return Key.NP_DIVIDE;
            }
            case 112: {
                return Key.F1;
            }
            case 113: {
                return Key.F2;
            }
            case 114: {
                return Key.F3;
            }
            case 115: {
                return Key.F4;
            }
            case 116: {
                return Key.F5;
            }
            case 117: {
                return Key.F6;
            }
            case 118: {
                return Key.F7;
            }
            case 119: {
                return Key.F8;
            }
            case 120: {
                return Key.F9;
            }
            case 121: {
                return Key.F10;
            }
            case 122: {
                return Key.F11;
            }
            case 123: {
                return Key.F12;
            }
            case 144: {
                return Key.NP_NUM_LOCK;
            }
            case 145: {
                return Key.SCROLL_LOCK;
            }
            case 186: {
                return Key.SEMICOLON;
            }
            case 187: {
                return Key.EQUALS;
            }
            case 188: {
                return Key.COMMA;
            }
            case 189: {
                return Key.MINUS;
            }
            case 190: {
                return Key.PERIOD;
            }
            case 191: {
                return Key.SLASH;
            }
            case 192: {
                return Key.BACKQUOTE;
            }
            case 219: {
                return Key.LEFT_BRACKET;
            }
            case 220: {
                return Key.BACKSLASH;
            }
            case 221: {
                return Key.RIGHT_BRACKET;
            }
            case 222: {
                return Key.QUOTE;
            }
        }
        return Key.UNKNOWN;
    }

    static class EventCloseHandler
    implements HandlerRegistration {
        private final JavaScriptObject target;
        private final String name;
        private final boolean capture;
        private JavaScriptObject listener;

        EventCloseHandler(JavaScriptObject target, String name, EventHandler eventHandler, boolean capture) {
            this.target = target;
            this.name = name;
            this.capture = capture;
            this.addEventListener(this, target, name, eventHandler, capture);
        }

        void setListener(JavaScriptObject listener) {
            this.listener = listener;
        }

        public void removeHandler() {
            this.removeEventListener(this.target, this.name, this.listener, this.capture);
        }

        private native void addEventListener(EventCloseHandler var1, JavaScriptObject var2, String var3, EventHandler var4, boolean var5);

        private native void removeEventListener(JavaScriptObject var1, String var2, JavaScriptObject var3, boolean var4);
    }
}

