/*
 * Decompiled with CFR 0.152.
 */
package playn.html;

import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.dom.client.CanvasElement;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.dom.client.Node;
import com.google.gwt.dom.client.Style;
import com.google.gwt.event.logical.shared.ResizeEvent;
import com.google.gwt.event.logical.shared.ResizeHandler;
import com.google.gwt.user.client.Window;
import com.google.gwt.webgl.client.WebGLContextAttributes;
import com.google.gwt.webgl.client.WebGLRenderingContext;
import java.util.HashMap;
import java.util.Map;
import playn.core.Canvas;
import playn.core.Font;
import playn.core.GL20;
import playn.core.Gradient;
import playn.core.Graphics;
import playn.core.Path;
import playn.core.Platform;
import playn.core.Scale;
import playn.core.TextFormat;
import playn.core.TextLayout;
import playn.core.TextWrap;
import playn.html.HtmlCanvas;
import playn.html.HtmlFontMetrics;
import playn.html.HtmlGL20;
import playn.html.HtmlGradient;
import playn.html.HtmlImage;
import playn.html.HtmlPath;
import playn.html.HtmlPlatform;
import playn.html.HtmlTextLayout;
import pythagoras.f.Dimension;
import pythagoras.f.IDimension;
import pythagoras.f.Point;

public class HtmlGraphics
extends Graphics {
    private final CanvasElement dummyCanvas;
    private final Context2d dummyCtx;
    private final Element measureElement;
    private final Map<Font, HtmlFontMetrics> fontMetrics = new HashMap<Font, HtmlFontMetrics>();
    final Element rootElement;
    private final CanvasElement canvas;
    private final Point mousePoint = new Point();
    private final Dimension screenSize = new Dimension();
    private final float frameBufferPixelRatio;
    private final float mouseScale;
    private static final String HEIGHT_TEXT = "THEQUICKBROWNFOXJUMPEDOVERTHELAZYDOGthequickbrownfoxjumpedoverthelazydog_-+!.,[]0123456789";
    private static final String EMWIDTH_TEXT = "m";
    static float experimentalScale = 1.0f;

    public HtmlGraphics(Platform plat, HtmlPlatform.Config config) {
        super(plat, (GL20)new HtmlGL20(), new Scale(config.scaleFactor));
        this.frameBufferPixelRatio = config.frameBufferPixelRatio;
        this.mouseScale = config.scaleFactor / this.frameBufferPixelRatio;
        Document doc = Document.get();
        this.dummyCanvas = doc.createCanvasElement();
        this.dummyCtx = this.dummyCanvas.getContext2d();
        Element root = doc.getElementById(config.rootId);
        if (root == null) {
            root = doc.createDivElement();
            root.setAttribute("style", "width: 640px; height: 480px");
            doc.getBody().appendChild((Node)root);
        } else {
            root.setInnerHTML("");
        }
        this.rootElement = root;
        this.measureElement = doc.createDivElement();
        this.measureElement.getStyle().setVisibility(Style.Visibility.HIDDEN);
        this.measureElement.getStyle().setPosition(Style.Position.ABSOLUTE);
        this.measureElement.getStyle().setTop(-500.0, Style.Unit.PX);
        this.measureElement.getStyle().setOverflow(Style.Overflow.VISIBLE);
        this.measureElement.getStyle().setWhiteSpace(Style.WhiteSpace.NOWRAP);
        root.appendChild((Node)this.measureElement);
        this.canvas = Document.get().createCanvasElement();
        root.appendChild((Node)this.canvas);
        this.setSize(root.getOffsetWidth(), root.getOffsetHeight());
        WebGLContextAttributes attrs = WebGLContextAttributes.create();
        attrs.setAlpha(config.transparentCanvas);
        attrs.setAntialias(config.antiAliasing);
        WebGLRenderingContext glc = WebGLRenderingContext.getContext((CanvasElement)this.canvas, (WebGLContextAttributes)attrs);
        if (glc == null) {
            throw new RuntimeException("Unable to create GL context");
        }
        ((HtmlGL20)this.gl).init(glc);
        if (config.experimentalFullscreen) {
            Window.addResizeHandler((ResizeHandler)new ResizeHandler(){

                public void onResize(ResizeEvent event) {
                    if (HtmlGraphics.this.fullScreenWidth() == event.getWidth() && HtmlGraphics.this.fullScreenHeight() == event.getHeight()) {
                        float width = HtmlGraphics.this.viewSize.width();
                        float height = HtmlGraphics.this.viewSize.height();
                        experimentalScale = Math.min((float)HtmlGraphics.this.fullScreenWidth() / width, (float)HtmlGraphics.this.fullScreenHeight() / height);
                        int yOfs = (int)(((float)HtmlGraphics.this.fullScreenHeight() - height * experimentalScale) / 3.0f);
                        int xOfs = (int)(((float)HtmlGraphics.this.fullScreenWidth() - width * experimentalScale) / 2.0f);
                        HtmlGraphics.this.rootElement.setAttribute("style", "width:" + experimentalScale * width + "px; height:" + experimentalScale * height + "px; position:absolute; left:" + xOfs + "px; top:" + yOfs);
                        Window.alert((String)"Switching to fullscreen mode.");
                        Document.get().getBody().addClassName("fullscreen");
                    } else {
                        experimentalScale = 1.0f;
                        HtmlGraphics.this.rootElement.removeAttribute("style");
                        Document.get().getBody().removeClassName("fullscreen");
                    }
                }
            });
        }
    }

    public void setSize(int width, int height) {
        this.rootElement.getStyle().setWidth((double)width, Style.Unit.PX);
        this.rootElement.getStyle().setHeight((double)height, Style.Unit.PX);
        Scale fbScale = new Scale(this.frameBufferPixelRatio);
        this.canvas.setWidth(fbScale.scaledCeil((float)width));
        this.canvas.setHeight(fbScale.scaledCeil((float)height));
        this.canvas.getStyle().setWidth((double)width, Style.Unit.PX);
        this.canvas.getStyle().setHeight((double)height, Style.Unit.PX);
        this.viewportChanged(this.canvas.getWidth(), this.canvas.getHeight());
    }

    public void registerFontMetrics(String name, Font font, float lineHeight) {
        HtmlFontMetrics metrics = this.getFontMetrics(font);
        this.fontMetrics.put(font, new HtmlFontMetrics(font, lineHeight, metrics.emwidth));
    }

    public IDimension screenSize() {
        this.screenSize.width = Document.get().getDocumentElement().getClientWidth();
        this.screenSize.height = Document.get().getDocumentElement().getClientHeight();
        return this.screenSize;
    }

    public Path createPath() {
        return new HtmlPath();
    }

    public Gradient createGradient(Gradient.Config config) {
        return new HtmlGradient(this.dummyCtx, config);
    }

    public TextLayout layoutText(String text, TextFormat format) {
        return HtmlTextLayout.layoutText(this, this.dummyCtx, text, format);
    }

    public TextLayout[] layoutText(String text, TextFormat format, TextWrap wrap) {
        return HtmlTextLayout.layoutText(this, this.dummyCtx, text, format, wrap);
    }

    protected Canvas createCanvasImpl(Scale scale, int pixelWidth, int pixelHeight) {
        CanvasElement elem = Document.get().createCanvasElement();
        elem.setWidth(pixelWidth);
        elem.setHeight(pixelHeight);
        return new HtmlCanvas(this, new HtmlImage((Graphics)this, scale, elem, "<canvas>"));
    }

    static String cssColorString(int color) {
        double a = (double)(color >> 24 & 0xFF) / 255.0;
        int r = color >> 16 & 0xFF;
        int g = color >> 8 & 0xFF;
        int b = color >> 0 & 0xFF;
        return "rgba(" + r + "," + g + "," + b + "," + a + ")";
    }

    void updateTexture(int tex, ImageElement img) {
        this.gl.glBindTexture(3553, tex);
        ((HtmlGL20)this.gl).glTexImage2D(3553, 0, 6408, 6408, 5121, img);
    }

    HtmlFontMetrics getFontMetrics(Font font) {
        HtmlFontMetrics metrics = this.fontMetrics.get(font);
        if (metrics == null) {
            this.measureElement.getStyle().setFontSize((double)font.size, Style.Unit.PX);
            this.measureElement.getStyle().setFontWeight(Style.FontWeight.NORMAL);
            this.measureElement.getStyle().setFontStyle(Style.FontStyle.NORMAL);
            this.measureElement.getStyle().setProperty("fontFamily", font.name);
            this.measureElement.setInnerText(HEIGHT_TEXT);
            switch (font.style) {
                case BOLD: {
                    this.measureElement.getStyle().setFontWeight(Style.FontWeight.BOLD);
                    break;
                }
                case ITALIC: {
                    this.measureElement.getStyle().setFontStyle(Style.FontStyle.ITALIC);
                    break;
                }
                case BOLD_ITALIC: {
                    this.measureElement.getStyle().setFontWeight(Style.FontWeight.BOLD);
                    this.measureElement.getStyle().setFontStyle(Style.FontStyle.ITALIC);
                    break;
                }
            }
            float height = this.measureElement.getOffsetHeight();
            this.measureElement.setInnerText(EMWIDTH_TEXT);
            float emwidth = this.measureElement.getOffsetWidth();
            metrics = new HtmlFontMetrics(font, height, emwidth);
            this.fontMetrics.put(font, metrics);
        }
        return metrics;
    }

    Point transformMouse(float x, float y) {
        return this.mousePoint.set(x / this.mouseScale, y / this.mouseScale);
    }

    private native int fullScreenWidth();

    private native int fullScreenHeight();
}

