/*
 * Decompiled with CFR 0.152.
 */
package playn.html;

import com.allen_sauer.gwt.voices.client.Sound;
import com.allen_sauer.gwt.voices.client.SoundController;
import com.allen_sauer.gwt.voices.client.SoundType;
import com.allen_sauer.gwt.voices.client.ui.FlashMovie;
import com.google.gwt.dom.client.Element;
import playn.core.Audio;
import playn.html.HtmlPlatform;
import playn.html.HtmlSound;

public class HtmlAudio
extends Audio {
    private final HtmlPlatform plat;
    private Element audioContext;
    private SoundController soundController = new SoundController();

    public HtmlAudio(HtmlPlatform plat) {
        this.plat = plat;
        SoundType[] types = this.soundController.getPreferredSoundTypes();
        plat.log().debug("Preferred sound type(s): " + types);
        this.audioContext = HtmlAudio.maybeCreateAudioContext();
    }

    public HtmlSound createSound(String url) {
        Sound sound = this.soundController.createSound("audio/mpeg", url);
        return new HtmlSound(this.plat.exec(), sound);
    }

    private static native Element maybeCreateAudioContext();

    boolean isFlash9AudioPluginMissing() {
        SoundType[] types;
        if (this.audioContext != null) {
            return false;
        }
        for (SoundType type : types = this.soundController.getPreferredSoundTypes()) {
            if (type != SoundType.FLASH) continue;
            return this.isFlash9AudioPluginMissingImpl();
        }
        return false;
    }

    boolean isFlash9AudioPluginMissingImpl() {
        boolean supported = FlashMovie.isExternalInterfaceSupported();
        int version = FlashMovie.getMajorVersion();
        this.plat.log().debug("FlashMovie.isExternalInterfaceSupported: " + supported + ", getMajorVersion: " + version);
        return supported && version < 9;
    }
}

