/*
 * Decompiled with CFR 0.152.
 */
package playn.html;

import com.google.gwt.canvas.dom.client.Context2d;
import java.util.ArrayList;
import java.util.List;
import playn.core.Font;
import playn.core.TextFormat;
import playn.core.TextLayout;
import playn.core.TextWrap;
import playn.html.HtmlFont;
import playn.html.HtmlFontMetrics;
import playn.html.HtmlGraphics;
import pythagoras.f.IRectangle;
import pythagoras.f.Rectangle;

class HtmlTextLayout
extends TextLayout {
    private final HtmlFontMetrics metrics;

    public static TextLayout layoutText(HtmlGraphics gfx, Context2d ctx, String text, TextFormat format) {
        HtmlFontMetrics metrics = gfx.getFontMetrics(HtmlTextLayout.getFont(format));
        HtmlTextLayout.configContext(ctx, format);
        float width = (float)ctx.measureText(text).getWidth();
        return new HtmlTextLayout(text, format, metrics, width);
    }

    public static TextLayout[] layoutText(HtmlGraphics gfx, Context2d ctx, String text, TextFormat format, TextWrap wrap) {
        HtmlFontMetrics metrics = gfx.getFontMetrics(HtmlTextLayout.getFont(format));
        HtmlTextLayout.configContext(ctx, format);
        ArrayList<TextLayout> layouts = new ArrayList<TextLayout>();
        text = HtmlTextLayout.normalizeEOL((String)text);
        for (String line : text.split("\\n")) {
            String[] words = line.split("\\s");
            int idx = 0;
            while (idx < words.length) {
                idx = HtmlTextLayout.measureLine(ctx, format, wrap, metrics, words, idx, layouts);
            }
        }
        return layouts.toArray(new TextLayout[layouts.size()]);
    }

    HtmlTextLayout(String text, TextFormat format, HtmlFontMetrics metrics, float width) {
        super(text, format, (IRectangle)new Rectangle(0.0f, 0.0f, metrics.adjustWidth(width), metrics.height), metrics.ascent() + metrics.descent());
        this.metrics = metrics;
    }

    public float ascent() {
        return this.metrics.ascent();
    }

    public float descent() {
        return this.metrics.descent();
    }

    public float leading() {
        return this.metrics.leading();
    }

    void stroke(Context2d ctx, float x, float y) {
        HtmlTextLayout.configContext(ctx, this.format);
        ctx.strokeText(this.text, (double)x, (double)y);
    }

    void fill(Context2d ctx, float x, float y) {
        HtmlTextLayout.configContext(ctx, this.format);
        ctx.fillText(this.text, (double)x, (double)y);
    }

    static void configContext(Context2d ctx, TextFormat format) {
        Font font = HtmlTextLayout.getFont(format);
        ctx.setFont(HtmlFont.toCSS(font));
        ctx.setTextBaseline(Context2d.TextBaseline.TOP);
    }

    static Font getFont(TextFormat format) {
        return format.font == null ? HtmlFont.DEFAULT : format.font;
    }

    static int measureLine(Context2d ctx, TextFormat format, TextWrap wrap, HtmlFontMetrics metrics, String[] words, int idx, List<TextLayout> layouts) {
        String nline;
        String line = words[idx++];
        int startIdx = idx;
        while (idx < words.length && !((float)(nline = line + " " + words[idx]).length() * metrics.emwidth > wrap.width)) {
            line = nline;
            ++idx;
        }
        double lineWidth = ctx.measureText(line).getWidth();
        if (lineWidth < (double)wrap.width) {
            String nline2;
            double nlineWidth;
            while (idx < words.length && !((nlineWidth = ctx.measureText(nline2 = line + " " + words[idx]).getWidth()) > (double)wrap.width)) {
                line = nline2;
                lineWidth = nlineWidth;
                ++idx;
            }
        }
        while (lineWidth > (double)wrap.width && idx > startIdx + 1) {
            line = line.substring(0, line.length() - words[--idx].length() - 1);
            lineWidth = ctx.measureText(line).getWidth();
        }
        if (lineWidth > (double)wrap.width) {
            StringBuilder remainder = new StringBuilder();
            while (lineWidth > (double)wrap.width && line.length() > 1) {
                int lastIdx = line.length() - 1;
                remainder.insert(0, line.charAt(lastIdx));
                line = line.substring(0, lastIdx);
                lineWidth = ctx.measureText(line).getWidth();
            }
            words[--idx] = remainder.toString();
        }
        layouts.add(new HtmlTextLayout(line, format, metrics, (float)lineWidth));
        return idx;
    }
}

