/*
 * Decompiled with CFR 0.152.
 */
package playn.html;

import com.allen_sauer.gwt.voices.client.Sound;
import com.allen_sauer.gwt.voices.client.handler.PlaybackCompleteEvent;
import com.allen_sauer.gwt.voices.client.handler.SoundHandler;
import com.allen_sauer.gwt.voices.client.handler.SoundLoadStateChangeEvent;
import playn.core.Exec;
import playn.core.SoundImpl;

public class HtmlSound
extends SoundImpl<Sound> {
    public HtmlSound(Exec exec, final Sound sound) {
        super(exec);
        sound.addEventHandler(new SoundHandler(){

            public void onSoundLoadStateChange(SoundLoadStateChangeEvent event) {
                Sound.LoadState loadState = event.getLoadState();
                switch (loadState) {
                    case LOAD_STATE_UNINITIALIZED: 
                    case LOAD_STATE_SUPPORTED_NOT_READY: {
                        break;
                    }
                    case LOAD_STATE_SUPPORTED_AND_READY: 
                    case LOAD_STATE_SUPPORT_NOT_KNOWN: 
                    case LOAD_STATE_SUPPORTED_MAYBE_READY: {
                        HtmlSound.this.succeed(sound);
                        break;
                    }
                    case LOAD_STATE_NOT_SUPPORTED: {
                        HtmlSound.this.fail(new Exception(loadState.name()));
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unrecognized sound load state " + loadState.name());
                    }
                }
            }

            public void onPlaybackComplete(PlaybackCompleteEvent event) {
                HtmlSound.this.playing = false;
            }
        });
    }

    protected boolean playImpl() {
        return ((Sound)this.impl).play();
    }

    protected void stopImpl() {
        ((Sound)this.impl).stop();
    }

    protected void setLoopingImpl(boolean looping) {
        ((Sound)this.impl).setLooping(looping);
    }

    protected void setVolumeImpl(float volume) {
        ((Sound)this.impl).setVolume((int)(volume * 100.0f));
    }

    protected void releaseImpl() {
    }
}

