/*
 * Decompiled with CFR 0.152.
 */
package playn.html;

import com.google.gwt.storage.client.StorageMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import playn.core.BatchImpl;
import playn.core.Storage;
import playn.html.HtmlPlatform;

class HtmlStorage
implements Storage {
    private final HtmlPlatform platform;
    private final Map<String, String> storageMap;
    private boolean isPersisted;

    public HtmlStorage(HtmlPlatform platform) {
        this.platform = platform;
        com.google.gwt.storage.client.Storage storage = com.google.gwt.storage.client.Storage.getLocalStorageIfSupported();
        if (storage != null) {
            this.storageMap = new StorageMap(storage);
            this.isPersisted = true;
        } else {
            this.storageMap = new HashMap<String, String>();
            this.isPersisted = false;
        }
    }

    public void setItem(String key, String value) throws RuntimeException {
        if (key == null || key == "") {
            return;
        }
        this.storageMap.put(key, value);
    }

    public void removeItem(String key) {
        try {
            this.storageMap.remove(key);
        }
        catch (RuntimeException e) {
            this.platform.reportError("Failed to remove() Storage item [key=" + key + "]", e);
        }
    }

    public String getItem(String key) {
        try {
            return this.storageMap.get(key);
        }
        catch (RuntimeException e) {
            this.platform.reportError("Failed to get() Storage item [key=" + key + "]", e);
            return null;
        }
    }

    public Storage.Batch startBatch() {
        return new BatchImpl((Storage)this);
    }

    public Iterable<String> keys() {
        return new ArrayList<String>(this.storageMap.keySet());
    }

    public boolean isPersisted() {
        return this.isPersisted;
    }
}

