/*
 * Decompiled with CFR 0.152.
 */
package playn.html;

import com.google.gwt.canvas.dom.client.Context2d;
import com.google.gwt.canvas.dom.client.FillStrokeStyle;
import playn.core.Canvas;
import playn.core.Gradient;
import playn.core.Graphics;
import playn.core.Image;
import playn.core.Path;
import playn.core.Pattern;
import playn.core.TextLayout;
import playn.html.HtmlGradient;
import playn.html.HtmlGraphics;
import playn.html.HtmlImage;
import playn.html.HtmlPath;
import playn.html.HtmlPattern;
import playn.html.HtmlTextLayout;

public class HtmlCanvas
extends Canvas {
    private final Context2d ctx;

    public HtmlCanvas(Graphics gfx, HtmlImage image) {
        super(gfx, (Image)image);
        this.ctx = image.canvas.getContext2d();
        float scale = image.scale().factor;
        this.ctx.scale((double)scale, (double)scale);
    }

    public Canvas clear() {
        return this.clearRect(0.0f, 0.0f, this.width, this.height);
    }

    public Canvas clearRect(float x, float y, float width, float height) {
        this.ctx.clearRect((double)x, (double)y, (double)width, (double)height);
        this.isDirty = true;
        return this;
    }

    public Canvas clip(Path path) {
        assert (path instanceof HtmlPath);
        ((HtmlPath)path).replay(this.ctx);
        this.ctx.clip();
        return this;
    }

    public Canvas clipRect(float x, float y, float width, float height) {
        this.ctx.beginPath();
        this.ctx.rect((double)x, (double)y, (double)width, (double)height);
        this.ctx.clip();
        return this;
    }

    public Path createPath() {
        return new HtmlPath();
    }

    public Gradient createGradient(Gradient.Config config) {
        return new HtmlGradient(this.ctx, config);
    }

    public Canvas drawLine(float x0, float y0, float x1, float y1) {
        this.ctx.beginPath();
        this.ctx.moveTo((double)x0, (double)y0);
        this.ctx.lineTo((double)x1, (double)y1);
        this.ctx.stroke();
        this.isDirty = true;
        return this;
    }

    public Canvas drawPoint(float x, float y) {
        this.ctx.beginPath();
        this.ctx.moveTo((double)x, (double)y);
        this.ctx.lineTo((double)x, (double)y);
        this.ctx.stroke();
        this.isDirty = true;
        return this;
    }

    public Canvas drawText(String text, float x, float y) {
        this.ctx.fillText(text, (double)x, (double)y);
        this.isDirty = true;
        return this;
    }

    public Canvas fillCircle(float x, float y, float radius) {
        this.ctx.beginPath();
        this.ctx.arc((double)x, (double)y, (double)radius, 0.0, Math.PI * 2);
        this.ctx.fill();
        this.isDirty = true;
        return this;
    }

    public Canvas fillPath(Path path) {
        assert (path instanceof HtmlPath);
        ((HtmlPath)path).replay(this.ctx);
        this.ctx.fill();
        this.isDirty = true;
        return this;
    }

    public Canvas fillRect(float x, float y, float w, float h) {
        this.ctx.fillRect((double)x, (double)y, (double)w, (double)h);
        this.isDirty = true;
        return this;
    }

    public Canvas fillRoundRect(float x, float y, float w, float h, float radius) {
        this.addRoundRectPath(x, y, w, h, radius);
        this.ctx.fill();
        this.isDirty = true;
        return this;
    }

    public Canvas fillText(TextLayout layout, float x, float y) {
        ((HtmlTextLayout)layout).fill(this.ctx, x, y);
        this.isDirty = true;
        return this;
    }

    public Canvas restore() {
        this.ctx.restore();
        return this;
    }

    public Canvas rotate(float radians) {
        this.ctx.rotate((double)radians);
        return this;
    }

    public Canvas save() {
        this.ctx.save();
        return this;
    }

    public Canvas scale(float x, float y) {
        this.ctx.scale((double)x, (double)y);
        return this;
    }

    public Canvas setAlpha(float alpha) {
        this.ctx.setGlobalAlpha((double)alpha);
        return this;
    }

    public Canvas setCompositeOperation(Canvas.Composite composite) {
        this.ctx.setGlobalCompositeOperation(this.convertComposite(composite));
        return this;
    }

    public Canvas setFillColor(int color) {
        this.ctx.setFillStyle(HtmlGraphics.cssColorString(color));
        return this;
    }

    public Canvas setFillGradient(Gradient gradient) {
        assert (gradient instanceof HtmlGradient);
        this.ctx.setFillStyle((FillStrokeStyle)((HtmlGradient)gradient).gradient);
        return this;
    }

    public Canvas setFillPattern(Pattern pattern) {
        assert (pattern instanceof HtmlPattern);
        this.ctx.setFillStyle((FillStrokeStyle)((HtmlPattern)pattern).pattern(this.ctx));
        return this;
    }

    public Canvas setLineCap(Canvas.LineCap cap) {
        this.ctx.setLineCap(this.convertLineCap(cap));
        return this;
    }

    public Canvas setLineJoin(Canvas.LineJoin join) {
        this.ctx.setLineJoin(this.convertLineJoin(join));
        return this;
    }

    public Canvas setMiterLimit(float miter) {
        this.ctx.setMiterLimit((double)miter);
        return this;
    }

    public Canvas setStrokeColor(int color) {
        this.ctx.setStrokeStyle(HtmlGraphics.cssColorString(color));
        return this;
    }

    public Canvas setStrokeWidth(float w) {
        this.ctx.setLineWidth((double)w);
        return this;
    }

    public Image snapshot() {
        return this.image;
    }

    public Canvas strokeCircle(float x, float y, float radius) {
        this.ctx.beginPath();
        this.ctx.arc((double)x, (double)y, (double)radius, 0.0, Math.PI * 2);
        this.ctx.stroke();
        this.isDirty = true;
        return this;
    }

    public Canvas strokePath(Path path) {
        assert (path instanceof HtmlPath);
        ((HtmlPath)path).replay(this.ctx);
        this.ctx.stroke();
        this.isDirty = true;
        return this;
    }

    public Canvas strokeRect(float x, float y, float w, float h) {
        this.ctx.strokeRect((double)x, (double)y, (double)w, (double)h);
        this.isDirty = true;
        return this;
    }

    public Canvas strokeRoundRect(float x, float y, float w, float h, float radius) {
        this.addRoundRectPath(x, y, w, h, radius);
        this.ctx.stroke();
        this.isDirty = true;
        return this;
    }

    public Canvas strokeText(TextLayout layout, float x, float y) {
        ((HtmlTextLayout)layout).stroke(this.ctx, x, y);
        this.isDirty = true;
        return this;
    }

    public Canvas transform(float m11, float m12, float m21, float m22, float dx, float dy) {
        this.ctx.transform((double)m11, (double)m12, (double)m21, (double)m22, (double)dx, (double)dy);
        return this;
    }

    public Canvas translate(float x, float y) {
        this.ctx.translate((double)x, (double)y);
        return this;
    }

    protected Context2d gc() {
        return this.ctx;
    }

    private void addRoundRectPath(float x, float y, float width, float height, float radius) {
        float midx = x + width / 2.0f;
        float midy = y + height / 2.0f;
        float maxx = x + width;
        float maxy = y + height;
        this.ctx.beginPath();
        this.ctx.moveTo((double)x, (double)midy);
        this.ctx.arcTo((double)x, (double)y, (double)midx, (double)y, (double)radius);
        this.ctx.arcTo((double)maxx, (double)y, (double)maxx, (double)midy, (double)radius);
        this.ctx.arcTo((double)maxx, (double)maxy, (double)midx, (double)maxy, (double)radius);
        this.ctx.arcTo((double)x, (double)maxy, (double)x, (double)midy, (double)radius);
        this.ctx.closePath();
    }

    private String convertComposite(Canvas.Composite composite) {
        switch (composite) {
            case SRC: {
                return "copy";
            }
            case DST_ATOP: {
                return "destination-atop";
            }
            case SRC_OVER: {
                return "source-over";
            }
            case DST_OVER: {
                return "destination-over";
            }
            case SRC_IN: {
                return "source-in";
            }
            case DST_IN: {
                return "destination-in";
            }
            case SRC_OUT: {
                return "source-out";
            }
            case DST_OUT: {
                return "destination-out";
            }
            case SRC_ATOP: {
                return "source-atop";
            }
            case XOR: {
                return "xor";
            }
        }
        return "copy";
    }

    private Context2d.LineCap convertLineCap(Canvas.LineCap cap) {
        switch (cap) {
            case BUTT: {
                return Context2d.LineCap.BUTT;
            }
            case ROUND: {
                return Context2d.LineCap.ROUND;
            }
            case SQUARE: {
                return Context2d.LineCap.SQUARE;
            }
        }
        return Context2d.LineCap.SQUARE;
    }

    private Context2d.LineJoin convertLineJoin(Canvas.LineJoin join) {
        switch (join) {
            case BEVEL: {
                return Context2d.LineJoin.BEVEL;
            }
            case MITER: {
                return Context2d.LineJoin.MITER;
            }
            case ROUND: {
                return Context2d.LineJoin.ROUND;
            }
        }
        return Context2d.LineJoin.ROUND;
    }
}

