/*
 * Decompiled with CFR 0.152.
 */
package playn.html;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.core.client.JsArrayInteger;
import com.google.gwt.dom.client.CanvasElement;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.typedarrays.shared.ArrayBuffer;
import com.google.gwt.typedarrays.shared.ArrayBufferView;
import com.google.gwt.typedarrays.shared.Float32Array;
import com.google.gwt.typedarrays.shared.Int32Array;
import com.google.gwt.typedarrays.shared.TypedArrays;
import com.google.gwt.webgl.client.WebGLBuffer;
import com.google.gwt.webgl.client.WebGLFramebuffer;
import com.google.gwt.webgl.client.WebGLObject;
import com.google.gwt.webgl.client.WebGLProgram;
import com.google.gwt.webgl.client.WebGLRenderbuffer;
import com.google.gwt.webgl.client.WebGLRenderingContext;
import com.google.gwt.webgl.client.WebGLShader;
import com.google.gwt.webgl.client.WebGLTexture;
import com.google.gwt.webgl.client.WebGLUniformLocation;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.nio.ShortBuffer;
import playn.core.GL20;
import playn.html.HasArrayBufferView;
import playn.html.HtmlUrlParameters;

public final class HtmlGL20
extends GL20 {
    static final int VERTEX_ATTRIB_ARRAY_COUNT = 5;
    private int previouslyEnabledArrays = 0;
    private int enabledArrays = 0;
    private int useNioBuffer = 0;
    private WebGLRenderingContext glc;
    private VertexAttribArrayState[] vertexAttribArrayState = new VertexAttribArrayState[5];
    private JsArray<WebGLObject> webGLObjects = (JsArray)JsArray.createArray();
    private JsArrayInteger webGLObjectTypes = (JsArrayInteger)JsArrayInteger.createArray();
    private WebGLBuffer elementBuffer;
    private WebGLBuffer boundArrayBuffer;
    private WebGLBuffer requestedArrayBuffer;
    private WebGLBuffer boundElementArrayBuffer;
    private WebGLBuffer requestedElementArrayBuffer;

    public HtmlGL20() {
        super(new GL20.Buffers(){

            public ByteBuffer createByteBuffer(int size) {
                ByteBuffer buffer = ByteBuffer.allocateDirect(size);
                buffer.order(ByteOrder.nativeOrder());
                return buffer;
            }
        }, HtmlUrlParameters.checkGLErrors);
    }

    void init(WebGLRenderingContext glc) {
        glc.pixelStorei(37441, 1);
        this.glc = glc;
        this.webGLObjects.push(null);
        this.webGLObjectTypes.push(WebGLObjectType.NULL.ordinal());
        this.elementBuffer = glc.createBuffer();
        for (int ii = 0; ii < 5; ++ii) {
            VertexAttribArrayState data = new VertexAttribArrayState();
            data.webGlBuffer = glc.createBuffer();
            this.vertexAttribArrayState[ii] = data;
        }
    }

    protected boolean isObjectType(int index, WebGLObjectType type) {
        return this.webGLObjectTypes.get(index) == type.ordinal();
    }

    private WebGLBuffer getBuffer(int index) {
        return (WebGLBuffer)this.webGLObjects.get(index);
    }

    private WebGLFramebuffer getFramebuffer(int index) {
        return (WebGLFramebuffer)this.webGLObjects.get(index);
    }

    private WebGLProgram getProgram(int index) {
        return (WebGLProgram)this.webGLObjects.get(index);
    }

    private WebGLRenderbuffer getRenderbuffer(int index) {
        return (WebGLRenderbuffer)this.webGLObjects.get(index);
    }

    private WebGLShader getShader(int index) {
        return (WebGLShader)this.webGLObjects.get(index);
    }

    protected WebGLUniformLocation getUniformLocation(int index) {
        return (WebGLUniformLocation)this.webGLObjects.get(index);
    }

    protected WebGLTexture getTexture(int index) {
        return (WebGLTexture)this.webGLObjects.get(index);
    }

    protected void deleteObject(int index, WebGLObjectType type) {
        WebGLObject object = (WebGLObject)this.webGLObjects.get(index);
        this.webGLObjects.set(index, null);
        this.webGLObjectTypes.set(index, WebGLObjectType.NULL.ordinal());
        switch (type) {
            case BUFFER: {
                this.glc.deleteBuffer((WebGLBuffer)object);
                break;
            }
            case FRAME_BUFFER: {
                this.glc.deleteFramebuffer((WebGLFramebuffer)object);
                break;
            }
            case PROGRAM: {
                this.glc.deleteProgram((WebGLProgram)object);
                break;
            }
            case RENDER_BUFFER: {
                this.glc.deleteRenderbuffer((WebGLRenderbuffer)object);
                break;
            }
            case SHADER: {
                this.glc.deleteShader((WebGLShader)object);
                break;
            }
            case TEXTURE: {
                this.glc.deleteTexture((WebGLTexture)object);
                break;
            }
        }
    }

    protected void deleteObjects(int count, IntBuffer indices, WebGLObjectType type) {
        for (int i = 0; i < count; ++i) {
            int index = indices.get(indices.position() + i);
            this.deleteObject(index, type);
        }
    }

    protected void deleteObjects(int count, int[] indices, int offset, WebGLObjectType type) {
        for (int i = 0; i < count; ++i) {
            this.deleteObject(indices[offset + i], type);
        }
    }

    protected int createObject(WebGLObject object, WebGLObjectType type) {
        this.webGLObjects.push((JavaScriptObject)object);
        this.webGLObjectTypes.push(type.ordinal());
        return this.webGLObjects.length() - 1;
    }

    protected WebGLObject genObject(WebGLObjectType type) {
        switch (type) {
            case BUFFER: {
                return this.glc.createBuffer();
            }
            case FRAME_BUFFER: {
                return this.glc.createFramebuffer();
            }
            case PROGRAM: {
                return this.glc.createProgram();
            }
            case RENDER_BUFFER: {
                return this.glc.createRenderbuffer();
            }
            case TEXTURE: {
                return this.glc.createTexture();
            }
        }
        throw new RuntimeException("genObject(s) not supported for type " + (Object)((Object)type));
    }

    protected void genObjects(int count, int[] names, int offset, WebGLObjectType type) {
        for (int i = 0; i < count; ++i) {
            WebGLObject object = this.genObject(type);
            names[i + offset] = this.createObject(object, type);
        }
    }

    protected void genObjects(int count, IntBuffer names, WebGLObjectType type) {
        for (int i = 0; i < count; ++i) {
            WebGLObject object = this.genObject(type);
            names.put(i + names.position(), this.createObject(object, type));
        }
    }

    protected void prepareDraw() {
        VertexAttribArrayState previousNio = null;
        int previousElementSize = 0;
        if (this.useNioBuffer == 0 && this.enabledArrays == this.previouslyEnabledArrays) {
            return;
        }
        for (int i = 0; i < 5; ++i) {
            int mask = 1 << i;
            int enabled = this.enabledArrays & mask;
            if (enabled != (this.previouslyEnabledArrays & mask)) {
                if (enabled != 0) {
                    this.glc.enableVertexAttribArray(i);
                } else {
                    this.glc.disableVertexAttribArray(i);
                }
            }
            if (enabled == 0 || (this.useNioBuffer & mask) == 0) continue;
            VertexAttribArrayState data = this.vertexAttribArrayState[i];
            if (previousNio != null && previousNio.nioBuffer == data.nioBuffer && previousNio.nioBufferLimit >= data.nioBufferLimit) {
                if (this.boundArrayBuffer != previousNio.webGlBuffer) {
                    this.glc.bindBuffer(34962, previousNio.webGlBuffer);
                    this.boundArrayBuffer = data.webGlBuffer;
                }
                this.glc.vertexAttribPointer(i, data.size, data.type, data.normalize, data.stride, data.nioBufferPosition * previousElementSize);
                continue;
            }
            if (this.boundArrayBuffer != data.webGlBuffer) {
                this.glc.bindBuffer(34962, data.webGlBuffer);
                this.boundArrayBuffer = data.webGlBuffer;
            }
            int elementSize = HtmlGL20.getElementSize(data.nioBuffer);
            int savePosition = data.nioBuffer.position();
            if (data.nioBufferPosition * elementSize < data.stride) {
                data.nioBuffer.position(0);
                this.glc.bufferData(34962, this.getTypedArray(data.nioBuffer, data.type, data.nioBufferLimit * elementSize), 35040);
                this.glc.vertexAttribPointer(i, data.size, data.type, data.normalize, data.stride, data.nioBufferPosition * elementSize);
                previousNio = data;
                previousElementSize = elementSize;
            } else {
                data.nioBuffer.position(data.nioBufferPosition);
                this.glc.bufferData(34962, this.getTypedArray(data.nioBuffer, data.type, (data.nioBufferLimit - data.nioBufferPosition) * elementSize), 35040);
                this.glc.vertexAttribPointer(i, data.size, data.type, data.normalize, data.stride, 0);
            }
            data.nioBuffer.position(savePosition);
        }
        this.previouslyEnabledArrays = this.enabledArrays;
    }

    private ArrayBufferView getTypedArray(Buffer buffer, int type, int byteSize) {
        if (!(buffer instanceof HasArrayBufferView)) {
            throw new RuntimeException("Native buffer required " + buffer);
        }
        HasArrayBufferView arrayHolder = (HasArrayBufferView)((Object)buffer);
        int bufferElementSize = arrayHolder.getElementSize();
        ArrayBufferView webGLArray = arrayHolder.getTypedArray();
        if (byteSize == -1) {
            byteSize = buffer.remaining() * bufferElementSize;
        }
        if (byteSize == buffer.capacity() * bufferElementSize && type == arrayHolder.getElementType()) {
            return webGLArray;
        }
        int byteOffset = webGLArray.byteOffset() + buffer.position() * bufferElementSize;
        switch (type) {
            case 5126: {
                return TypedArrays.createFloat32Array((ArrayBuffer)webGLArray.buffer(), (int)byteOffset, (int)(byteSize / 4));
            }
            case 5121: {
                return TypedArrays.createUint8Array((ArrayBuffer)webGLArray.buffer(), (int)byteOffset, (int)byteSize);
            }
            case 5123: {
                return TypedArrays.createUint16Array((ArrayBuffer)webGLArray.buffer(), (int)byteOffset, (int)(byteSize / 2));
            }
            case 5124: {
                return TypedArrays.createInt32Array((ArrayBuffer)webGLArray.buffer(), (int)byteOffset, (int)(byteSize / 4));
            }
            case 5122: {
                return TypedArrays.createInt16Array((ArrayBuffer)webGLArray.buffer(), (int)byteOffset, (int)(byteSize / 2));
            }
            case 5120: {
                return TypedArrays.createInt8Array((ArrayBuffer)webGLArray.buffer(), (int)byteOffset, (int)byteSize);
            }
        }
        throw new IllegalArgumentException("Type: " + type);
    }

    private static int getElementSize(Buffer buffer) {
        if (buffer instanceof FloatBuffer || buffer instanceof IntBuffer) {
            return 4;
        }
        if (buffer instanceof ShortBuffer) {
            return 2;
        }
        if (buffer instanceof ByteBuffer) {
            return 1;
        }
        throw new RuntimeException("Unrecognized buffer type: " + buffer.getClass());
    }

    public void glTexImage2D(int target, int level, int internalformat, int format, int type, ImageElement image) {
        this.glc.texImage2D(target, level, internalformat, format, type, image);
        this.checkError("texImage2D");
    }

    public void glTexImage2D(int target, int level, int internalformat, int format, int type, CanvasElement image) {
        this.glc.texImage2D(target, level, internalformat, format, type, image);
        this.checkError("texImage2D");
    }

    public void glDepthFunc(int func) {
        this.glc.depthFunc(func);
    }

    public void glDepthMask(boolean b) {
        this.glc.depthMask(b);
    }

    public void glDrawElements(int mode, int count, int type, Buffer indices) {
        this.prepareDraw();
        if (this.boundElementArrayBuffer != this.elementBuffer) {
            this.glc.bindBuffer(34963, this.elementBuffer);
            this.boundElementArrayBuffer = this.elementBuffer;
        }
        this.glc.bufferData(34963, this.getTypedArray(indices, type, count * this.getTypeSize(type)), 35040);
        this.glc.drawElements(mode, count, type, 0);
    }

    private int getTypeSize(int type) {
        switch (type) {
            case 5124: 
            case 5126: {
                return 4;
            }
            case 5122: 
            case 5123: {
                return 2;
            }
            case 5120: 
            case 5121: {
                return 1;
            }
        }
        throw new IllegalArgumentException();
    }

    public void glFinish() {
        this.glc.finish();
    }

    public String glGetString(int id) {
        return this.glc.getParameterString(id);
    }

    public void glPixelStorei(int i, int j) {
        this.glc.pixelStorei(i, j);
    }

    public void glBindTexture(int target, int textureId) {
        this.glc.bindTexture(target, this.getTexture(textureId));
    }

    public final void glClear(int mask) {
        this.glc.clear(mask);
    }

    public final void glClearColor(float f, float g, float h, float i) {
        this.glc.clearColor(f, g, h, i);
    }

    public void glDrawArrays(int mode, int first, int count) {
        this.prepareDraw();
        this.glc.drawArrays(mode, first, count);
    }

    public final int glGetError() {
        return this.glc.getError();
    }

    public final void glScissor(int i, int j, int width, int height) {
        this.glc.scissor(i, j, width, height);
    }

    public void glTexParameteri(int glTexture2d, int glTextureMinFilter, int glFilterMin) {
        this.glc.texParameteri(glTexture2d, glTextureMinFilter, glFilterMin);
    }

    public void glTexParameterf(int target, int pname, float param) {
        this.glc.texParameterf(target, pname, param);
    }

    public final void glCullFace(int c) {
        this.glc.cullFace(c);
    }

    public void glViewport(int x, int y, int w, int h) {
        this.glc.viewport(x, y, w, h);
    }

    public void glVertexAttribPointer(int arrayId, int size, int type, boolean normalize, int byteStride, Buffer nioBuffer) {
        VertexAttribArrayState data = this.vertexAttribArrayState[arrayId];
        this.useNioBuffer |= 1 << arrayId;
        data.nioBuffer = nioBuffer;
        data.nioBufferPosition = nioBuffer.position();
        data.nioBufferLimit = nioBuffer.limit();
        data.size = size;
        data.type = type;
        data.normalize = normalize;
        data.stride = byteStride == 0 ? size * this.getTypeSize(type) : byteStride;
    }

    public void glClearDepthf(float depth) {
        this.glc.clearDepth(depth);
    }

    public void glClearStencil(int s) {
        this.glc.clearStencil(s);
    }

    public void glColorMask(boolean red, boolean green, boolean blue, boolean alpha) {
        this.glc.colorMask(red, green, blue, alpha);
    }

    public void glCompressedTexImage2D(int target, int level, int internalformat, int width, int height, int border, int imageSize, Buffer data) {
        throw new RuntimeException("NYI glCompressedTexImage2D");
    }

    public void glCompressedTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int imageSize, Buffer data) {
        throw new RuntimeException("NYI glCompressedTexSubImage2D");
    }

    public void glCopyTexImage2D(int target, int level, int internalformat, int x, int y, int width, int height, int border) {
        this.glc.copyTexImage2D(target, level, internalformat, x, y, width, height, border);
    }

    public void glCopyTexSubImage2D(int target, int level, int xoffset, int yoffset, int x, int y, int width, int height) {
        this.glc.copyTexSubImage2D(target, level, xoffset, yoffset, x, y, width, height);
    }

    public void glDepthRangef(float zNear, float zFar) {
        this.glc.depthRange(zNear, zFar);
    }

    public void glFlush() {
        this.glc.flush();
    }

    public void glFrontFace(int mode) {
        this.glc.frontFace(mode);
    }

    public int glGetInteger(int pname) {
        return this.glc.getParameteri(pname);
    }

    public void glGetIntegerv(int pname, IntBuffer params) {
        Int32Array result = (Int32Array)this.glc.getParameterv(pname);
        int pos = params.position();
        int len = result.length();
        for (int i = 0; i < len; ++i) {
            params.put(pos + i, result.get(i));
        }
    }

    public void glHint(int target, int mode) {
        this.glc.hint(target, mode);
    }

    public void glLineWidth(float width) {
        this.glc.lineWidth(width);
    }

    public void glPolygonOffset(float factor, float units) {
        this.glc.polygonOffset(factor, units);
    }

    public void glReadPixels(int x, int y, int width, int height, int format, int type, Buffer pixels) {
        this.glc.readPixels(x, y, width, height, format, type, this.getTypedArray(pixels, type, -1));
    }

    public void glStencilFunc(int func, int ref, int mask) {
        this.glc.stencilFunc(func, ref, mask);
    }

    public void glStencilMask(int mask) {
        this.glc.stencilMask(mask);
    }

    public void glStencilOp(int fail, int zfail, int zpass) {
        this.glc.stencilOp(fail, zfail, zpass);
    }

    public void glTexImage2D(int target, int level, int internalformat, int width, int height, int border, int format, int type, Buffer pixels) {
        ArrayBufferView buffer = pixels == null ? null : this.getTypedArray(pixels, type, -1);
        this.glc.texImage2D(target, level, internalformat, width, height, border, format, type, buffer);
    }

    public void glTexSubImage2D(int target, int level, int xoffset, int yoffset, int width, int height, int format, int type, Buffer pixels) {
        this.glc.texSubImage2D(target, level, xoffset, yoffset, width, height, format, type, this.getTypedArray(pixels, type, -1));
    }

    public void glAttachShader(int program, int shader) {
        this.glc.attachShader((WebGLProgram)this.webGLObjects.get(program), (WebGLShader)this.webGLObjects.get(shader));
    }

    public void glBindAttribLocation(int program, int index, String name) {
        this.glc.bindAttribLocation((WebGLProgram)this.webGLObjects.get(program), index, name);
    }

    public void glBindBuffer(int target, int buffer) {
        WebGLBuffer webGlBuf = this.getBuffer(buffer);
        if (target == 34962) {
            this.requestedArrayBuffer = webGlBuf;
        } else if (target == 34963) {
            this.requestedElementArrayBuffer = webGlBuf;
        } else {
            this.glc.bindBuffer(target, webGlBuf);
        }
    }

    public void glBindFramebuffer(int target, int framebuffer) {
        this.glc.bindFramebuffer(target, this.getFramebuffer(framebuffer));
    }

    public void glBindRenderbuffer(int target, int renderbuffer) {
        this.glc.bindRenderbuffer(target, this.getRenderbuffer(renderbuffer));
    }

    public final void glBlendFunc(int a, int b) {
        this.glc.blendFunc(a, b);
    }

    public void glBlendColor(float red, float green, float blue, float alpha) {
        this.glc.blendColor(red, green, blue, alpha);
    }

    public void glBlendEquation(int mode) {
        this.glc.blendEquation(mode);
    }

    public void glBlendEquationSeparate(int modeRGB, int modeAlpha) {
        this.glc.blendEquationSeparate(modeRGB, modeAlpha);
    }

    public void glBlendFuncSeparate(int srcRGB, int dstRGB, int srcAlpha, int dstAlpha) {
        this.glc.blendFuncSeparate(srcRGB, dstRGB, srcAlpha, dstAlpha);
    }

    public void glBufferData(int target, int byteSize, Buffer data, int usage) {
        if (target == 34962) {
            if (this.requestedArrayBuffer != this.boundArrayBuffer) {
                this.glc.bindBuffer(target, this.requestedArrayBuffer);
                this.boundArrayBuffer = this.requestedArrayBuffer;
            }
        } else if (target == 34963 && this.requestedElementArrayBuffer != this.boundElementArrayBuffer) {
            this.glc.bindBuffer(target, this.requestedElementArrayBuffer);
            this.boundElementArrayBuffer = this.requestedElementArrayBuffer;
        }
        this.glc.bufferData(target, this.getTypedArray(data, 5120, byteSize), usage);
    }

    public void glBufferSubData(int target, int offset, int size, Buffer data) {
        if (target == 34962 && this.requestedArrayBuffer != this.boundArrayBuffer) {
            this.glc.bindBuffer(target, this.requestedArrayBuffer);
            this.boundArrayBuffer = this.requestedArrayBuffer;
        }
        throw new RuntimeException("NYI glBufferSubData");
    }

    public int glCheckFramebufferStatus(int target) {
        return this.glc.checkFramebufferStatus(target);
    }

    public void glCompileShader(int shader) {
        this.glc.compileShader(this.getShader(shader));
    }

    public int glCreateProgram() {
        return this.createObject((WebGLObject)this.glc.createProgram(), WebGLObjectType.PROGRAM);
    }

    public int glCreateShader(int type) {
        return this.createObject((WebGLObject)this.glc.createShader(type), WebGLObjectType.SHADER);
    }

    public void glDeleteTextures(int n, IntBuffer texnumBuffer) {
        this.deleteObjects(n, texnumBuffer, WebGLObjectType.TEXTURE);
    }

    public void glDeleteBuffers(int n, IntBuffer buffers) {
        this.deleteObjects(n, buffers, WebGLObjectType.BUFFER);
    }

    public void glDeleteFramebuffers(int n, IntBuffer framebuffers) {
        this.deleteObjects(n, framebuffers, WebGLObjectType.FRAME_BUFFER);
    }

    public void glDeleteProgram(int program) {
        this.deleteObject(program, WebGLObjectType.PROGRAM);
    }

    public void glDeleteRenderbuffers(int n, IntBuffer renderbuffers) {
        this.deleteObjects(n, renderbuffers, WebGLObjectType.RENDER_BUFFER);
    }

    public void glDeleteShader(int shader) {
        this.deleteObject(shader, WebGLObjectType.SHADER);
    }

    public void glDetachShader(int program, int shader) {
        this.glc.detachShader(this.getProgram(program), this.getShader(shader));
    }

    public void glDisableVertexAttribArray(int index) {
        this.enabledArrays &= ~(1 << index);
    }

    public void glDrawElements(int mode, int count, int type, int indices) {
        this.prepareDraw();
        if (this.requestedElementArrayBuffer != this.boundElementArrayBuffer) {
            this.glc.bindBuffer(34963, this.requestedElementArrayBuffer);
            this.boundElementArrayBuffer = this.requestedElementArrayBuffer;
        }
        this.glc.drawElements(mode, count, type, indices);
    }

    public void glEnableVertexAttribArray(int index) {
        this.enabledArrays |= 1 << index;
    }

    public void glFramebufferRenderbuffer(int target, int attachment, int renderbuffertarget, int renderbuffer) {
        this.glc.framebufferRenderbuffer(target, attachment, renderbuffertarget, this.getRenderbuffer(renderbuffer));
    }

    public void glFramebufferTexture2D(int target, int attachment, int textarget, int texture, int level) {
        this.glc.framebufferTexture2D(target, attachment, textarget, this.getTexture(texture), level);
    }

    public void glGenerateMipmap(int t) {
        this.glc.generateMipmap(t);
    }

    public void glGenBuffers(int n, IntBuffer buffers) {
        this.genObjects(n, buffers, WebGLObjectType.BUFFER);
    }

    public void glGenFramebuffers(int n, IntBuffer framebuffers) {
        this.genObjects(n, framebuffers, WebGLObjectType.FRAME_BUFFER);
    }

    public void glGenRenderbuffers(int n, IntBuffer renderbuffers) {
        this.genObjects(n, renderbuffers, WebGLObjectType.RENDER_BUFFER);
    }

    public void glGenTextures(int n, IntBuffer textures) {
        this.genObjects(n, textures, WebGLObjectType.TEXTURE);
    }

    public void glGenBuffers(int n, int[] buffers, int offset) {
        this.genObjects(n, buffers, offset, WebGLObjectType.BUFFER);
    }

    public void glGenFramebuffers(int n, int[] framebuffers, int offset) {
        this.genObjects(n, framebuffers, offset, WebGLObjectType.FRAME_BUFFER);
    }

    public void glGenRenderbuffers(int n, int[] renderbuffers, int offset) {
        this.genObjects(n, renderbuffers, offset, WebGLObjectType.RENDER_BUFFER);
    }

    public void glGenTextures(int n, int[] textures, int offset) {
        this.genObjects(n, textures, offset, WebGLObjectType.TEXTURE);
    }

    public int glGetAttribLocation(int program, String name) {
        return this.glc.getAttribLocation(this.getProgram(program), name);
    }

    public void glGetBufferParameteriv(int target, int pname, IntBuffer params) {
        params.put(params.position(), this.glc.getBufferParameter(target, pname));
    }

    public float glGetFloat(int pname) {
        return this.glc.getParameterf(pname);
    }

    public void glGetFloatv(int pname, FloatBuffer params) {
        throw new RuntimeException("NYI glGetFloatv");
    }

    public void glGetFramebufferAttachmentParameteriv(int target, int attachment, int pname, IntBuffer params) {
        throw new RuntimeException("NYI glGetFramebufferAttachmentParameteriv");
    }

    public void glGetProgramiv(int program, int pname, IntBuffer params) {
        if (pname != 35714) {
            throw new RuntimeException("NYI glGetProgramiv");
        }
        params.put(this.glc.getProgramParameterb(this.getProgram(program), 35714) ? 1 : 0);
    }

    public String glGetProgramInfoLog(int program) {
        return this.glc.getProgramInfoLog(this.getProgram(program));
    }

    public void glGetRenderbufferParameteriv(int target, int pname, IntBuffer params) {
        throw new RuntimeException("NYI glGetRenderbufferParameteriv");
    }

    public void glGetShaderiv(int shader, int pname, IntBuffer params) {
        if (pname != 35713) {
            throw new RuntimeException("NYI glGetShaderiv: " + pname);
        }
        params.put(this.glc.getShaderParameterb(this.getShader(shader), 35713) ? 1 : 0);
    }

    public String glGetShaderInfoLog(int shader) {
        return this.glc.getShaderInfoLog(this.getShader(shader));
    }

    public void glGetShaderPrecisionFormat(int shadertype, int precisiontype, IntBuffer range, IntBuffer precision) {
        throw new RuntimeException("NYI glGetShaderInfoLog");
    }

    public void glGetTexParameterfv(int target, int pname, FloatBuffer params) {
        params.put(params.position(), this.glc.getTexParameter(target, pname));
    }

    public void glGetTexParameteriv(int target, int pname, IntBuffer params) {
        params.put(params.position(), this.glc.getTexParameter(target, pname));
    }

    public void glGetUniformfv(int program, int location, FloatBuffer params) {
        Float32Array v = (Float32Array)this.glc.getUniformv(this.getProgram(program), this.getUniformLocation(location));
        for (int i = 0; i < v.length(); ++i) {
            params.put(params.position() + i, v.get(i));
        }
    }

    public void glGetUniformiv(int program, int location, IntBuffer params) {
        Int32Array v = (Int32Array)this.glc.getUniformv(this.getProgram(program), this.getUniformLocation(location));
        for (int i = 0; i < v.length(); ++i) {
            params.put(params.position() + i, v.get(i));
        }
    }

    public int glGetUniformLocation(int program, String name) {
        return this.createObject((WebGLObject)this.glc.getUniformLocation(this.getProgram(program), name), WebGLObjectType.UNIFORM_LOCATION);
    }

    public void glGetVertexAttribfv(int index, int pname, FloatBuffer params) {
        Float32Array v = this.glc.getVertexAttribv(index, pname);
        for (int i = 0; i < v.length(); ++i) {
            params.put(params.position() + i, v.get(i));
        }
    }

    public void glGetVertexAttribiv(int index, int pname, IntBuffer params) {
        throw new UnsupportedOperationException("NYI glGetVertexAttribiv: WebGL getVertexAttribv always returns a float buffer.");
    }

    public boolean glIsBuffer(int buffer) {
        return this.isObjectType(buffer, WebGLObjectType.BUFFER);
    }

    public boolean glIsEnabled(int cap) {
        return this.glc.isEnabled(cap);
    }

    public boolean glIsFramebuffer(int framebuffer) {
        return this.isObjectType(framebuffer, WebGLObjectType.FRAME_BUFFER);
    }

    public boolean glIsProgram(int program) {
        return this.isObjectType(program, WebGLObjectType.PROGRAM);
    }

    public boolean glIsRenderbuffer(int renderbuffer) {
        return this.isObjectType(renderbuffer, WebGLObjectType.FRAME_BUFFER);
    }

    public boolean glIsShader(int shader) {
        return this.isObjectType(shader, WebGLObjectType.SHADER);
    }

    public boolean glIsTexture(int texture) {
        return this.isObjectType(texture, WebGLObjectType.TEXTURE);
    }

    public void glLinkProgram(int program) {
        this.glc.linkProgram(this.getProgram(program));
    }

    public void glReleaseShaderCompiler() {
        throw new RuntimeException("NYI glReleaseShaderCompiler");
    }

    public void glRenderbufferStorage(int target, int internalformat, int width, int height) {
        this.glc.renderbufferStorage(target, internalformat, width, height);
    }

    public void glSampleCoverage(float value, boolean invert) {
        this.glc.sampleCoverage(value, invert);
    }

    public void glShaderBinary(int n, IntBuffer shaders, int binaryformat, Buffer binary, int length) {
        throw new RuntimeException("NYI glReleaseShaderCompiler");
    }

    public void glShaderSource(int shader, String string) {
        this.glc.shaderSource(this.getShader(shader), string);
    }

    public void glStencilFuncSeparate(int face, int func, int ref, int mask) {
        this.glc.stencilFuncSeparate(face, func, ref, mask);
    }

    public void glStencilMaskSeparate(int face, int mask) {
        this.glc.stencilMaskSeparate(face, mask);
    }

    public void glStencilOpSeparate(int face, int fail, int zfail, int zpass) {
        this.glc.stencilOpSeparate(face, fail, zfail, zpass);
    }

    public void glTexParameterfv(int target, int pname, FloatBuffer params) {
        throw new RuntimeException("NYI glTexParameterfv");
    }

    public void glTexParameteriv(int target, int pname, IntBuffer params) {
        throw new RuntimeException("NYI glTexParameteriv");
    }

    public void glUniform1f(int location, float x) {
        this.glc.uniform1f(this.getUniformLocation(location), x);
    }

    public void glUniform1fv(int location, int count, FloatBuffer v) {
        throw new RuntimeException("NYI glUniform1fv");
    }

    public void glUniform1i(int location, int x) {
        this.glc.uniform1i(this.getUniformLocation(location), x);
    }

    public void glUniform1iv(int location, int count, IntBuffer v) {
        this.glc.uniform1iv(this.getUniformLocation(location), (Int32Array)this.getTypedArray(v, 5124, count * 4));
    }

    public void glUniform2f(int location, float x, float y) {
        this.glc.uniform2f(this.getUniformLocation(location), x, y);
    }

    public void glUniform2fv(int location, int count, FloatBuffer v) {
        this.glc.uniform2fv(this.getUniformLocation(location), (Float32Array)this.getTypedArray(v, 5126, count * 2 * 4));
    }

    public void glUniform2i(int location, int x, int y) {
        this.glc.uniform2i(this.getUniformLocation(location), x, y);
    }

    public void glUniform2iv(int location, int count, IntBuffer v) {
        throw new RuntimeException("NYI glUniform2iv");
    }

    public void glUniform3f(int location, float x, float y, float z) {
        this.glc.uniform3f(this.getUniformLocation(location), x, y, z);
    }

    public void glUniform3fv(int location, int count, FloatBuffer v) {
        throw new RuntimeException("NYI glUniform3fv");
    }

    public void glUniform3i(int location, int x, int y, int z) {
        this.glc.uniform3i(this.getUniformLocation(location), x, y, z);
    }

    public void glUniform3iv(int location, int count, IntBuffer v) {
        throw new RuntimeException("NYI glUniform3fi");
    }

    public void glUniform4f(int location, float x, float y, float z, float w) {
        this.glc.uniform4f(this.getUniformLocation(location), x, y, z, w);
    }

    public void glUniform4fv(int location, int count, FloatBuffer v) {
        this.glc.uniform4fv(this.getUniformLocation(location), (Float32Array)this.getTypedArray(v, 5126, 16 * count));
    }

    public void glUniform4i(int location, int x, int y, int z, int w) {
        this.glc.uniform4i(this.getUniformLocation(location), x, y, z, w);
    }

    public void glUniform4iv(int location, int count, IntBuffer v) {
        throw new RuntimeException("NYI glUniform4iv");
    }

    public void glUniformMatrix2fv(int location, int count, boolean transpose, FloatBuffer value) {
        throw new RuntimeException("NYI glUniformMatrix2fv");
    }

    public void glUniformMatrix3fv(int location, int count, boolean transpose, FloatBuffer value) {
        throw new RuntimeException("NYI glUniformMatrix3fv");
    }

    public void glUniformMatrix4fv(int location, int count, boolean transpose, FloatBuffer value) {
        this.glc.uniformMatrix4fv(this.getUniformLocation(location), transpose, (Float32Array)this.getTypedArray(value, 5126, count * 16 * 4));
    }

    public void glUseProgram(int program) {
        this.glc.useProgram(this.getProgram(program));
    }

    public void glValidateProgram(int program) {
        this.glc.validateProgram(this.getProgram(program));
    }

    public void glVertexAttrib1f(int indx, float x) {
        this.glc.vertexAttrib1f(indx, x);
    }

    public void glVertexAttrib1fv(int indx, FloatBuffer values) {
        throw new RuntimeException("NYI glVertexAttrib1fv");
    }

    public void glVertexAttrib2f(int indx, float x, float y) {
        this.glc.vertexAttrib2f(indx, x, y);
    }

    public void glVertexAttrib2fv(int indx, FloatBuffer values) {
        throw new RuntimeException("NYI glVertexAttrib2fv");
    }

    public void glVertexAttrib3f(int indx, float x, float y, float z) {
        this.glc.vertexAttrib3f(indx, x, y, z);
    }

    public void glVertexAttrib3fv(int indx, FloatBuffer values) {
        throw new RuntimeException("NYI glVertexAttrib3fv");
    }

    public void glVertexAttrib4f(int indx, float x, float y, float z, float w) {
        this.glc.vertexAttrib4f(indx, x, y, z, w);
    }

    public void glVertexAttrib4fv(int indx, FloatBuffer values) {
        throw new RuntimeException("NYI glVertexAttrib4fv");
    }

    public void glVertexAttribPointer(int indx, int size, int type, boolean normalized, int stride, int ptr) {
        this.useNioBuffer &= ~(1 << indx);
        if (this.boundArrayBuffer != this.requestedArrayBuffer) {
            this.glc.bindBuffer(34962, this.requestedArrayBuffer);
            this.boundArrayBuffer = this.requestedArrayBuffer;
        }
        this.glc.vertexAttribPointer(indx, size, type, normalized, stride, ptr);
    }

    public void glDisable(int cap) {
        this.glc.disable(cap);
    }

    public void glEnable(int cap) {
        this.glc.enable(cap);
    }

    public void glActiveTexture(int texture) {
        this.glc.activeTexture(texture);
    }

    public String getPlatformGLExtensions() {
        throw new RuntimeException("NYI getPlatformGLExtensions");
    }

    public int getSwapInterval() {
        throw new RuntimeException("NYI getSwapInterval");
    }

    public void glClearDepth(double depth) {
        throw new RuntimeException("NYI glClearDepth");
    }

    public void glCompressedTexImage3D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, Buffer arg8) {
        throw new RuntimeException("NYI glCompressedTexImage3D");
    }

    public void glCompressedTexSubImage3D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, Buffer arg10) {
        throw new RuntimeException("NYI glCompressedTexSubImage3D");
    }

    public void glCopyTexSubImage3D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8) {
        throw new RuntimeException("NYI glCopyTexSubImage3D");
    }

    public void glDeleteBuffers(int n, int[] buffers, int offset) {
        this.deleteObjects(n, buffers, offset, WebGLObjectType.BUFFER);
    }

    public void glDeleteFramebuffers(int n, int[] framebuffers, int offset) {
        this.deleteObjects(n, framebuffers, offset, WebGLObjectType.FRAME_BUFFER);
    }

    public void glDeleteRenderbuffers(int n, int[] renderbuffers, int offset) {
        this.deleteObjects(n, renderbuffers, offset, WebGLObjectType.RENDER_BUFFER);
    }

    public void glDeleteTextures(int n, int[] textures, int offset) {
        this.deleteObjects(n, textures, offset, WebGLObjectType.TEXTURE);
    }

    public void glDepthRange(double zNear, double zFar) {
        throw new RuntimeException("NYI glDepthRange");
    }

    public void glFramebufferTexture3D(int target, int attachment, int textarget, int texture, int level, int zoffset) {
        throw new RuntimeException("NYI glFramebufferTexture3D");
    }

    public void glGetActiveAttrib(int program, int index, int bufsize, int[] length, int lengthOffset, int[] size, int sizeOffset, int[] type, int typeOffset, byte[] name, int nameOffset) {
        throw new RuntimeException("NYI glGetActiveAttrib");
    }

    public void glGetActiveAttrib(int program, int index, int bufsize, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        throw new RuntimeException("NYI glGetActiveAttrib");
    }

    public void glGetActiveUniform(int program, int index, int bufsize, int[] length, int lengthOffset, int[] size, int sizeOffset, int[] type, int typeOffset, byte[] name, int nameOffset) {
        throw new RuntimeException("NYI glGetActiveUniform");
    }

    public void glGetActiveUniform(int program, int index, int bufsize, IntBuffer length, IntBuffer size, IntBuffer type, ByteBuffer name) {
        throw new RuntimeException("NYI glGetActiveUniform");
    }

    public void glGetAttachedShaders(int program, int maxcount, int[] count, int countOffset, int[] shaders, int shadersOffset) {
        throw new RuntimeException("NYI glGetAttachedShaders");
    }

    public void glGetAttachedShaders(int program, int maxcount, IntBuffer count, IntBuffer shaders) {
        throw new RuntimeException("NYI glGetAttachedShaders");
    }

    public boolean glGetBoolean(int pname) {
        return this.glc.getParameterb(pname);
    }

    public void glGetBooleanv(int pname, ByteBuffer params) {
        throw new RuntimeException("NYI glGetBooleanv");
    }

    public int glGetBoundBuffer(int arg0) {
        throw new RuntimeException("NYI glGetBoundBuffer");
    }

    public void glGetProgramBinary(int arg0, int arg1, IntBuffer arg2, IntBuffer arg3, Buffer arg4) {
        throw new RuntimeException("NYI glGetProgramBinary");
    }

    public void glGetProgramInfoLog(int program, int bufsize, IntBuffer length, ByteBuffer infolog) {
        throw new RuntimeException("NYI glGetProgramInfoLog");
    }

    public void glGetProgramiv(int program, int pname, int[] params, int offset) {
        if (pname != 35714) {
            throw new RuntimeException("NYI glGetProgramiv: " + pname);
        }
        params[offset] = this.glc.getProgramParameterb(this.getProgram(program), 35714) ? 1 : 0;
    }

    public void glGetShaderInfoLog(int shader, int bufsize, IntBuffer length, ByteBuffer infolog) {
        throw new RuntimeException("NYI glGetShaderInfoLog");
    }

    public void glGetShaderiv(int shader, int pname, int[] params, int offset) {
        if (pname != 35713) {
            throw new RuntimeException("NYI glGetShaderiv: " + pname);
        }
        params[offset] = this.glc.getShaderParameterb(this.getShader(shader), 35713) ? 1 : 0;
    }

    public void glGetShaderPrecisionFormat(int shadertype, int precisiontype, int[] range, int rangeOffset, int[] precision, int precisionOffset) {
        throw new RuntimeException("NYI glGetShaderPrecisionFormat");
    }

    public void glGetShaderSource(int shader, int bufsize, int[] length, int lengthOffset, byte[] source, int sourceOffset) {
        throw new RuntimeException("NYI glGetShaderSource");
    }

    public void glGetShaderSource(int shader, int bufsize, IntBuffer length, ByteBuffer source) {
        throw new RuntimeException("NYI glGetShaderSource");
    }

    public boolean glIsVBOArrayEnabled() {
        throw new RuntimeException("NYI glIsVBOArrayEnabled");
    }

    public boolean glIsVBOElementEnabled() {
        throw new RuntimeException("NYI glIsVBOElementEnabled");
    }

    public ByteBuffer glMapBuffer(int arg0, int arg1) {
        throw new RuntimeException("NYI glMapBuffer");
    }

    public void glProgramBinary(int arg0, int arg1, Buffer arg2, int arg3) {
        throw new RuntimeException("NYI glProgramBinary");
    }

    public void glShaderBinary(int n, int[] shaders, int offset, int binaryformat, Buffer binary, int length) {
        throw new RuntimeException("NYI glShaderBinary");
    }

    public void glShaderSource(int shader, int count, String[] strings, int[] length, int lengthOffset) {
        throw new RuntimeException("NYI glShaderSource");
    }

    public void glShaderSource(int shader, int count, String[] strings, IntBuffer length) {
        throw new RuntimeException("NYI glShaderSource");
    }

    public void glTexImage3D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, Buffer arg9) {
        throw new RuntimeException("NYI glTexImage3D");
    }

    public void glTexSubImage3D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, Buffer arg10) {
        throw new RuntimeException("NYI glTexSubImage3D");
    }

    public boolean glUnmapBuffer(int arg0) {
        throw new RuntimeException("NYI glUnmapBuffer");
    }

    public boolean hasGLSL() {
        return true;
    }

    public boolean isExtensionAvailable(String extension) {
        throw new RuntimeException("NYI isExtensionAvailable");
    }

    public boolean isFunctionAvailable(String function) {
        throw new RuntimeException("NYI isFunctionAvailable");
    }

    public void glCompressedTexImage2D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7) {
        throw new RuntimeException("NYI glCompressedTexImage2D");
    }

    public void glCompressedTexImage3D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8) {
        throw new RuntimeException("NYI glCompressedTexImage3D");
    }

    public void glCompressedTexSubImage2D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8) {
        throw new RuntimeException("NYI glCompressedTexSubImage2D");
    }

    public void glCompressedTexSubImage3D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10) {
        throw new RuntimeException("NYI glCompressedTexSubImage3D");
    }

    public void glReadPixels(int x, int y, int width, int height, int format, int type, int pixelsBufferOffset) {
        throw new RuntimeException("NYI glReadPixels");
    }

    public void glTexImage2D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8) {
        throw new RuntimeException("NYI glTexImage2D");
    }

    public void glTexImage3D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9) {
        throw new RuntimeException("NYI glTexImage3D");
    }

    public void glTexSubImage2D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8) {
        throw new RuntimeException("NYI glTexSubImage2D");
    }

    public void glTexSubImage3D(int arg0, int arg1, int arg2, int arg3, int arg4, int arg5, int arg6, int arg7, int arg8, int arg9, int arg10) {
        throw new RuntimeException("NYI glTexSubImage3D");
    }

    class VertexAttribArrayState {
        int type;
        int size;
        int stride;
        boolean normalize;
        Buffer nioBuffer;
        int nioBufferPosition;
        int nioBufferLimit;
        WebGLBuffer webGlBuffer;

        VertexAttribArrayState() {
        }
    }

    static enum WebGLObjectType {
        NULL,
        BUFFER,
        FRAME_BUFFER,
        PROGRAM,
        RENDER_BUFFER,
        SHADER,
        TEXTURE,
        UNIFORM_LOCATION;

    }
}

