/*
 * Decompiled with CFR 0.152.
 */
package playn.html;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptException;
import com.google.gwt.dom.client.Document;
import com.google.gwt.dom.client.Element;
import com.google.gwt.dom.client.ImageElement;
import com.google.gwt.regexp.shared.RegExp;
import com.google.gwt.resources.client.DataResource;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.resources.client.ResourcePrototype;
import com.google.gwt.user.client.Window;
import com.google.gwt.xhr.client.ReadyStateChangeHandler;
import com.google.gwt.xhr.client.XMLHttpRequest;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import playn.core.Assets;
import playn.core.AutoClientBundleWithLookup;
import playn.core.Graphics;
import playn.core.Image;
import playn.core.ImageImpl;
import playn.core.Scale;
import playn.core.Sound;
import playn.html.HtmlImage;
import playn.html.HtmlPlatform;
import playn.html.XDomainRequest;
import react.RFuture;
import react.RPromise;

public class HtmlAssets
extends Assets {
    private static final boolean LOG_XHR_SUCCESS = false;
    private final HtmlPlatform plat;
    private final Map<String, AutoClientBundleWithLookup> clientBundles = new HashMap<String, AutoClientBundleWithLookup>();
    private String pathPrefix = GWT.getModuleBaseForStaticFiles();
    private Scale assetScale = null;
    private ImageManifest imageManifest;

    public void setPathPrefix(String prefix) {
        this.pathPrefix = prefix;
    }

    public void setImageManifest(ImageManifest manifest) {
        this.imageManifest = manifest;
    }

    public void setAssetScale(float scaleFactor) {
        this.assetScale = new Scale(scaleFactor);
    }

    public void addClientBundle(String regExp, AutoClientBundleWithLookup clientBundle) {
        this.clientBundles.put(regExp, clientBundle);
    }

    public Image getImageSync(String path) {
        if (this.imageManifest == null) {
            throw new UnsupportedOperationException("getImageSync(" + path + ")");
        }
        for (Scale.ScaledResource rsrc : this.assetScale().getScaledResources(path)) {
            int[] size = this.imageManifest.imageSize(rsrc.path);
            if (size == null) continue;
            return this.getImage(rsrc.path, rsrc.scale).preload(size[0], size[1]);
        }
        return new HtmlImage(this.plat.graphics(), new Throwable("Image missing from manifest: " + path));
    }

    public Image getImage(String path) {
        Scale assetScale = this.assetScale == null ? Scale.ONE : this.assetScale;
        List rsrcs = assetScale.getScaledResources(path);
        return this.getImage(((Scale.ScaledResource)rsrcs.get((int)0)).path, ((Scale.ScaledResource)rsrcs.get((int)0)).scale);
    }

    protected HtmlImage getImage(String path, Scale scale) {
        String key;
        ImageResource resource;
        String url = this.pathPrefix + path;
        AutoClientBundleWithLookup clientBundle = this.getBundle(path);
        if (clientBundle != null && (resource = (ImageResource)this.getResource(key = this.getKey(path), clientBundle)) != null) {
            url = resource.getSafeUri().asString();
        }
        return this.adaptImage(url, scale);
    }

    public Image getRemoteImage(String url) {
        return this.adaptImage(url, Scale.ONE);
    }

    public Image getRemoteImage(String url, int width, int height) {
        return this.adaptImage(url, Scale.ONE).preload(width, height);
    }

    public Sound getSound(String path) {
        String url = this.pathPrefix + path;
        AutoClientBundleWithLookup clientBundle = this.getBundle(path);
        if (clientBundle != null) {
            String key = this.getKey(path);
            DataResource resource = (DataResource)this.getResource(key, clientBundle);
            if (resource != null) {
                url = resource.getSafeUri().asString();
            }
        } else {
            url = url + ".mp3";
        }
        return this.plat.audio().createSound(url);
    }

    public String getTextSync(String path) throws Exception {
        throw new UnsupportedOperationException("getTextSync(" + path + ")");
    }

    public RFuture<String> getText(String path) {
        RPromise result = RPromise.create();
        String fullPath = this.pathPrefix + path;
        try {
            this.doXhr(fullPath, (RPromise<String>)result);
        }
        catch (JavaScriptException e) {
            if (Window.Navigator.getUserAgent().indexOf("MSIE") != -1) {
                this.doXdr(fullPath, (RPromise<String>)result);
            }
            throw e;
        }
        return result;
    }

    public byte[] getBytesSync(String path) throws Exception {
        throw new UnsupportedOperationException("getByteSync(" + path + ")");
    }

    public RFuture<byte[]> getBytes(String path) {
        return RFuture.failure((Throwable)new UnsupportedOperationException("getByte(" + path + ")"));
    }

    protected ImageImpl.Data load(String path) throws Exception {
        throw new UnsupportedOperationException("unused");
    }

    protected ImageImpl createImage(boolean async, int rwid, int rhei, String source) {
        throw new UnsupportedOperationException("unused");
    }

    HtmlAssets(HtmlPlatform plat) {
        super(plat.exec());
        this.plat = plat;
    }

    private Scale assetScale() {
        return this.assetScale != null ? this.assetScale : this.plat.graphics().scale();
    }

    private void doXdr(final String path, final RPromise<String> result) {
        XDomainRequest xdr = XDomainRequest.create();
        xdr.setHandler(new XDomainRequest.Handler(){

            @Override
            public void onTimeout(XDomainRequest xdr) {
                HtmlAssets.this.plat.log().error("xdr::onTimeout[" + path + "]()");
                result.fail((Throwable)new Exception("Error getting " + path + " : " + xdr.getStatus()));
            }

            @Override
            public void onProgress(XDomainRequest xdr) {
            }

            @Override
            public void onLoad(XDomainRequest xdr) {
                result.succeed((Object)xdr.getResponseText());
            }

            @Override
            public void onError(XDomainRequest xdr) {
                HtmlAssets.this.plat.log().error("xdr::onError[" + path + "]()");
                result.fail((Throwable)new Exception("Error getting " + path + " : " + xdr.getStatus()));
            }
        });
        xdr.open("GET", path);
        xdr.send();
    }

    private void doXhr(final String path, final RPromise<String> result) {
        XMLHttpRequest xhr = XMLHttpRequest.create();
        xhr.setOnReadyStateChange(new ReadyStateChangeHandler(){

            public void onReadyStateChange(XMLHttpRequest xhr) {
                int readyState = xhr.getReadyState();
                if (readyState == 4) {
                    int status = xhr.getStatus();
                    if (status != 0 && (status < 200 || status >= 400)) {
                        HtmlAssets.this.plat.log().error("xhr::onReadyStateChange[" + path + "]" + "(readyState = " + readyState + "; status = " + status + ")");
                        result.fail((Throwable)new Exception("Error getting " + path + " : " + xhr.getStatusText()));
                    } else {
                        result.succeed((Object)xhr.getResponseText());
                    }
                }
            }
        });
        xhr.open("GET", path);
        xhr.send();
    }

    private String getKey(String fullPath) {
        String key = fullPath.substring(fullPath.lastIndexOf(47) + 1);
        int dotCharIdx = key.indexOf(46);
        return dotCharIdx != -1 ? key.substring(0, dotCharIdx) : key;
    }

    private ResourcePrototype getResource(String key, AutoClientBundleWithLookup clientBundle) {
        ResourcePrototype resource = clientBundle.getResource(key);
        return resource;
    }

    private AutoClientBundleWithLookup getBundle(String collection) {
        AutoClientBundleWithLookup clientBundle = null;
        for (Map.Entry<String, AutoClientBundleWithLookup> entry : this.clientBundles.entrySet()) {
            String regExp = entry.getKey();
            if (RegExp.compile((String)regExp).exec(collection) == null) continue;
            clientBundle = entry.getValue();
        }
        return clientBundle;
    }

    private HtmlImage adaptImage(String url, Scale scale) {
        ImageElement img = Document.get().createImageElement();
        this.setCrossOrigin((Element)img, "anonymous");
        img.setSrc(url);
        return new HtmlImage((Graphics)this.plat.graphics(), scale, img, url);
    }

    private native void setCrossOrigin(Element var1, String var2);

    public static interface ImageManifest {
        public int[] imageSize(String var1);
    }
}

