/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import playn.core.GL20;
import playn.core.Texture;
import playn.core.TexturedBatch;
import pythagoras.f.AffineTransform;

public abstract class QuadBatch
extends TexturedBatch {
    public void addQuad(Texture tex, int tint, AffineTransform xf, float x, float y, float w, float h) {
        this.setTexture(tex);
        float sr = tex.config.repeatX ? w / tex.displayWidth : 1.0f;
        float sb = tex.config.repeatY ? h / tex.displayHeight : 1.0f;
        this.addQuad(tint, xf, x, y, x + w, y + h, 0.0f, 0.0f, sr, sb);
    }

    public void addQuad(Texture tex, int tint, AffineTransform xf, float dx, float dy, float dw, float dh, float sx, float sy, float sw, float sh) {
        this.setTexture(tex);
        float texWidth = tex.displayWidth;
        float texHeight = tex.displayHeight;
        this.addQuad(tint, xf, dx, dy, dx + dw, dy + dh, sx / texWidth, sy / texHeight, (sx + sw) / texWidth, (sy + sh) / texHeight);
    }

    public void addQuad(int tint, AffineTransform xf, float left, float top, float right, float bottom, float sl, float st, float sr, float sb) {
        this.addQuad(tint, xf.m00, xf.m01, xf.m10, xf.m11, xf.tx, xf.ty, left, top, right, bottom, sl, st, sr, sb);
    }

    public void addQuad(int tint, float m00, float m01, float m10, float m11, float tx, float ty, float left, float top, float right, float bottom, float sl, float st, float sr, float sb) {
        this.addQuad(tint, m00, m01, m10, m11, tx, ty, left, top, sl, st, right, top, sr, st, left, bottom, sl, sb, right, bottom, sr, sb);
    }

    public abstract void addQuad(int var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9, float var10, float var11, float var12, float var13, float var14, float var15, float var16, float var17, float var18, float var19, float var20, float var21, float var22, float var23);

    protected QuadBatch(GL20 gl) {
        super(gl);
    }
}

