/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import playn.core.Image;
import playn.core.Scale;
import react.Function;
import react.RFuture;

public abstract class Net {
    protected static final String UTF8 = "UTF-8";
    private static final Function<Response, String> GET_PAYLOAD = new Function<Response, String>(){

        public String apply(Response rsp) {
            return rsp.payloadString();
        }
    };

    public WebSocket createWebSocket(String url, WebSocket.Listener listener) {
        throw new UnsupportedOperationException();
    }

    public RFuture<String> get(String url) {
        return this.req(url).execute().map(GET_PAYLOAD);
    }

    public RFuture<String> post(String url, String data) {
        return this.req(url).setPayload(data).execute().map(GET_PAYLOAD);
    }

    public Builder req(String url) {
        return new Builder(url);
    }

    protected RFuture<Response> execute(Builder req) {
        return RFuture.failure((Throwable)new UnsupportedOperationException());
    }

    public class Builder {
        public final String url;
        public final List<Header> headers = new ArrayList<Header>();
        public String contentType = "text/plain";
        public String payloadString;
        public byte[] payloadBytes;

        public Builder setPayload(String payload) {
            return this.setPayload(payload, "text/plain");
        }

        public Builder setPayload(String payload, String contentType) {
            this.payloadString = payload;
            this.contentType = contentType;
            return this;
        }

        public Builder setPayload(byte[] payload) {
            return this.setPayload(payload, "application/octet-stream");
        }

        public Builder setPayload(byte[] payload, String contentType) {
            this.payloadBytes = payload;
            this.contentType = contentType;
            return this;
        }

        public Builder addHeader(String name, String value) {
            this.headers.add(new Header(name, value));
            return this;
        }

        public RFuture<Response> execute() {
            return Net.this.execute(this);
        }

        public boolean isPost() {
            return this.payloadString != null || this.payloadBytes != null;
        }

        public String method() {
            return this.isPost() ? "POST" : "GET";
        }

        public String contentType() {
            return this.contentType + (this.payloadString != null ? "; charset=UTF-8" : "");
        }

        protected Builder(String url) {
            assert (url.startsWith("http:") || url.startsWith("https:")) : "Only http and https URLs are supported";
            this.url = url;
        }
    }

    public static abstract class Response {
        private int responseCode;
        private Map<String, List<String>> headersMap;

        public int responseCode() {
            return this.responseCode;
        }

        public Iterable<String> headerNames() {
            return this.headers().keySet();
        }

        public String header(String name) {
            List<String> values = this.headers().get(name);
            return values == null ? null : values.get(0);
        }

        public List<String> headers(String name) {
            List<String> values = this.headers().get(name);
            return values == null ? Collections.emptyList() : values;
        }

        public abstract String payloadString();

        public byte[] payload() {
            throw new UnsupportedOperationException();
        }

        public Image payloadImage(Scale scale) throws Exception {
            throw new UnsupportedOperationException();
        }

        protected Response(int responseCode) {
            this.responseCode = responseCode;
        }

        protected abstract Map<String, List<String>> extractHeaders();

        private Map<String, List<String>> headers() {
            if (this.headersMap == null) {
                this.headersMap = this.extractHeaders();
            }
            return this.headersMap;
        }

        public static abstract class Binary
        extends Response {
            private final byte[] payload;
            private final String encoding;

            public Binary(int responseCode, byte[] payload, String encoding) {
                super(responseCode);
                this.payload = payload;
                this.encoding = encoding;
            }

            @Override
            public String payloadString() {
                try {
                    return new String(this.payload, this.encoding);
                }
                catch (UnsupportedEncodingException uee) {
                    return uee.toString();
                }
            }

            @Override
            public byte[] payload() {
                return this.payload;
            }
        }
    }

    public static class Header {
        public final String name;
        public final String value;

        public Header(String name, String value) {
            this.name = name;
            this.value = value;
        }
    }

    public static class HttpException
    extends IOException {
        public final int errorCode;

        public HttpException(int errorCode, String message) {
            super(message);
            this.errorCode = errorCode;
        }

        @Override
        public String toString() {
            String msg = this.getLocalizedMessage();
            return "HTTP " + this.errorCode + (msg == null ? "" : ": " + msg);
        }
    }

    public static interface WebSocket {
        public void close();

        public void send(String var1);

        public void send(ByteBuffer var1);

        public static interface Listener {
            public void onOpen();

            public void onTextMessage(String var1);

            public void onDataMessage(ByteBuffer var1);

            public void onClose();

            public void onError(String var1);
        }
    }
}

