/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import playn.core.Event;
import react.Slot;

public class Mouse {
    public static ButtonEvent buttonEvents(Event event) {
        return event instanceof ButtonEvent ? (ButtonEvent)event : null;
    }

    public static WheelEvent wheelEvents(Event event) {
        return event instanceof WheelEvent ? (WheelEvent)event : null;
    }

    public static MotionEvent motionEvents(Event event) {
        return event instanceof MotionEvent ? (MotionEvent)event : null;
    }

    public static class ButtonEvent
    extends Event {
        public final Id button;
        public boolean down;

        public ButtonEvent(int flags, double time, float x, float y, Id button, boolean down) {
            super(flags, time, x, y);
            this.button = button;
            this.down = down;
        }

        @Override
        protected String name() {
            return "Button";
        }

        @Override
        protected void addFields(StringBuilder builder) {
            super.addFields(builder);
            builder.append(", id=").append((Object)this.button).append(", down=").append(this.down);
        }

        public static enum Id {
            LEFT,
            RIGHT,
            MIDDLE,
            X1,
            X2;

        }
    }

    public static class WheelEvent
    extends Event {
        public final float velocity;

        public WheelEvent(int flags, double time, float x, float y, float velocity) {
            super(flags, time, x, y);
            this.velocity = velocity;
        }

        @Override
        protected String name() {
            return "Wheel";
        }

        @Override
        protected void addFields(StringBuilder builder) {
            super.addFields(builder);
            builder.append(", velocity=").append(this.velocity);
        }
    }

    public static class MotionEvent
    extends Event {
        public final float dx;
        public final float dy;

        public MotionEvent(int flags, double time, float x, float y, float dx, float dy) {
            super(flags, time, x, y);
            this.dx = dx;
            this.dy = dy;
        }

        @Override
        protected String name() {
            return "MotionEvent";
        }

        @Override
        protected void addFields(StringBuilder builder) {
            super.addFields(builder);
            builder.append(", dx=").append(this.dx).append(", dy=").append(this.dy);
        }
    }

    public static abstract class WheelSlot
    extends Slot<Event> {
        public void onEmit(Event event) {
            if (event instanceof WheelEvent) {
                this.onEmit((WheelEvent)event);
            }
        }

        public abstract void onEmit(WheelEvent var1);
    }

    public static abstract class MotionSlot
    extends Slot<Event> {
        public void onEmit(Event event) {
            if (event instanceof MotionEvent) {
                this.onEmit((MotionEvent)event);
            }
        }

        public abstract void onEmit(MotionEvent var1);
    }

    public static abstract class ButtonSlot
    extends Slot<Event> {
        public void onEmit(Event event) {
            if (event instanceof ButtonEvent) {
                this.onEmit((ButtonEvent)event);
            }
        }

        public abstract void onEmit(ButtonEvent var1);
    }

    public static class Event
    extends Event.XY {
        protected Event(int flags, double time, float x, float y) {
            super(flags, time, x, y);
        }
    }
}

