/*
 * Decompiled with CFR 0.152.
 */
package playn.core.json;

import java.util.Collection;
import java.util.Map;
import java.util.Stack;
import playn.core.Json;
import playn.core.json.JsonArray;
import playn.core.json.JsonObject;
import playn.core.json.JsonSink;
import playn.core.json.JsonWriterException;

final class JsonBuilder<T>
implements JsonSink<JsonBuilder<T>> {
    private Stack<Object> json = new Stack();
    private T root;

    JsonBuilder(T root) {
        this.root = root;
        this.json.push(root);
    }

    public T done() {
        return this.root;
    }

    @Override
    public JsonBuilder<T> array(Collection<?> c) {
        return this.value(c);
    }

    @Override
    public JsonBuilder<T> array(Json.Array c) {
        return this.value(c);
    }

    @Override
    public JsonBuilder<T> array(String key, Collection<?> c) {
        return this.value(key, c);
    }

    @Override
    public JsonBuilder<T> array(String key, Json.Array c) {
        return this.value(key, c);
    }

    @Override
    public JsonBuilder<T> object(Map<?, ?> map) {
        return this.value(map);
    }

    @Override
    public JsonBuilder<T> object(Json.Object object) {
        return this.value(object);
    }

    @Override
    public JsonBuilder<T> object(String key, Map<?, ?> map) {
        return this.value(key, map);
    }

    @Override
    public JsonBuilder<T> object(String key, Json.Object object) {
        return this.value(key, object);
    }

    @Override
    public JsonBuilder<T> nul() {
        return this.value((Object)null);
    }

    @Override
    public JsonBuilder<T> nul(String key) {
        return this.value(key, (Object)null);
    }

    @Override
    public JsonBuilder<T> value(Object o) {
        this.arr().add(o);
        return this;
    }

    @Override
    public JsonBuilder<T> value(String key, Object o) {
        this.obj().put(key, o);
        return this;
    }

    @Override
    public JsonBuilder<T> value(String s) {
        return this.value((Object)s);
    }

    @Override
    public JsonBuilder<T> value(boolean b) {
        return this.value((Object)b);
    }

    @Override
    public JsonBuilder<T> value(Number n) {
        return this.value((Object)n);
    }

    @Override
    public JsonBuilder<T> value(String key, String s) {
        return this.value(key, (Object)s);
    }

    @Override
    public JsonBuilder<T> value(String key, boolean b) {
        return this.value(key, (Object)b);
    }

    @Override
    public JsonBuilder<T> value(String key, Number n) {
        return this.value(key, (Object)n);
    }

    @Override
    public JsonBuilder<T> array() {
        JsonArray a = new JsonArray();
        this.value(a);
        this.json.push(a);
        return this;
    }

    @Override
    public JsonBuilder<T> object() {
        JsonObject o = new JsonObject();
        this.value(o);
        this.json.push(o);
        return this;
    }

    @Override
    public JsonBuilder<T> array(String key) {
        JsonArray a = new JsonArray();
        this.value(key, a);
        this.json.push(a);
        return this;
    }

    @Override
    public JsonBuilder<T> object(String key) {
        JsonObject o = new JsonObject();
        this.value(key, o);
        this.json.push(o);
        return this;
    }

    @Override
    public JsonBuilder<T> end() {
        if (this.json.size() == 1) {
            throw new JsonWriterException("Cannot end the root object or array");
        }
        this.json.pop();
        return this;
    }

    private JsonObject obj() {
        try {
            return (JsonObject)this.json.peek();
        }
        catch (ClassCastException e) {
            throw new JsonWriterException("Attempted to write a keyed value to a JsonArray");
        }
    }

    private JsonArray arr() {
        try {
            return (JsonArray)this.json.peek();
        }
        catch (ClassCastException e) {
            throw new JsonWriterException("Attempted to write a non-keyed value to a JsonObject");
        }
    }
}

