/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import playn.core.Event;
import playn.core.Mouse;
import playn.core.Platform;
import playn.core.Touch;
import react.Signal;
import react.Slot;

public class Pointer {
    public boolean enabled = true;
    public Signal<Event> events = Signal.create();
    private Platform plat;

    public Pointer(Platform plat) {
        this.plat = plat;
        if (plat.input().hasTouch()) {
            class TouchConverter {
                private int active = -1;
                public Slot<Touch.Event[]> onTouch = new Slot<Touch.Event[]>(){

                    public void onEmit(Touch.Event[] events) {
                        for (Touch.Event event : events) {
                            if (active == -1 && event.kind.isStart) {
                                active = event.id;
                            }
                            if (event.id != active) continue;
                            Pointer.this.forward(event, Event.Kind.values()[event.kind.ordinal()], true);
                            if (!event.kind.isEnd) continue;
                            active = -1;
                        }
                    }
                };
                public Slot<Boolean> onFocus = new Slot<Boolean>(){

                    public void onEmit(Boolean focus) {
                        if (!focus.booleanValue() && active != -1) {
                            Pointer.this.forward(0, 0.0, 0.0f, 0.0f, Event.Kind.CANCEL, true);
                            active = -1;
                        }
                    }
                };

                TouchConverter() {
                }
            }
            TouchConverter tc = new TouchConverter();
            plat.input().touchEvents.connect(tc.onTouch);
            plat.input().focus.connect(tc.onFocus);
        } else if (plat.input().hasMouse()) {
            class MouseConverter {
                private boolean dragging;
                public Slot<Mouse.Event> onMouse = new Slot<Mouse.Event>(){

                    public void onEmit(Mouse.Event event) {
                        if (event instanceof Mouse.MotionEvent) {
                            if (dragging) {
                                Pointer.this.forward(event, Event.Kind.DRAG, false);
                            }
                        } else if (event instanceof Mouse.ButtonEvent) {
                            Mouse.ButtonEvent bevent = (Mouse.ButtonEvent)event;
                            if (bevent.button == Mouse.ButtonEvent.Id.LEFT) {
                                dragging = bevent.down;
                                Pointer.this.forward(bevent, bevent.down ? Event.Kind.START : Event.Kind.END, false);
                            }
                        }
                    }
                };
                public Slot<Boolean> onFocus = new Slot<Boolean>(){

                    public void onEmit(Boolean focus) {
                        if (!focus.booleanValue() && dragging) {
                            Pointer.this.forward(0, 0.0, 0.0f, 0.0f, Event.Kind.CANCEL, true);
                            dragging = false;
                        }
                    }
                };

                MouseConverter() {
                }
            }
            MouseConverter mc = new MouseConverter();
            plat.input().mouseEvents.connect(mc.onMouse);
            plat.input().focus.connect(mc.onFocus);
        } else {
            plat.log().warn("Platform has neither mouse nor touch events?", new Object[]{"type", plat.type()});
        }
    }

    protected void forward(Event.XY source, Event.Kind kind, boolean isTouch) {
        this.forward(source.flags, source.time, source.x, source.y, kind, isTouch);
    }

    protected void forward(int flags, double time, float x, float y, Event.Kind kind, boolean isTouch) {
        if (this.enabled && this.events.hasConnections()) {
            Event event = new Event(flags, time, x, y, kind, isTouch);
            this.plat.dispatchEvent(this.events, event);
        }
    }

    public static class Event
    extends Event.XY {
        public final Kind kind;
        public boolean isTouch;

        public Event(int flags, double time, float x, float y, Kind kind, boolean isTouch) {
            super(flags, time, x, y);
            this.kind = kind;
            this.isTouch = isTouch;
        }

        @Override
        protected String name() {
            return "Pointer";
        }

        @Override
        protected void addFields(StringBuilder builder) {
            super.addFields(builder);
            builder.append(", kind=").append((Object)this.kind);
            builder.append(", touch=").append(this.isTouch);
        }

        public static enum Kind {
            START(true, false),
            DRAG(false, false),
            END(false, true),
            CANCEL(false, true);

            public final boolean isStart;
            public final boolean isEnd;

            private Kind(boolean isStart, boolean isEnd) {
                this.isStart = isStart;
                this.isEnd = isEnd;
            }
        }
    }
}

