/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import playn.core.Event;
import playn.core.Key;
import playn.core.Keyboard;
import playn.core.Mouse;
import playn.core.Platform;
import playn.core.Touch;
import react.RFuture;
import react.Signal;

public class Input {
    private Platform plat;
    public boolean mouseEnabled = true;
    public boolean touchEnabled = true;
    public boolean keyboardEnabled = true;
    public Signal<Mouse.Event> mouseEvents = Signal.create();
    public Signal<Touch.Event[]> touchEvents = Signal.create();
    public Signal<Keyboard.Event> keyboardEvents = Signal.create();
    public Signal<Boolean> focus = Signal.create();

    public boolean hasMouse() {
        return false;
    }

    public boolean hasTouch() {
        return false;
    }

    public boolean hasHardwareKeyboard() {
        return false;
    }

    public boolean hasMouseLock() {
        return false;
    }

    public boolean isMouseLocked() {
        return false;
    }

    public void setMouseLocked(boolean locked) {
    }

    public RFuture<String> getText(Keyboard.TextType textType, String label, String initialValue) {
        return this.getText(textType, label, initialValue, "Ok", "Cancel");
    }

    public RFuture<String> getText(Keyboard.TextType textType, String label, String initialValue, String ok, String cancel) {
        return RFuture.failure((Throwable)new Exception("getText not supported"));
    }

    public RFuture<Boolean> sysDialog(String title, String text, String ok, String cancel) {
        return RFuture.failure((Throwable)new Exception("sysDialog not supported"));
    }

    protected Input(Platform plat) {
        this.plat = plat;
    }

    protected int modifierFlags(boolean altP, boolean ctrlP, boolean metaP, boolean shiftP) {
        return Event.Input.modifierFlags(altP, ctrlP, metaP, shiftP);
    }

    protected void emitKeyPress(int flags, double time, Key key, boolean down) {
        if (this.keyboardEnabled) {
            this.plat.dispatchEvent(this.keyboardEvents, new Keyboard.KeyEvent(flags, time, key, down));
        }
    }

    protected void emitKeyTyped(double time, char keyChar) {
        if (this.keyboardEnabled) {
            this.plat.dispatchEvent(this.keyboardEvents, new Keyboard.TypedEvent(0, time, keyChar));
        }
    }

    protected void emitMouseButton(int flags, double time, float x, float y, Mouse.ButtonEvent.Id btn, boolean down) {
        if (this.mouseEnabled) {
            this.plat.dispatchEvent(this.mouseEvents, new Mouse.ButtonEvent(flags, time, x, y, btn, down));
        }
    }

    protected void emitMouseMotion(int flags, double time, float x, float y, float dx, float dy) {
        if (this.mouseEnabled) {
            this.plat.dispatchEvent(this.mouseEvents, new Mouse.MotionEvent(flags, time, x, y, dx, dy));
        }
    }

    protected void emitMouseWheel(int flags, double time, float x, float y, int delta) {
        if (this.mouseEnabled) {
            this.plat.dispatchEvent(this.mouseEvents, new Mouse.WheelEvent(flags, time, x, y, delta));
        }
    }
}

