/*
 * Decompiled with CFR 0.152.
 */
package playn.core.json;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Stack;
import playn.core.Json;
import playn.core.json.JsonSink;
import playn.core.json.JsonStringWriter;
import playn.core.json.JsonTypes;
import playn.core.json.JsonWriterException;

class JsonWriterBase<SELF extends JsonSink<SELF>>
implements JsonSink<SELF> {
    protected final Appendable appendable;
    private Stack<Boolean> states = new Stack();
    private boolean first = true;
    private boolean inObject;
    private boolean verboseFormat;

    JsonWriterBase(Appendable appendable) {
        this.appendable = appendable;
    }

    private SELF castThis() {
        return (SELF)this;
    }

    public SELF useVerboseFormat(boolean verboseFormat) {
        this.verboseFormat = verboseFormat;
        return this.castThis();
    }

    @Override
    public SELF array(Collection<?> c) {
        return this.array(null, c);
    }

    @Override
    public SELF array(Json.Array c) {
        return this.array(null, c);
    }

    @Override
    public SELF array(String key, Collection<?> c) {
        if (key == null) {
            this.array();
        } else {
            this.array(key);
        }
        for (Object o : c) {
            this.value(o);
        }
        return this.end();
    }

    @Override
    public SELF array(String key, Json.Array c) {
        if (key == null) {
            this.array();
        } else {
            this.array(key);
        }
        c.write(this);
        return this.end();
    }

    @Override
    public SELF object(Map<?, ?> map) {
        return this.object(null, map);
    }

    @Override
    public SELF object(Json.Object map) {
        return this.object(null, map);
    }

    @Override
    public SELF object(String key, Map<?, ?> map) {
        if (key == null) {
            this.object();
        } else {
            this.object(key);
        }
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            Object o = entry.getValue();
            if (!(entry.getKey() instanceof String)) {
                throw new JsonWriterException("Invalid key type for map: " + (entry.getKey() == null ? "null" : entry.getKey().getClass()));
            }
            String k = (String)entry.getKey();
            this.value(k, o);
        }
        return this.end();
    }

    @Override
    public SELF object(String key, Json.Object obj) {
        if (key == null) {
            this.object();
        } else {
            this.object(key);
        }
        obj.write(this);
        return this.end();
    }

    @Override
    public SELF nul() {
        this.preValue();
        this.raw("null");
        return this.castThis();
    }

    @Override
    public SELF nul(String key) {
        this.preValue(key);
        this.raw("null");
        return this.castThis();
    }

    @Override
    public SELF value(Object o) {
        if (o == null) {
            return this.nul();
        }
        if (o instanceof String) {
            return this.value((String)o);
        }
        if (o instanceof Number) {
            return this.value((Number)o);
        }
        if (o instanceof Boolean) {
            return this.value((Boolean)o);
        }
        if (o instanceof Collection) {
            return this.array((Collection)o);
        }
        if (o instanceof Map) {
            return this.object((Map)o);
        }
        if (JsonTypes.isArray(o)) {
            return this.array((Json.Array)o);
        }
        if (JsonTypes.isObject(o)) {
            return this.object((Json.Object)o);
        }
        throw new JsonWriterException("Unable to handle type: " + o.getClass());
    }

    @Override
    public SELF value(String key, Object o) {
        if (o == null) {
            return this.nul(key);
        }
        if (o instanceof String) {
            return this.value(key, (String)o);
        }
        if (o instanceof Number) {
            return this.value(key, (Number)o);
        }
        if (o instanceof Boolean) {
            return this.value(key, (Boolean)o);
        }
        if (o instanceof Collection) {
            return this.array(key, (Collection)o);
        }
        if (o instanceof Map) {
            return this.object(key, (Map)o);
        }
        if (JsonTypes.isArray(o)) {
            return this.array(key, (Json.Array)o);
        }
        if (JsonTypes.isObject(o)) {
            return this.object(key, (Json.Object)o);
        }
        throw new JsonWriterException("Unable to handle type: " + o.getClass());
    }

    @Override
    public SELF value(String s) {
        if (s == null) {
            return this.nul();
        }
        this.preValue();
        this.emitStringValue(s);
        return this.castThis();
    }

    @Override
    public SELF value(boolean b) {
        this.preValue();
        this.raw(Boolean.toString(b));
        return this.castThis();
    }

    @Override
    public SELF value(Number n) {
        this.preValue();
        if (n == null) {
            this.raw("null");
        } else {
            this.raw(n.toString());
        }
        return this.castThis();
    }

    @Override
    public SELF value(String key, String s) {
        if (s == null) {
            return this.nul(key);
        }
        this.preValue(key);
        this.emitStringValue(s);
        return this.castThis();
    }

    @Override
    public SELF value(String key, boolean b) {
        this.preValue(key);
        this.raw(Boolean.toString(b));
        return this.castThis();
    }

    @Override
    public SELF value(String key, Number n) {
        if (n == null) {
            return this.nul(key);
        }
        this.preValue(key);
        this.raw(n.toString());
        return this.castThis();
    }

    @Override
    public SELF array() {
        this.preValue();
        this.states.push(this.inObject);
        this.inObject = false;
        this.first = true;
        this.raw('[');
        if (this.verboseFormat) {
            this.raw('\n');
        }
        return this.castThis();
    }

    @Override
    public SELF object() {
        this.preValue();
        this.states.push(this.inObject);
        this.inObject = true;
        this.first = true;
        this.raw('{');
        if (this.verboseFormat) {
            this.raw('\n');
        }
        return this.castThis();
    }

    @Override
    public SELF array(String key) {
        this.preValue(key);
        this.states.push(this.inObject);
        this.inObject = false;
        this.first = true;
        this.raw('[');
        if (this.verboseFormat) {
            this.raw('\n');
        }
        return this.castThis();
    }

    @Override
    public SELF object(String key) {
        this.preValue(key);
        this.states.push(this.inObject);
        this.inObject = true;
        this.first = true;
        this.raw('{');
        if (this.verboseFormat) {
            this.raw('\n');
        }
        return this.castThis();
    }

    @Override
    public SELF end() {
        if (this.states.size() == 0) {
            throw new JsonWriterException("Invalid call to end()");
        }
        boolean wasInObject = this.inObject;
        this.first = false;
        this.inObject = this.states.pop();
        if (this.verboseFormat) {
            this.raw('\n');
            this.indent();
        }
        if (wasInObject) {
            this.raw('}');
        } else {
            this.raw(']');
        }
        return this.castThis();
    }

    protected void doneInternal() {
        if (this.states.size() > 0) {
            throw new JsonWriterException("Unclosed JSON objects and/or arrays when closing writer");
        }
        if (this.first) {
            throw new JsonWriterException("Nothing was written to the JSON writer");
        }
    }

    private void indent() {
        for (int level = 0; level < this.states.size(); ++level) {
            this.raw("  ");
        }
    }

    private void raw(String s) {
        try {
            this.appendable.append(s);
        }
        catch (IOException e) {
            throw new JsonWriterException(e);
        }
    }

    private void raw(char c) {
        try {
            this.appendable.append(c);
        }
        catch (IOException e) {
            throw new JsonWriterException(e);
        }
    }

    private void pre() {
        if (this.first) {
            this.first = false;
        } else {
            if (this.states.size() == 0) {
                throw new JsonWriterException("Invalid call to emit a value in a finished JSON writer");
            }
            this.raw(',');
            if (this.verboseFormat) {
                this.raw('\n');
            }
        }
        if (this.verboseFormat) {
            this.indent();
        }
    }

    private void preValue() {
        if (this.inObject) {
            throw new JsonWriterException("Invalid call to emit a keyless value while writing an object");
        }
        this.pre();
    }

    private void preValue(String key) {
        if (!this.inObject) {
            throw new JsonWriterException("Invalid call to emit a key value while not writing an object");
        }
        this.pre();
        this.emitStringValue(key);
        this.raw(':');
    }

    private void emitStringValue(String s) {
        this.raw('\"');
        char b = '\u0000';
        char c = '\u0000';
        block9: for (int i = 0; i < s.length(); ++i) {
            b = c;
            c = s.charAt(i);
            switch (c) {
                case '\"': 
                case '\\': {
                    this.raw('\\');
                    this.raw(c);
                    continue block9;
                }
                case '/': {
                    if (b == '<') {
                        this.raw('\\');
                    }
                    this.raw(c);
                    continue block9;
                }
                case '\b': {
                    this.raw("\\b");
                    continue block9;
                }
                case '\t': {
                    this.raw("\\t");
                    continue block9;
                }
                case '\n': {
                    this.raw("\\n");
                    continue block9;
                }
                case '\f': {
                    this.raw("\\f");
                    continue block9;
                }
                case '\r': {
                    this.raw("\\r");
                    continue block9;
                }
                default: {
                    if (this.shouldBeEscaped(c)) {
                        String t = "000" + Integer.toHexString(c);
                        this.raw("\\u" + t.substring(t.length() - "0000".length()));
                        continue block9;
                    }
                    this.raw(c);
                }
            }
        }
        this.raw('\"');
    }

    private boolean shouldBeEscaped(char c) {
        return c < ' ' || c >= '\u0080' && c < '\u00a0' || c >= '\u2000' && c < '\u2100';
    }

    static String escape(String s) {
        String json = ((Json.Writer)new JsonStringWriter().value(s)).write();
        return json.substring(1, json.length() - 1);
    }
}

