/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import playn.core.Font;

public class TextFormat {
    public final Font font;
    public final boolean antialias;

    public TextFormat() {
        this(null);
    }

    public TextFormat(Font font) {
        this(font, true);
    }

    public TextFormat(Font font, boolean antialias) {
        this.font = font;
        this.antialias = antialias;
    }

    public TextFormat withFont(Font font) {
        return new TextFormat(font, this.antialias);
    }

    public TextFormat withFont(String name, Font.Style style, float size) {
        return this.withFont(new Font(name, style, size));
    }

    public TextFormat withFont(String name, float size) {
        return this.withFont(new Font(name, size));
    }

    public TextFormat withAntialias(boolean antialias) {
        return new TextFormat(this.font, antialias);
    }

    public String toString() {
        return "[font=" + this.font + ", antialias=" + this.antialias + "]";
    }

    public boolean equals(Object other) {
        if (other instanceof TextFormat) {
            TextFormat ofmt = (TextFormat)other;
            return (this.font == ofmt.font || this.font != null && this.font.equals(ofmt.font)) && this.antialias == ofmt.antialias;
        }
        return false;
    }

    public int hashCode() {
        int hash;
        int n = hash = this.antialias ? 1 : 0;
        if (this.font != null) {
            hash ^= this.font.hashCode();
        }
        return hash;
    }
}

