/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import java.util.ArrayList;
import java.util.List;
import pythagoras.f.MathUtil;

public class Scale {
    public static final Scale ONE = new Scale(1.0f);
    public final float factor;

    public Scale(float factor) {
        assert (factor > 0.0f) : "Scale factor must be > 0.";
        this.factor = factor;
    }

    public float scaled(float length) {
        return this.factor * length;
    }

    public int scaledCeil(float length) {
        return MathUtil.iceil((float)this.scaled(length));
    }

    public int scaledFloor(float length) {
        return MathUtil.ifloor((float)this.scaled(length));
    }

    public float invScaled(float length) {
        return length / this.factor;
    }

    public int invScaledFloor(float length) {
        return MathUtil.ifloor((float)this.invScaled(length));
    }

    public int invScaledCeil(float length) {
        return MathUtil.iceil((float)this.invScaled(length));
    }

    public List<ScaledResource> getScaledResources(String path) {
        ArrayList<ScaledResource> rsrcs = new ArrayList<ScaledResource>();
        rsrcs.add(new ScaledResource(this, this.computePath(path, this.factor)));
        for (float rscale = (float)MathUtil.ifloor((float)this.factor); rscale > 1.0f; rscale -= 1.0f) {
            if (rscale == this.factor) continue;
            rsrcs.add(new ScaledResource(new Scale(rscale), this.computePath(path, rscale)));
        }
        rsrcs.add(new ScaledResource(ONE, path));
        return rsrcs;
    }

    public String toString() {
        return "x" + this.factor;
    }

    private String computePath(String path, float scale) {
        int didx;
        if (scale <= 1.0f) {
            return path;
        }
        int scaleFactor = (int)(scale * 10.0f);
        if (scaleFactor % 10 == 0) {
            scaleFactor /= 10;
        }
        if ((didx = path.lastIndexOf(".")) == -1) {
            return path;
        }
        return path.substring(0, didx) + "@" + scaleFactor + "x" + path.substring(didx);
    }

    public static class ScaledResource {
        public final Scale scale;
        public final String path;

        public ScaledResource(Scale scale, String path) {
            this.scale = scale;
            this.path = path;
        }

        public String toString() {
            return this.scale + ": " + this.path;
        }
    }
}

