/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

public abstract class Event {
    public static final int F_PREVENT_DEFAULT = 1;
    protected static final int F_ALT_DOWN = 2;
    protected static final int F_CTRL_DOWN = 4;
    protected static final int F_SHIFT_DOWN = 8;
    protected static final int F_META_DOWN = 16;

    public static class XY
    extends Input
    implements pythagoras.f.XY {
        public final float x;
        public final float y;

        public float x() {
            return this.x;
        }

        public float y() {
            return this.y;
        }

        protected XY(int flags, double time, float x, float y) {
            super(flags, time);
            this.x = x;
            this.y = y;
        }

        @Override
        protected String name() {
            return "XY";
        }

        @Override
        protected void addFields(StringBuilder builder) {
            super.addFields(builder);
            builder.append(", x=").append(this.x).append(", y=").append(this.y);
        }
    }

    public static class Input
    extends Event {
        public int flags;
        public final double time;

        public boolean isAltDown() {
            return this.isSet(2);
        }

        public boolean isCtrlDown() {
            return this.isSet(4);
        }

        public boolean isShiftDown() {
            return this.isSet(8);
        }

        public boolean isMetaDown() {
            return this.isSet(16);
        }

        public boolean isSet(int flag) {
            return (this.flags & flag) != 0;
        }

        public void setFlag(int flag) {
            this.flags |= flag;
        }

        public void clearFlag(int flag) {
            this.flags &= ~flag;
        }

        public void updateFlag(int flag, boolean on) {
            if (on) {
                this.setFlag(flag);
            } else {
                this.clearFlag(flag);
            }
        }

        public String toString() {
            StringBuilder builder = new StringBuilder(this.name()).append('[');
            this.addFields(builder);
            return builder.append(']').toString();
        }

        public static int modifierFlags(boolean altP, boolean ctrlP, boolean metaP, boolean shiftP) {
            int flags = 0;
            if (altP) {
                flags |= 2;
            }
            if (ctrlP) {
                flags |= 4;
            }
            if (metaP) {
                flags |= 0x10;
            }
            if (shiftP) {
                flags |= 8;
            }
            return flags;
        }

        protected Input(int flags, double time) {
            this.flags = flags;
            this.time = time;
        }

        protected String name() {
            return "Input";
        }

        protected void addFields(StringBuilder builder) {
            builder.append("time=").append(this.time).append(", flags=").append(this.flags);
        }
    }
}

