/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import playn.core.Gradient;
import playn.core.Graphics;
import playn.core.Image;
import playn.core.Path;
import playn.core.Pattern;
import playn.core.TextLayout;
import playn.core.Texture;
import react.Closeable;

public abstract class Canvas
implements Closeable {
    public final Image image;
    public final float width;
    public final float height;
    protected boolean isDirty;
    protected final Graphics gfx;

    public abstract Image snapshot();

    public void close() {
    }

    public abstract Canvas clear();

    public abstract Canvas clearRect(float var1, float var2, float var3, float var4);

    public abstract Canvas clip(Path var1);

    public abstract Canvas clipRect(float var1, float var2, float var3, float var4);

    public Path createPath() {
        return this.gfx.createPath();
    }

    public Gradient createGradient(Gradient.Config config) {
        return this.gfx.createGradient(config);
    }

    public Canvas draw(Drawable image, float x, float y) {
        return this.draw(image, x, y, image.width(), image.height());
    }

    public Canvas drawCentered(Drawable image, float x, float y) {
        return this.draw(image, x - image.width() / 2.0f, y - image.height() / 2.0f);
    }

    public Canvas draw(Drawable image, float x, float y, float w, float h) {
        image.draw(this.gc(), x, y, w, h);
        this.isDirty = true;
        return this;
    }

    public Canvas draw(Drawable image, float dx, float dy, float dw, float dh, float sx, float sy, float sw, float sh) {
        image.draw(this.gc(), dx, dy, dw, dh, sx, sy, sw, sh);
        this.isDirty = true;
        return this;
    }

    public abstract Canvas drawLine(float var1, float var2, float var3, float var4);

    public abstract Canvas drawPoint(float var1, float var2);

    public abstract Canvas drawArc(float var1, float var2, float var3, float var4, float var5);

    public abstract Canvas drawText(String var1, float var2, float var3);

    public abstract Canvas fillCircle(float var1, float var2, float var3);

    public abstract Canvas fillPath(Path var1);

    public abstract Canvas fillRect(float var1, float var2, float var3, float var4);

    public abstract Canvas fillRoundRect(float var1, float var2, float var3, float var4, float var5);

    public abstract Canvas fillText(TextLayout var1, float var2, float var3);

    public abstract Canvas restore();

    public abstract Canvas rotate(float var1);

    public abstract Canvas save();

    public abstract Canvas scale(float var1, float var2);

    public abstract Canvas setAlpha(float var1);

    public abstract Canvas setCompositeOperation(Composite var1);

    public abstract Canvas setFillColor(int var1);

    public abstract Canvas setFillGradient(Gradient var1);

    public abstract Canvas setFillPattern(Pattern var1);

    public abstract Canvas setLineCap(LineCap var1);

    public abstract Canvas setLineJoin(LineJoin var1);

    public abstract Canvas setMiterLimit(float var1);

    public abstract Canvas setStrokeColor(int var1);

    public abstract Canvas setStrokeWidth(float var1);

    public abstract Canvas strokeCircle(float var1, float var2, float var3);

    public abstract Canvas strokePath(Path var1);

    public abstract Canvas strokeRect(float var1, float var2, float var3, float var4);

    public abstract Canvas strokeRoundRect(float var1, float var2, float var3, float var4, float var5);

    public abstract Canvas strokeText(TextLayout var1, float var2, float var3);

    public Texture toTexture() {
        return this.toTexture(Texture.Config.DEFAULT);
    }

    public Texture toTexture(Texture.Config config) {
        try {
            Texture texture = this.image.createTexture(config);
            return texture;
        }
        finally {
            this.close();
        }
    }

    public abstract Canvas transform(float var1, float var2, float var3, float var4, float var5, float var6);

    public abstract Canvas translate(float var1, float var2);

    protected Canvas(Graphics gfx, Image image) {
        this.gfx = gfx;
        this.image = image;
        this.width = image.width();
        this.height = image.height();
        if (this.width <= 0.0f || this.height <= 0.0f) {
            throw new IllegalArgumentException("Canvas must be > 0 in width and height: " + this.width + "x" + this.height);
        }
    }

    protected abstract Object gc();

    public static interface Drawable {
        public float width();

        public float height();

        public void draw(Object var1, float var2, float var3, float var4, float var5);

        public void draw(Object var1, float var2, float var3, float var4, float var5, float var6, float var7, float var8, float var9);
    }

    public static enum LineJoin {
        BEVEL,
        MITER,
        ROUND;

    }

    public static enum LineCap {
        BUTT,
        ROUND,
        SQUARE;

    }

    public static enum Composite {
        SRC,
        DST_ATOP,
        SRC_OVER,
        DST_OVER,
        SRC_IN,
        DST_IN,
        SRC_OUT,
        DST_OUT,
        SRC_ATOP,
        XOR,
        MULTIPLY;

    }
}

