/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

public class Color {
    public static int argb(int a, int r, int g, int b) {
        return a << 24 | r << 16 | g << 8 | b;
    }

    public static int rgb(int r, int g, int b) {
        return Color.argb(255, r, g, b);
    }

    public static final int alpha(int color) {
        return color >> 24 & 0xFF;
    }

    public static final int red(int color) {
        return color >> 16 & 0xFF;
    }

    public static final int green(int color) {
        return color >> 8 & 0xFF;
    }

    public static final int blue(int color) {
        return color & 0xFF;
    }

    public static int withAlpha(int color, int alpha) {
        return color & 0xFFFFFF | alpha << 24;
    }

    public static float encode(float upper, float lower) {
        int upquant = (int)(upper * 255.0f);
        int lowquant = (int)(lower * 255.0f);
        return upquant * 256 + lowquant;
    }

    public static float decodeUpper(float encoded) {
        float lower = encoded % 256.0f;
        return (encoded - lower) / 255.0f;
    }

    public static float decodeLower(float encoded) {
        return encoded % 256.0f / 255.0f;
    }
}

