/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import java.util.HashMap;
import java.util.Map;
import playn.core.Storage;

public class BatchImpl
implements Storage.Batch {
    protected final Storage storage;
    private Map<String, String> updates = new HashMap<String, String>();

    public BatchImpl(Storage storage) {
        this.storage = storage;
    }

    @Override
    public void setItem(String key, String data) {
        this.updates.put(key, data);
    }

    @Override
    public void removeItem(String key) {
        this.updates.put(key, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void commit() {
        try {
            this.onBeforeCommit();
            for (Map.Entry<String, String> entry : this.updates.entrySet()) {
                String key = entry.getKey();
                String data = entry.getValue();
                if (data == null) {
                    this.removeImpl(key);
                    continue;
                }
                this.setImpl(key, data);
            }
            this.onAfterCommit();
        }
        finally {
            this.updates = null;
        }
    }

    protected void onBeforeCommit() {
    }

    protected void setImpl(String key, String data) {
        this.storage.setItem(key, data);
    }

    protected void removeImpl(String key) {
        this.storage.removeItem(key);
    }

    protected void onAfterCommit() {
    }
}

