/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import java.util.ArrayList;
import java.util.List;
import playn.core.Graphics;
import playn.core.QuadBatch;
import playn.core.RenderTarget;
import playn.core.Texture;
import playn.core.Tile;
import playn.core.Tint;
import pythagoras.f.AffineTransform;
import pythagoras.f.FloatMath;
import pythagoras.f.MathUtil;
import pythagoras.f.Transform;
import pythagoras.f.Transforms;
import pythagoras.f.XY;
import pythagoras.i.Rectangle;
import react.Closeable;

public class Surface
implements Closeable {
    private final List<AffineTransform> transformStack = new ArrayList<AffineTransform>();
    private final Texture colorTex;
    protected final RenderTarget target;
    private final List<Rectangle> scissors = new ArrayList<Rectangle>();
    private int scissorDepth;
    private QuadBatch batch;
    private int fillColor;
    private int tint = -1;
    private Texture patternTex;
    private AffineTransform lastTrans;

    public Surface(Graphics gfx, RenderTarget target, QuadBatch defaultBatch) {
        this.target = target;
        this.batch = defaultBatch;
        this.lastTrans = new AffineTransform();
        this.transformStack.add(this.lastTrans);
        this.colorTex = gfx.colorTex();
        this.scale(target.xscale(), target.yscale());
    }

    public Surface begin() {
        this.target.bind();
        this.beginBatch(this.batch);
        return this;
    }

    public Surface end() {
        this.batch.end();
        return this;
    }

    public QuadBatch pushBatch(QuadBatch newBatch) {
        if (newBatch == null) {
            return null;
        }
        QuadBatch oldBatch = this.batch;
        this.batch.end();
        this.batch = this.beginBatch(newBatch);
        return oldBatch;
    }

    public void popBatch(QuadBatch oldBatch) {
        if (oldBatch != null) {
            this.batch.end();
            this.batch = this.beginBatch(oldBatch);
        }
    }

    public AffineTransform tx() {
        return this.lastTrans;
    }

    public Surface saveTx() {
        this.lastTrans = this.lastTrans.copy();
        this.transformStack.add(this.lastTrans);
        return this;
    }

    public Surface restoreTx() {
        int tsSize = this.transformStack.size();
        assert (tsSize > 1) : "Unbalanced save/restore";
        this.transformStack.remove(--tsSize);
        this.lastTrans = this.transformStack.isEmpty() ? null : this.transformStack.get(tsSize - 1);
        return this;
    }

    public boolean startClipped(int x, int y, int width, int height) {
        this.batch.flush();
        Rectangle r = this.pushScissorState(x, this.target.height() - y - height, width, height);
        this.batch.gl.glScissor(r.x, r.y, r.width, r.height);
        if (this.scissorDepth == 1) {
            this.batch.gl.glEnable(3089);
        }
        this.batch.gl.checkError("startClipped");
        return !r.isEmpty();
    }

    public void endClipped() {
        this.batch.flush();
        Rectangle r = this.popScissorState();
        if (r == null) {
            this.batch.gl.glDisable(3089);
        } else {
            this.batch.gl.glScissor(r.x, r.y, r.width, r.height);
        }
        this.batch.gl.checkError("endClipped");
    }

    public Surface translate(float x, float y) {
        this.tx().translate(x, y);
        return this;
    }

    public Surface scale(float sx, float sy) {
        this.tx().scale(sx, sy);
        return this;
    }

    public Surface rotate(float angle) {
        float sr = (float)Math.sin(angle);
        float cr = (float)Math.cos(angle);
        this.transform(cr, sr, -sr, cr, 0.0f, 0.0f);
        return this;
    }

    public Surface transform(float m00, float m01, float m10, float m11, float tx, float ty) {
        AffineTransform top = this.tx();
        Transforms.multiply((AffineTransform)top, (float)m00, (float)m01, (float)m10, (float)m11, (float)tx, (float)ty, (Transform)top);
        return this;
    }

    public Surface concatenate(AffineTransform xf, float originX, float originY) {
        AffineTransform txf = this.tx();
        Transforms.multiply((AffineTransform)txf, (float)xf.m00, (float)xf.m01, (float)xf.m10, (float)xf.m11, (float)xf.tx, (float)xf.ty, (Transform)txf);
        if (originX != 0.0f || originY != 0.0f) {
            txf.translate(-originX, -originY);
        }
        return this;
    }

    public Surface preConcatenate(AffineTransform xf) {
        AffineTransform txf = this.tx();
        Transforms.multiply((float)xf.m00, (float)xf.m01, (float)xf.m10, (float)xf.m11, (float)xf.tx, (float)xf.ty, (AffineTransform)txf, (Transform)txf);
        return this;
    }

    public float alpha() {
        return (float)(this.tint >> 24 & 0xFF) / 255.0f;
    }

    public Surface setAlpha(float alpha) {
        int ialpha = (int)(255.0f * MathUtil.clamp((float)alpha, (float)0.0f, (float)1.0f));
        this.tint = ialpha << 24 | this.tint & 0xFFFFFF;
        return this;
    }

    public int tint() {
        return this.tint;
    }

    public Surface setTint(int tint) {
        this.tint = tint;
        return this;
    }

    public int combineTint(int tint) {
        int otint = this.tint;
        if (tint != -1) {
            this.tint = Tint.combine(tint, otint);
        }
        return otint;
    }

    public Surface setFillColor(int color) {
        this.fillColor = color;
        this.patternTex = null;
        return this;
    }

    public Surface setFillPattern(Texture texture) {
        this.patternTex = texture;
        return this;
    }

    public Surface clear() {
        return this.clear(0.0f, 0.0f, 0.0f, 0.0f);
    }

    public Surface clear(float red, float green, float blue, float alpha) {
        this.batch.gl.glClearColor(red, green, blue, alpha);
        this.batch.gl.glClear(16384);
        return this;
    }

    public Surface draw(Tile tile, float x, float y) {
        return this.draw(tile, x, y, tile.width(), tile.height());
    }

    public Surface draw(Tile tile, float x, float y, float w, float h) {
        tile.addToBatch(this.batch, this.tint, this.tx(), x, y, w, h);
        return this;
    }

    public Surface draw(Tile tile, float dx, float dy, float dw, float dh, float sx, float sy, float sw, float sh) {
        tile.addToBatch(this.batch, this.tint, this.tx(), dx, dy, dw, dh, sx, sy, sw, sh);
        return this;
    }

    public Surface drawCentered(Tile tile, float x, float y) {
        return this.draw(tile, x - tile.width() / 2.0f, y - tile.height() / 2.0f);
    }

    public Surface drawLine(XY a, XY b, float width) {
        return this.drawLine(a.x(), a.y(), b.x(), b.y(), width);
    }

    public Surface drawLine(float x0, float y0, float x1, float y1, float width) {
        if (x1 < x0) {
            float temp = x0;
            x0 = x1;
            x1 = temp;
            temp = y0;
            y0 = y1;
            y1 = temp;
        }
        float dx = x1 - x0;
        float dy = y1 - y0;
        float length = FloatMath.sqrt((float)(dx * dx + dy * dy));
        float wx = dx * (width / 2.0f) / length;
        float wy = dy * (width / 2.0f) / length;
        AffineTransform xf = new AffineTransform();
        xf.setRotation(FloatMath.atan2((float)dy, (float)dx));
        xf.setTranslation(x0 + wy, y0 - wx);
        Transforms.multiply((AffineTransform)this.tx(), (AffineTransform)xf, (Transform)xf);
        if (this.patternTex != null) {
            this.batch.addQuad(this.patternTex, this.tint, xf, 0.0f, 0.0f, length, width);
        } else {
            this.batch.addQuad(this.colorTex, Tint.combine(this.fillColor, this.tint), xf, 0.0f, 0.0f, length, width);
        }
        return this;
    }

    public Surface fillRect(float x, float y, float width, float height) {
        if (this.patternTex != null) {
            this.batch.addQuad(this.patternTex, this.tint, this.tx(), x, y, width, height);
        } else {
            this.batch.addQuad(this.colorTex, Tint.combine(this.fillColor, this.tint), this.tx(), x, y, width, height);
        }
        return this;
    }

    public void close() {
    }

    private QuadBatch beginBatch(QuadBatch batch) {
        batch.begin(this.target.width(), this.target.height(), this.target.flip());
        return batch;
    }

    private Rectangle pushScissorState(int x, int y, int width, int height) {
        if (this.scissorDepth == this.scissors.size()) {
            this.scissors.add(new Rectangle());
        }
        Rectangle r = this.scissors.get(this.scissorDepth);
        if (this.scissorDepth == 0) {
            r.setBounds(x, y, width, height);
        } else {
            Rectangle pr = this.scissors.get(this.scissorDepth - 1);
            r.setLocation(Math.max(pr.x, x), Math.max(pr.y, y));
            r.setSize(Math.max(Math.min(pr.maxX(), x + width - 1) - r.x, 0), Math.max(Math.min(pr.maxY(), y + height - 1) - r.y, 0));
        }
        ++this.scissorDepth;
        return r;
    }

    private Rectangle popScissorState() {
        --this.scissorDepth;
        return this.scissorDepth == 0 ? null : this.scissors.get(this.scissorDepth - 1);
    }
}

