/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import playn.core.GL20;
import playn.core.GLProgram;
import playn.core.QuadBatch;
import playn.core.TexturedBatch;

public class UniformQuadBatch
extends QuadBatch {
    protected final int maxQuads;
    protected final GLProgram program;
    protected final int uTexture;
    protected final int uHScreenSize;
    protected final int uFlip;
    protected final int uData;
    protected final int aVertex;
    protected final int verticesId;
    protected final int elementsId;
    protected final float[] data;
    protected int quadCounter;
    private static final int VERTICES_PER_QUAD = 4;
    private static final int ELEMENTS_PER_QUAD = 6;
    private static final int VERTEX_SIZE = 3;
    private static final int BASE_VEC4S_PER_QUAD = 3;

    public static boolean isLikelyToPerform(GL20 gl) {
        int maxVecs = UniformQuadBatch.usableMaxUniformVectors(gl);
        return maxVecs >= 48;
    }

    public UniformQuadBatch(GL20 gl) {
        this(gl, new Source());
    }

    public UniformQuadBatch(GL20 gl, Source source) {
        super(gl);
        int maxVecs = UniformQuadBatch.usableMaxUniformVectors(gl) - this.extraVec4s();
        if (maxVecs < this.vec4sPerQuad()) {
            throw new RuntimeException("GL_MAX_VERTEX_UNIFORM_VECTORS too low: have " + maxVecs + ", need at least " + this.vec4sPerQuad());
        }
        this.maxQuads = maxVecs / this.vec4sPerQuad();
        this.program = new GLProgram(gl, source.vertex(this), source.fragment());
        this.uTexture = this.program.getUniformLocation("u_Texture");
        this.uHScreenSize = this.program.getUniformLocation("u_HScreenSize");
        this.uFlip = this.program.getUniformLocation("u_Flip");
        this.uData = this.program.getUniformLocation("u_Data");
        this.aVertex = this.program.getAttribLocation("a_Vertex");
        short[] verts = new short[this.maxQuads * 4 * 3];
        short[] elems = new short[this.maxQuads * 6];
        int vv = 0;
        int ee = 0;
        for (int ii = 0; ii < this.maxQuads; ii = (int)((short)(ii + 1))) {
            short base;
            verts[vv++] = 0;
            verts[vv++] = 0;
            verts[vv++] = ii;
            verts[vv++] = 1;
            verts[vv++] = 0;
            verts[vv++] = ii;
            verts[vv++] = 0;
            verts[vv++] = 1;
            verts[vv++] = ii;
            verts[vv++] = 1;
            verts[vv++] = 1;
            verts[vv++] = ii;
            short base0 = base = (short)(ii * 4);
            short base1 = base = (short)(base + 1);
            short base2 = base = (short)(base + 1);
            short base3 = base = (short)(base + 1);
            elems[ee++] = base0;
            elems[ee++] = base1;
            elems[ee++] = base2;
            elems[ee++] = base1;
            elems[ee++] = base3;
            elems[ee++] = base2;
        }
        this.data = new float[this.maxQuads * this.vec4sPerQuad() * 4];
        int[] ids = new int[2];
        gl.glGenBuffers(2, ids, 0);
        this.verticesId = ids[0];
        this.elementsId = ids[1];
        gl.glBindBuffer(34962, this.verticesId);
        gl.bufs.setShortBuffer(verts, 0, verts.length);
        gl.glBufferData(34962, verts.length * 2, gl.bufs.shortBuffer, 35044);
        gl.glBindBuffer(34963, this.elementsId);
        gl.bufs.setShortBuffer(elems, 0, elems.length);
        gl.glBufferData(34963, elems.length * 2, gl.bufs.shortBuffer, 35044);
        gl.checkError("UniformQuadBatch end ctor");
    }

    @Override
    public void addQuad(int tint, float m00, float m01, float m10, float m11, float tx, float ty, float x1, float y1, float sx1, float sy1, float x2, float y2, float sx2, float sy2, float x3, float y3, float sx3, float sy3, float x4, float y4, float sx4, float sy4) {
        int pos = this.quadCounter * this.vec4sPerQuad() * 4;
        float dw = x2 - x1;
        float dh = y3 - y1;
        this.data[pos++] = m00 * dw;
        this.data[pos++] = m01 * dw;
        this.data[pos++] = m10 * dh;
        this.data[pos++] = m11 * dh;
        this.data[pos++] = tx + m00 * x1 + m10 * y1;
        this.data[pos++] = ty + m01 * x1 + m11 * y1;
        this.data[pos++] = sx1;
        this.data[pos++] = sy1;
        this.data[pos++] = sx2 - sx1;
        this.data[pos++] = sy3 - sy1;
        this.data[pos++] = tint >> 16 & 0xFFFF;
        this.data[pos++] = tint & 0xFFFF;
        pos = this.addExtraQuadData(this.data, pos);
        ++this.quadCounter;
        if (this.quadCounter >= this.maxQuads) {
            this.flush();
        }
    }

    @Override
    public void begin(float fbufWidth, float fbufHeight, boolean flip) {
        super.begin(fbufWidth, fbufHeight, flip);
        this.program.activate();
        this.gl.glUniform2f(this.uHScreenSize, fbufWidth / 2.0f, fbufHeight / 2.0f);
        this.gl.glUniform1f(this.uFlip, flip ? -1.0f : 1.0f);
        this.gl.glBindBuffer(34962, this.verticesId);
        this.gl.glEnableVertexAttribArray(this.aVertex);
        this.gl.glVertexAttribPointer(this.aVertex, 3, 5122, false, 0, 0);
        this.gl.glBindBuffer(34963, this.elementsId);
        this.gl.glActiveTexture(33984);
        this.gl.glUniform1i(this.uTexture, 0);
        this.gl.checkError("UniformQuadBatch begin");
    }

    @Override
    public void flush() {
        super.flush();
        if (this.quadCounter > 0) {
            this.bindTexture();
            this.gl.glUniform4fv(this.uData, this.quadCounter * this.vec4sPerQuad(), this.data, 0);
            this.gl.glDrawElements(4, this.quadCounter * 6, 5123, 0);
            this.gl.checkError("UniformQuadBatch flush");
            this.quadCounter = 0;
        }
    }

    @Override
    public void end() {
        super.end();
        this.gl.glDisableVertexAttribArray(this.aVertex);
        this.gl.checkError("UniformQuadBatch end");
    }

    @Override
    public void close() {
        super.close();
        this.program.close();
        this.gl.glDeleteBuffers(2, new int[]{this.verticesId, this.elementsId}, 0);
        this.gl.checkError("UniformQuadBatch close");
    }

    public String toString() {
        return "uquad/" + this.maxQuads;
    }

    protected int vec4sPerQuad() {
        return 3;
    }

    protected int extraVec4s() {
        return 0;
    }

    protected int addExtraQuadData(float[] data, int pos) {
        return pos;
    }

    private static int usableMaxUniformVectors(GL20 gl) {
        int maxVecs = gl.glGetInteger(36347) - 3;
        gl.checkError("glGetInteger(GL_MAX_VERTEX_UNIFORM_VECTORS)");
        return maxVecs;
    }

    public static class Source
    extends TexturedBatch.Source {
        public static final String VERT_UNIFS = "uniform vec2 u_HScreenSize;\nuniform float u_Flip;\nuniform vec4 u_Data[_VEC4S_PER_QUAD_*_MAX_QUADS_];\n";
        public static final String VERT_ATTRS = "attribute vec3 a_Vertex;\n";
        public static final String VERT_VARS = "varying vec2 v_TexCoord;\nvarying vec4 v_Color;\n";
        public static final String VERT_EXTRACTDATA = "int index = _VEC4S_PER_QUAD_*int(a_Vertex.z);\nvec4 mat = u_Data[index+0];\nvec4 txc = u_Data[index+1];\nvec4 tcs = u_Data[index+2];\n";
        public static final String VERT_SETPOS = "mat3 transform = mat3(\n  mat.x, mat.y, 0,\n  mat.z, mat.w, 0,\n  txc.x, txc.y, 1);\ngl_Position = vec4(transform * vec3(a_Vertex.xy, 1.0), 1.0);\ngl_Position.xy /= u_HScreenSize.xy;\ngl_Position.xy -= 1.0;\ngl_Position.y *= u_Flip;\n";
        public static final String VERT_SETTEX = "v_TexCoord = a_Vertex.xy * tcs.xy + txc.zw;\n";
        public static final String VERT_SETCOLOR = "float red = mod(tcs.z, 256.0);\nfloat alpha = (tcs.z - red) / 256.0;\nfloat blue = mod(tcs.w, 256.0);\nfloat green = (tcs.w - blue) / 256.0;\nv_Color = vec4(red / 255.0, green / 255.0, blue / 255.0, alpha / 255.0);\n";

        public String vertex(UniformQuadBatch batch) {
            return this.vertex().replace("_MAX_QUADS_", "" + batch.maxQuads).replace("_VEC4S_PER_QUAD_", "" + batch.vec4sPerQuad());
        }

        protected String vertex() {
            return "uniform vec2 u_HScreenSize;\nuniform float u_Flip;\nuniform vec4 u_Data[_VEC4S_PER_QUAD_*_MAX_QUADS_];\nattribute vec3 a_Vertex;\nvarying vec2 v_TexCoord;\nvarying vec4 v_Color;\nvoid main(void) {\nint index = _VEC4S_PER_QUAD_*int(a_Vertex.z);\nvec4 mat = u_Data[index+0];\nvec4 txc = u_Data[index+1];\nvec4 tcs = u_Data[index+2];\nmat3 transform = mat3(\n  mat.x, mat.y, 0,\n  mat.z, mat.w, 0,\n  txc.x, txc.y, 1);\ngl_Position = vec4(transform * vec3(a_Vertex.xy, 1.0), 1.0);\ngl_Position.xy /= u_HScreenSize.xy;\ngl_Position.xy -= 1.0;\ngl_Position.y *= u_Flip;\nv_TexCoord = a_Vertex.xy * tcs.xy + txc.zw;\nfloat red = mod(tcs.z, 256.0);\nfloat alpha = (tcs.z - red) / 256.0;\nfloat blue = mod(tcs.w, 256.0);\nfloat green = (tcs.w - blue) / 256.0;\nv_Color = vec4(red / 255.0, green / 255.0, blue / 255.0, alpha / 255.0);\n}";
        }
    }
}

