/*
 * Decompiled with CFR 0.152.
 */
package playn.core;

import playn.core.Canvas;
import playn.core.Graphics;
import playn.core.Image;
import playn.core.QuadBatch;
import playn.core.Scale;
import playn.core.Tile;
import pythagoras.f.AffineTransform;
import pythagoras.f.IRectangle;
import react.Closeable;
import react.UnitSlot;

public class Texture
extends Tile
implements Closeable {
    public final int id;
    public final Config config;
    public final int pixelWidth;
    public final int pixelHeight;
    public final Scale scale;
    public final float displayWidth;
    public final float displayHeight;
    private final Graphics gfx;
    private int refs;
    private boolean disposed;

    public static int nextPOT(int value) {
        assert (value < 65536);
        int bit = 32768;
        int highest = -1;
        int count = 0;
        int ii = 15;
        while (ii >= 0) {
            if ((value & bit) != 0) {
                ++count;
                if (highest == -1) {
                    highest = ii;
                }
            }
            --ii;
            bit >>= 1;
        }
        return count > 1 ? 1 << highest + 1 : value;
    }

    public Texture(Graphics gfx, int id, Config config, int pixWidth, int pixHeight, Scale scale, float dispWidth, float dispHeight) {
        this.gfx = gfx;
        this.id = id;
        this.config = config;
        this.pixelWidth = pixWidth;
        this.pixelHeight = pixHeight;
        this.scale = scale;
        this.displayWidth = dispWidth;
        this.displayHeight = dispHeight;
    }

    public void reference() {
        if (this.config.managed) {
            ++this.refs;
        }
    }

    public void release() {
        if (this.config.managed) {
            assert (this.refs > 0) : "Released a texture with no references!";
            if (--this.refs == 0) {
                this.close();
            }
        }
    }

    public void update(Image image) {
        if (this.config.repeatX || this.config.repeatY || this.config.mipmaps) {
            int pixWidth = image.pixelWidth();
            int pixHeight = image.pixelHeight();
            int potWidth = this.config.toTexWidth(pixWidth);
            int potHeight = this.config.toTexWidth(pixHeight);
            if (potWidth != pixWidth || potHeight != pixHeight) {
                Canvas scaled = this.gfx.createCanvasImpl(Scale.ONE, potWidth, potHeight);
                scaled.draw(image, 0.0f, 0.0f, potWidth, potHeight);
                scaled.image.upload(this.gfx, this);
                scaled.close();
            } else {
                image.upload(this.gfx, this);
            }
        } else {
            image.upload(this.gfx, this);
        }
        if (this.config.mipmaps) {
            this.gfx.gl.glGenerateMipmap(3553);
        }
    }

    public Tile tile(IRectangle region) {
        return this.tile(region.x(), region.y(), region.width(), region.height());
    }

    public Tile tile(float x, float y, float width, float height) {
        final float tileX = x;
        final float tileY = y;
        final float tileWidth = width;
        final float tileHeight = height;
        return new Tile(){

            @Override
            public Texture texture() {
                return Texture.this;
            }

            @Override
            public float width() {
                return tileWidth;
            }

            @Override
            public float height() {
                return tileHeight;
            }

            @Override
            public float sx() {
                return tileX / Texture.this.displayWidth;
            }

            @Override
            public float sy() {
                return tileY / Texture.this.displayHeight;
            }

            @Override
            public float tx() {
                return (tileX + tileWidth) / Texture.this.displayHeight;
            }

            @Override
            public float ty() {
                return (tileY + tileWidth) / Texture.this.displayHeight;
            }

            @Override
            public void addToBatch(QuadBatch batch, int tint, AffineTransform tx, float x, float y, float width, float height) {
                batch.addQuad(this.texture(), tint, tx, x, y, width, height, tileX, tileY, tileWidth, tileHeight);
            }

            @Override
            public void addToBatch(QuadBatch batch, int tint, AffineTransform tx, float dx, float dy, float dw, float dh, float sx, float sy, float sw, float sh) {
                batch.addQuad(this.texture(), tint, tx, dx, dy, dw, dh, tileX + sx, tileY + sx, sw, sh);
            }
        };
    }

    public boolean disposed() {
        return this.disposed;
    }

    public UnitSlot disposeSlot() {
        return new UnitSlot(){

            public void onEmit() {
                Texture.this.close();
            }
        };
    }

    @Override
    public Texture texture() {
        return this;
    }

    @Override
    public float width() {
        return this.displayWidth;
    }

    @Override
    public float height() {
        return this.displayHeight;
    }

    @Override
    public float sx() {
        return 0.0f;
    }

    @Override
    public float sy() {
        return 0.0f;
    }

    @Override
    public float tx() {
        return 1.0f;
    }

    @Override
    public float ty() {
        return 1.0f;
    }

    @Override
    public void addToBatch(QuadBatch batch, int tint, AffineTransform tx, float x, float y, float width, float height) {
        batch.addQuad(this, tint, tx, x, y, width, height);
    }

    @Override
    public void addToBatch(QuadBatch batch, int tint, AffineTransform tx, float dx, float dy, float dw, float dh, float sx, float sy, float sw, float sh) {
        batch.addQuad(this, tint, tx, dx, dy, dw, dh, sx, sy, sw, sh);
    }

    public void close() {
        if (!this.disposed) {
            this.disposed = true;
            this.gfx.gl.glDeleteTexture(this.id);
        }
    }

    @Override
    public String toString() {
        return "Texture[id=" + this.id + ", psize=" + this.pixelWidth + "x" + this.pixelHeight + ", dsize=" + this.displayWidth + "x" + this.displayHeight + " @ " + this.scale + ", config=" + this.config + "]";
    }

    protected void finalize() {
        if (!this.disposed) {
            this.gfx.queueForDispose(this);
        }
    }

    public static final class Config {
        public static Config DEFAULT = new Config(true, false, false, 9729, 9729, false);
        public static Config UNMANAGED = new Config(false, false, false, 9729, 9729, false);
        public final boolean managed;
        public final boolean repeatX;
        public final boolean repeatY;
        public final int minFilter;
        public final int magFilter;
        public final boolean mipmaps;

        public Config(boolean managed, boolean repeatX, boolean repeatY, int minFilter, int magFilter, boolean mipmaps) {
            this.managed = managed;
            this.repeatX = repeatX;
            this.repeatY = repeatY;
            this.minFilter = minFilter;
            this.magFilter = magFilter;
            this.mipmaps = mipmaps;
        }

        public Config repeat(boolean repeatX, boolean repeatY) {
            return new Config(this.managed, repeatX, repeatY, this.minFilter, this.magFilter, this.mipmaps);
        }

        public int toTexWidth(int sourceWidth) {
            return this.repeatX || this.mipmaps ? Texture.nextPOT(sourceWidth) : sourceWidth;
        }

        public int toTexHeight(int sourceHeight) {
            return this.repeatY || this.mipmaps ? Texture.nextPOT(sourceHeight) : sourceHeight;
        }

        public String toString() {
            String repstr = (this.repeatX ? "x" : "") + (this.repeatY ? "y" : "");
            return "[managed=" + this.managed + ", repeat=" + repstr + ", filter=" + this.minFilter + "/" + this.magFilter + ", mipmaps=" + this.mipmaps + "]";
        }
    }
}

